{ sample program to show PCX file }
program RunPCX;
uses Crt, Dos, Graph, PCX, EGA;

const
  Page0 = 0;

var
  p: BasePCXPtr;
  OldExitProc: pointer;
  eStr: string;
  Fname: PathStr;
  Dir: DirStr;
  Name: NameStr;
  Ext: ExtStr;

{$F+} procedure NewExitProc; {$F-}
begin ExitProc:= OldExitProc; CloseGraph; end;

procedure InitBGI;
var Path: string;
  Error, Driver, Mode: integer;
begin
  DirectVideo := false;
  OldExitProc := ExitProc;
  ExitProc := @NewExitProc;
  Path := '\tp\bgi';
  repeat
    Driver := Detect;
    InitGraph( Driver, Mode, path );
    Error := GraphResult;
    if ( Error <> grOK ) then begin
        Writeln( 'Graphics ERROR ', GraphErrorMsg( Error ) );
        if ( Error = grFileNotFound ) then begin
          Write( 'Enter path to graphics driver: ');
          Readln( Path );
          end;
        end;
  until Error = grOK;
end;

procedure ShowUsage;
begin
  writeln;
  writeln( 'USAGE: RunPCX <filename>' );
  writeln;
  Halt(0);
end;

begin
  if ParamCount < 1 then ShowUsage
    else Fname := FExpand( ParamStr( 1 ));
  FSplit( Fname, Dir, Name, Ext );
  if Ext <> '.PCX' then Fname := Fname + '.PCX';
  InitBGI;
  if VGACard then p := New( VgaPCXPtr, Init )
    else if EGACard then p := New( EgaPCXPtr, Init )
      else p := New( HercPCXPtr, Init );
  if p = NIL then Halt;
  p^.Show( Fname, page0, true );
   if p^.GetPCXError <> PCXError0 then begin
    Str( p^.GetPCXError, eStr );
    OutText( 'PCX unit error #' + eStr );
    end;
  repeat until KeyPressed;
{  P^.Save( 50, 50, 300, 250, 'test.pcx' ); }
  Dispose( p, Done );
  EGA_ResetPalette;
end.
