{$X+}
PROGRAM twoCurves;

	{ Draw joined Bezier curves }

USES
	VGraph, Crt;

CONST
	lastPoint = 4;     						{ highest subscript used }

VAR
	a, b         : Array[0..LastPoint] of PointType;
	errorCode, n : INTEGER;

PROCEDURE initPoints;
VAR
	n, j : INTEGER;

BEGIN
	a [0].x :=  10;   a [0].y := 110;
	a [1].x :=  10;   a [1].y :=   0;
	a [2].x := 120;   a [2].y :=   0;
	a [3].x := 180;   a [3].y := 110;
	a [4].x := 240;   a [4].y := 110;

	b [0].x := 240;   b [0].y := 110;
	b [1].x := 310;   b [1].y := 110;
	b [2].x := 310;   b [2].y :=   0;
	b [3].x := 180;   b [3].y :=   0;
	b [4].x := 120;   b [4].y := 199;
END;

BEGIN

	InitVesa(V640x480x256);
	{ Check to make sure it happened }
	ErrorCode := graphResult;
	IF errorCode <> grOK THEN BEGIN
		WRITELN ('Graphics error ', errorCode);
		WRITELN ('Program cannot run');
		HALT (1);
	END;

	{ Draw the first hull outline }
	InitPoints;      							{ First initialize control points }
	SetLineStyle (dottedLn, 0, normWidth);
	SetColor (1);
	MoveTo (a [0].x, a [0].y);
	FOR n := 1 TO lastPoint DO
		LineTo (a [n].x, a [n].y);

	{ Draw the second hull }
	MoveTo (b [0].x, b [0].y);
	FOR n := 1 TO lastPoint DO
		LineTo (b [n].x, b [n].y);

	{ Mark the joint with a vertical line }
	MoveTo (240, 100);
	LineTo (240, 120);

	{ Now draw the first curve }
	SetLineStyle (solidLn, 0, normWidth);
	SetColor (2);
	DrawBezier(lastPoint,a[1]);

	{ And second curve }
	SetColor (3);
	DrawBezier(lastPoint,b[1]);

	{ Clean up after a keypress }
	ReadKey;
	CloseVesa;
END.


