{ *******************************************************************
  *			    This file is part of the WMFH package				*
  ******************************************************************* }


{ *******************************************************************
  *				 This file comes from the SWAG library	 	  	    *	
  ******************************************************************* }


(*
                               Mouse Functions
                               

          I am relesing this source into the Public Domain. You are
          free to use and/or modify this code as you wish.
          This code is being released as-is, and should be at your
          own risk. Liberty Software, and myself are not responsible
          for what it may or may not do on your system.

          Written on : 02/25/95, by: Tim E. Rhodes - Liberty Software
*)

{ 1997		Added MS_Delay		Gianfranco Boggio-Togna  gbt@computer.org }


Unit MS_Unit;

{ ************************************************************************
  *																		 *
  *				        U N I T    I N T E R F A C E  					 *
  *																		 *
  ************************************************************************ }

INTERFACE

Uses Dos,Crt;

VAR

MS_Available  : Boolean; {True if Mouse Available}
MS_Buttons    : Integer; {Number of buttons if Mouse Available}
MS_LastX      : Word;    {Filled by MS_GetPos,MS_*Pressed and MS_*Released}
MS_LastY      : Word;    {Filled by MS_GetPos,MS_*Pressed and MS_*Released}

MS_DelayTime  : Word ; {may be changed by calling program}

Procedure MS_Init;                  {0000h RESET DRIVER AND READ STATUS}
Procedure MS_Show;                  {0001h SHOW MOUSE CURSOR}
Procedure MS_Hide;                  {0002h HIDE MOUSE CURSOR}
Procedure MS_GetPos;                {0003h RETURN POSITION AND BUTTON STATUS}
                                   {      Fills MS_PosX, and MS_PosY}
Function MS_WhereX:Word;            {0003h RETURN MOUSE COLUMN POSITION}
Function MS_WhereY:Word;            {0003h RETURN MOUSE ROW POSITION}
Function MS_LeftDown:Boolean;       {0003h RETURN TRUE IF LEFT BUTTON DOWN}
Function MS_RightDown:Boolean;      {0003h RETURN TRUE IF RIGHT BUTTON DOWN}
Function MS_BothDown:Boolean;       {0003h RETURN TRUE IF BOTH BUTTONS DOWN}
Function MS_MiddleDown:Boolean;     {0003h RETURN TRUE IF MIDDLE BUTTON DOWN}
Procedure MS_GotoXY(X,Y:Word);      {0004h POSITION MOUSE CURSOR}
Function MS_LeftPressed:Boolean;    {0005h RETURN TRUE IF LEFT BUTTON PRESSED}
Function MS_RightPressed:Boolean;   {0005h RETURN TRUE IF RIGHT BUTTON PRESSED}
Function MS_BothPressed:Boolean;    {0005h RETURN TRUE IF BOTH BUTTONS PRESSED}
Function MS_MiddlePressed:Boolean;  {0005h RETURN TRUE IF MIDDLE BUTTON PRESSED}
Function MS_LeftReleased:Boolean;   {0006h RETURN TRUE IF LEFT BUTTON RELEASED}
Function MS_RightReleased:Boolean;  {0006h RETURN TRUE IF RIGHT BUTTON RELEASED}
Function MS_BothReleased:Boolean;   {0006h RETURN TRUE IF BOTH BUTTONS RELEASED}
Function MS_MiddleReleased:Boolean; {0006h RETURN TRUE IF MIDDLE BUTTON RELEASED}

Procedure MS_Window(X,Y,X1,Y1:Word);{0007h DEFINE HORIZONTAL CURSOR RANGE}
                                   {  and 0008h  VERTICAL CURSOR RANGE}
                        {NOT USED - 0009h DEFINE GRAPHICS CURSOR - NOT USED}
Procedure MS_Attr(ScreenMask,CursorMask:Word);
                                   {000Ah DEFINE TEXT CURSOR - SOFTWARE}
Procedure MS_Size(StartScan,EndScan:Word);
                                   {000Ah DEFINE TEXT CURSOR - HARDWARE}

Procedure MS_Delay ;

{ ************************************************************************
  *																		 *
  *					 U N I T	I M P L E M E N T A T I O N				 *
  *																		 *
  ************************************************************************ }

IMPLEMENTATION

VAR

 SavedExitPtr : Pointer;
 Regs         : Registers;
 TempWord     : Word;
 Count        : Word;


Procedure MS_Init;Assembler;
 Asm
          MOV MS_Available,False
          MOV MS_Buttons,0
          MOV AX,0000h
          INT 33h
          CMP AX,0000h
           JE @Done
          CMP AX,0FFFFh
          JNE @Done
          MOV MS_Available,True
          CMP BX,0002h
           JE @Two
          CMP BX,0003h
           JE @Three
          CMP BX,0FFFFh
           JE @Three
    @Two: MOV MS_Buttons,2
          JMP @Done
  @Three: MOV MS_Buttons,3
          JMP @Done
   @Done:
 End;


Procedure MS_Show;Assembler;
 Asm
         CMP MS_Available,True
         JNE @Done
         MOV AX,0001h
         INT 33h
  @Done:
 End;


Procedure MS_Hide;Assembler;
 Asm
         CMP MS_Available,True
         JNE @Done
         MOV AX,0002h
         INT 33h
  @Done:
 End;


Procedure MS_GetPos;
 Begin
  Asm
          CMP MS_Available,True
          JNE @Done
          MOV AX,0003h
          INT 33h
          MOV MS_LastX,CX
          MOV MS_LastY,DX
   @Done:
  End;
  MS_LastX:=(MS_LastX DIV 8)+1;{Converts XPos to 80 column test mode}
  MS_LastY:=(MS_LastY DIV 8)+1;{Converts YPos to 25 Row text mode}
 End;


Function MS_WhereX:Word;
 Begin
  Asm
          CMP MS_Available,True
          JNE @Done
          MOV AX,0003h
          INT 33h
          MOV TempWord,CX
   @Done:
  End;
  MS_WhereX:=(TempWord DIV 8)+1;{Converts XPos to 80 column test mode}
 End;


Function MS_WhereY:Word;
 Begin
  Asm
          CMP MS_Available,True
          JNE @Done
          MOV AX,0003h
          INT 33h
          MOV TempWord,DX
   @Done:
  End;
  MS_WhereY:=(TempWord DIV 8)+1;{Converts YPos to 25 Row text mode}
 End;


Function MS_LeftDown:Boolean;
 Begin
  Asm
          MOV @Result,False
          CMP MS_Available,True
          JNE @Done
          MOV AX,0003h
          INT 33h
          MOV MS_LastX,CX
          MOV MS_LastY,DX
          CMP BX,1
          JNE @Done
          MOV @Result,True
   @Done:
  End;
  MS_LastX:=(MS_LastX DIV 8)+1;{Converts XPos to 80 column test mode}
  MS_LastY:=(MS_LastY DIV 8)+1;{Converts YPos to 25 Row text mode}
 End;


Function MS_RightDown:Boolean;
 Begin
  Asm
          MOV @Result,False
          CMP MS_Available,True
          JNE @Done
          MOV AX,0003h
          INT 33h
          MOV MS_LastX,CX
          MOV MS_LastY,DX
          CMP BX,2
          JNE @Done
          MOV @Result,True
   @Done:
  End;
  MS_LastX:=(MS_LastX DIV 8)+1;{Converts XPos to 80 column test mode}
  MS_LastY:=(MS_LastY DIV 8)+1;{Converts YPos to 25 Row text mode}
 End;


Function MS_BothDown:Boolean;
 Begin
  Asm
          MOV @Result,False
          CMP MS_Available,True
          JNE @Done
          MOV AX,0003h
          INT 33h
          MOV MS_LastX,CX
          MOV MS_LastY,DX
          CMP BX,3
          JNE @Done
          MOV @Result,True
   @Done:
  End;
  MS_LastX:=(MS_LastX DIV 8)+1;{Converts XPos to 80 column test mode}
  MS_LastY:=(MS_LastY DIV 8)+1;{Converts YPos to 25 Row text mode}
 End;


Function MS_MiddleDown:Boolean;
 Begin
  Asm
          MOV @Result,False
          CMP MS_Available,True
          JNE @Done
          MOV AX,0003h
          INT 33h
          MOV MS_LastX,CX
          MOV MS_LastY,DX
          CMP BX,4
          JNE @Done
          MOV @Result,True
   @Done:
  End;
  MS_LastX:=(MS_LastX DIV 8)+1;{Converts XPos to 80 column test mode}
  MS_LastY:=(MS_LastY DIV 8)+1;{Converts YPos to 25 Row text mode}
 End;


Procedure MS_GotoXY(X,Y:Word);
 Begin
  X:=(X-1)*8;{Convert 80 Column text mode to pixels}
  Y:=(Y-1)*8;{Convert 25 Row text mode to pixels}
  Asm
          CMP MS_Available,True
          JNE @Done
          MOV AX,0004h
          MOV CX,X
          MOV DX,Y
          INT 33h
   @Done:
  End;
 End;


Function MS_LeftPressed:Boolean;
Begin
 Asm
         MOV @Result,False
         CMP MS_Available,True
         JNE @Done
         MOV AX,0005h
         MOV BX,0000h
         INT 33h
         MOV Count,BX
         MOV MS_LastX,CX
         MOV MS_LastY,DX
         CMP AX,1
         JNE @Done
         MOV @Result,True
  @Done:
 End;
  MS_LastX:=(MS_LastX DIV 8)+1;{Converts XPos to 80 column test mode}
  MS_LastY:=(MS_LastY DIV 8)+1;{Converts YPos to 25 Row text mode}
End;


Function MS_RightPressed:Boolean;
Begin
 Asm
         MOV @Result,False
         CMP MS_Available,True
         JNE @Done
         MOV AX,0005h
         MOV BX,0001h
         INT 33h
         MOV Count,BX
         MOV MS_LastX,CX
         MOV MS_LastY,DX
         CMP AX,2
         JNE @Done
         MOV @Result,True
  @Done:
 End;
  MS_LastX:=(MS_LastX DIV 8)+1;{Converts XPos to 80 column test mode}
  MS_LastY:=(MS_LastY DIV 8)+1;{Converts YPos to 25 Row text mode}
End;


Function MS_BothPressed:Boolean;
Begin
 Asm
         MOV @Result,False
         CMP MS_Available,True
         JNE @Done
         MOV AX,0005h
         MOV BX,0002h
         INT 33h
         MOV Count,BX
         MOV MS_LastX,CX
         MOV MS_LastY,DX
         CMP AX,3
         JNE @Done
         MOV @Result,True
  @Done:
 End;
  MS_LastX:=(MS_LastX DIV 8)+1;{Converts XPos to 80 column test mode}
  MS_LastY:=(MS_LastY DIV 8)+1;{Converts YPos to 25 Row text mode}
End;


Function MS_MiddlePressed:Boolean;
Begin
 Asm
         MOV @Result,False
         CMP MS_Available,True
         JNE @Done
         MOV AX,0005h
         MOV BX,0002h
         INT 33h
         MOV Count,BX
         MOV MS_LastX,CX
         MOV MS_LastY,DX
         CMP AX,4
         JNE @Done
         MOV @Result,True
  @Done:
 End;
  MS_LastX:=(MS_LastX DIV 8)+1;{Converts XPos to 80 column test mode}
  MS_LastY:=(MS_LastY DIV 8)+1;{Converts YPos to 25 Row text mode}
End;


Function MS_LeftReleased:Boolean;
Begin
 Asm
         MOV @Result,False
         CMP MS_Available,True
         JNE @Done
         MOV AX,0006h
         MOV BX,0000h
         INT 33h
         MOV Count,BX
         MOV MS_LastX,CX
         MOV MS_LastY,DX
         CMP AX,1
         JNE @Done
         MOV @Result,True
  @Done:
 End;
  MS_LastX:=(MS_LastX DIV 8)+1;{Converts XPos to 80 column test mode}
  MS_LastY:=(MS_LastY DIV 8)+1;{Converts YPos to 25 Row text mode}
End;


Function MS_RightReleased:Boolean;
Begin
 Asm
         MOV @Result,False
         CMP MS_Available,True
         JNE @Done
         MOV AX,0006h
         MOV BX,0001h
         INT 33h
         MOV Count,BX
         MOV MS_LastX,CX
         MOV MS_LastY,DX
         CMP AX,2
         JNE @Done
         MOV @Result,True
  @Done:
 End;
  MS_LastX:=(MS_LastX DIV 8)+1;{Converts XPos to 80 column test mode}
  MS_LastY:=(MS_LastY DIV 8)+1;{Converts YPos to 25 Row text mode}
End;


Function MS_BothReleased:Boolean;
Begin
 Asm
         MOV @Result,False
         CMP MS_Available,True
         JNE @Done
         MOV AX,0006h
         MOV BX,0002h
         INT 33h
         MOV Count,BX
         MOV MS_LastX,CX
         MOV MS_LastY,DX
         CMP AX,3
         JNE @Done
         MOV @Result,True
  @Done:
 End;
  MS_LastX:=(MS_LastX DIV 8)+1;{Converts XPos to 80 column test mode}
  MS_LastY:=(MS_LastY DIV 8)+1;{Converts YPos to 25 Row text mode}
End;


Function MS_MiddleReleased:Boolean;
Begin
 Asm
         MOV @Result,False
         CMP MS_Available,True
         JNE @Done
         MOV AX,0006h
         MOV BX,0002h
         INT 33h
         MOV Count,BX
         MOV MS_LastX,CX
         MOV MS_LastY,DX
         CMP AX,4
         JNE @Done
         MOV @Result,True
  @Done:
 End;
  MS_LastX:=(MS_LastX DIV 8)+1;{Converts XPos to 80 column test mode}
  MS_LastY:=(MS_LastY DIV 8)+1;{Converts YPos to 25 Row text mode}
End;


Procedure MS_Window(X,Y,X1,Y1:Word);
Begin
  X:=(X-1)*8;{Convert 80 Column text mode to pixels}
  Y:=(Y-1)*8;{Convert 25 Row text mode to pixels}
  X1:=(X1-1)*8;{Convert 80 Column text mode to pixels}
  Y1:=(Y1-1)*8;{Convert 25 Row text mode to pixels}
 Asm
         CMP MS_Available,True
         JNE @Done
         MOV AX,0007h
         MOV CX,X
         MOV DX,X1
         INT 33h
         MOV AX,0008h
         MOV CX,Y
         MOV DX,Y1
         INT 33h
         JMP @Done
  @Done:
 End;
End;


Procedure MS_Attr(ScreenMask,CursorMask:Word);Assembler;
 Asm
         CMP MS_Available,True
         JNE @Done
         MOV AX,000Ah
         MOV BX,0000h
         MOV CX,ScreenMask
         MOV DX,CursorMask
         INT 33h
  @Done:
 End;


Procedure MS_Size(StartScan,EndScan:Word);Assembler;
 Asm
         CMP MS_Available,True
         JNE @Done
         MOV AX,000Ah
         MOV BX,0001h
         MOV CX,StartScan
         MOV DX,EndScan
         INT 33h
  @Done:
 End;


Procedure MouseExit;
 Begin
  ExitProc:=SavedExitPtr;
 End;

Procedure MS_Delay  ;
 BEGIN
	  Delay (MS_DelayTime) ;
 END ;

{ INITIALIZATION }

Begin
 MS_DelayTime := 125 ;		 	{ milliseconds }
 SavedExitPtr:=ExitProc;
 {ExitProc:=@MouseExit;}
 MS_Init;
End.
