/***************************************************************************
  TVVideo unit
  Turbo Vision extended video modes support routines
  PJB August 30, 1993, Internet mail to d91-pbr@nada.kth.se
  Copyright PJB 1993, All Rights Reserved. Portions Copyright Borland.
  Free source, use at your own risk.
  If modified, please state so if you pass this around.

     TVVIDEO NO LONGER SUPPORTS smFont8x8

      Use toggleVideoLines instead, or setInternalFont.

     PLEASE remember (I didn't) to use

      setSpecialVideoMode instead of setVideoMode

***************************************************************************/

#define Uses_TApplication
#define Uses_TDeskTop
#define Uses_TMouse
#define Uses_TScreen
#define Uses_TView

#include <dos.h>
#include <math.h>
#include <tv.h>
#include "toycfg.h"
#include "tvvideo.h"
#include "video.h"



  int videoScanLines;
  void (*videoModeChanged)() = doNothing;


  /*******************************************************************
    This is the normal ReloadLastFont void
  *******************************************************************/
  void doNothing()
  {}


  /*******************************************************************
    From Borlands DRIVERS unit
  *******************************************************************/
  ushort getCrtMode()
  {
    asm {
      PUSH      BP

      MOV	AH,0x0F
      INT       0x10

      PUSH	AX
      MOV	AX,0x1130
      MOV	BH,0
      MOV	DL,0
      INT       0x10
      POP	AX

      MOV	DH,AH
      CMP	DL,25
      SBB	AH,AH
      INC	AH

      POP       BP
    }
    return _AL;
  }

  /*******************************************************************
    Call this before InitVideo or DoneVideo to stop them from
    changing the video mode. This void *destroys* StartUpMode.
    Save StartUpMode (MyApp.Init; Save=StartUpMode;) if( you want to
    restore the video mode (StartUpMode=Save; MyApp.Done;) on exit.

    Try this to keep the startup video mode (132-cols etc) active:
      {
        if( isProbablyTextMode ) preventModeSwitch;
        myApp.init; myApp.run; myApp.done;
      }.
  *******************************************************************/
  void preventModeSwitch()
  {
    TScreen::startupMode=getCrtMode();
    TScreen::screenMode=TScreen::startupMode;
  }


  /*******************************************************************
    Try to make VideoScanLines reflect maximum number of scan lines
    in this video mode
  *******************************************************************/
  void checkScanLines()
  {
    int scanLines;

    scanLines=getCurrentScanLines();
    if ((abs(scanLines-videoScanLines)>16) || (scanLines>videoScanLines))
      videoScanLines=scanLines;       /* Screen size has changed! */


    #define CHECK(a,b) if (videoScanLines>=a && videoScanLines<=b) videoScanLines=b+1

    /* Check if screen could be higher */
    CHECK(340,349);
    CHECK(390,399);
    CHECK(470,479);
    CHECK(590,599);

    #undef CHECK
  }


  /*******************************************************************
    Center all views on the desktop
  *******************************************************************/
  void reCenter(TView *p, void *)
  {
    int x,y;

    x=p->origin.x;
    y=p->origin.y;

    if (p->options & ofCenterX)
      x=(p->owner->size.x - p->size.x) / 2;
    if (p->options & ofCenterY)
      y=(p->owner->size.y - p->size.y) / 2;

    p->moveTo(x, y);
  }

  void reCenterDesktop()
  {
    TApplication::deskTop->forEach(reCenter, 0);
    TApplication::application->forEach(reCenter, 0);
  }


  /*******************************************************************
    Remove all cache buffers
  *******************************************************************/
  void killCache(TView *p, void *)
  {
//    ((TGroup*)p)->freeBuffer();       // And what if it isn't a group?
  }

  void killCacheBuffers()
  {
    TApplication::deskTop->forEach(killCache, 0);
    TApplication::application->forEach(killCache, 0);
  }


  extern TPoint shadowSize;

  /*******************************************************************
    Initialize TV video stuff
    This is separate void so we can use it for font changes etc
  *******************************************************************/
  void initTVVideo()
  {
    preventModeSwitch();         /* Disable InitVideo mode switch */
    TScreen::setCrtData();       /* Recalc CRT data */

    if (videoType==EGA)          /* This is Borland's idea */
    asm {
      push bp
      mov  es,Seg0040
      or   es:[crtInfo].Byte,1   /* Disable CGA cursor emulation */

      mov  ah,1
      mov  cx,0x0600             /* Set cursor size: Start 6, End 0 */
      int  0x10
      pop  bp
    }

    killCacheBuffers();          /* Dispose of cache buffers */

    TApplication::application->initScreen();   /* Calculate shadow sizes (debatable) */
    TApplication::application->buffer=0;  /* Disable all screen writing */

    TRect R(0, 0, TScreen::screenWidth, TScreen::screenHeight);
    TApplication::application->changeBounds(R);    /* Resize application */
    reCenterDesktop();                 /* Center desktop items */

    if (isColorMode)         /* Let's hope this works */
      TScreen::screenBuffer=(uchar *)MK_FP(SegB800,0);
    else
    {
      shadowSize.x = 0;
      shadowSize.y = 0;
      TApplication::showMarkers = True;
      TApplication::application->appPalette = apMonochrome;
      TScreen::screenBuffer=(uchar *)MK_FP(SegB000,0);
    }
    TApplication::application->buffer=(ushort *)TScreen::screenBuffer;

    TApplication::application->redraw();        /* Draw menubar, desktop and statusline */
    TMouse::show();

    checkScanLines();
    TScreen::screenMode=getSpecialVideoMode();

    if (Mem(Seg0040,crtRows)!=24)
    asm{                         /* This is Borland's idea */
      mov  ah,0x12               /* Use alternate PrtScr handler */
      mov  bl,0x20
      push bp
      int  0x10
      pop  bp
    }
  }


  /*******************************************************************
    Use this void to change video mode instead of SetScreenMode
    which will not set modes other than 2,3 and 7.

    DON'T use SetScreenMode if( you use SetSpecialVideoMode.
    The display wont be redrawn if( the screen size doesn't change.
    This is a design flaw at the heart of Turbo Vision
  *******************************************************************/
  void setSpecialScreenMode(ushort mode)
  {
    TMouse::hide();

    setSpecialVideoMode(mode);
    videoScanLines=getCurrentScanLines();
    videoModeChanged();

    initTVVideo();
  }


  /*******************************************************************
    TV wrapper for Video.UseInternalFont
  *******************************************************************/
  void setInternalFont(uchar font)
  {
    TMouse::hide();
    useInternalFont(font);
    initTVVideo();
  }


  /*******************************************************************
    Load a character definition table
    Points is the character height
    Font points to an array of character bitmaps for all 256 chars,
    ASCII 0 first, occupying Points bytes per char, top to bottom.
    Character array must contain at least 256*Points bytes.
  *******************************************************************/
  void setUserFont(uchar points, void *font)
  {
    TMouse::hide();
    loadUserFont(points, 0, 256, font);
    initTVVideo();
  }


  /*******************************************************************
    Replacement code to toggle the number of video lines
  *******************************************************************/
  void toggleVideoLines()
  {
    if (Mem(Seg0040,crtPoints)!=8)
      setInternalFont(internal8x8Font);
    else
      setInternalFont((videoType==EGA) ? internal8x14Font : internal8x16Font);
  }
