# ================================================================== fortcat.pl
#  PERL Script to Concatinate fortune files.  If 1 file is specified, it
#  is echoed.  If more than one file is specified, the files are echoed in
#  order, with a separater (defined in $sep) written between them
#
#  - Kevin Grover, grover@isri.unlv.edu
#  Sat 06 Mar 1993  Created
#
#  Todo:
#  - Command line option or env var to set separation character(s)
# =============================================================================

die "Usage: fortcat datafile [datafile...]\n" unless @ARGV;

$sep     = "%";                        # Separation Character
$numseps = @ARGV -1;                   # Number of separaters needed

while ($f = shift @ARGV) {             # Get file names from command line
  &readit;                             #  process one file at a time
}

sub readit {
  local (*IN);
  if (!open(IN,"<$f")) {
    warn "Can't open file $f: $!\n";   # display a message
    $numseps--;                        # don't output separator for this file
    return;                            # leave the sub routine
  }
  while (<IN>) {print;}                # duplicate contents of file
  close (IN);
  print "%%\n" if ($numseps--);        # add a separator if not last file
}
