' Process CMS NOTEBOOK files
'
'   Allows reading of each note in file
'   Allows replying to notes, regular mode
'   Allows replying to notes, TEXT mode
'   Allows sending notes
'
  DECLARE SUB AllDone ()
  DECLARE SUB BuildIndex ()
  DECLARE SUB HdrItems ()
  DECLARE SUB HdrNote ()
  DECLARE SUB HelpItems ()
  DECLARE SUB HelpNote ()
  DECLARE SUB Pause ()
  DECLARE SUB ReadIndex ()
  DECLARE SUB ReadNote (note)
  DECLARE SUB SetUp ()
  DECLARE SUB ShowFiles ()
  DECLARE SUB ShowItems ()
  DECLARE SUB ShowNote (note)
  DECLARE SUB Display (file, pointer(), items%, first%, last%)

  DECLARE FUNCTION ConvertDate (adate$)
  DECLARE FUNCTION Modtime$ (atime$)
  DECLARE FUNCTION Word$ (aline$, num)

  COMMON SHARED dirnote$, dirndx$, indexsize%, notesize%
  COMMON SHARED fsize, title$, version$, dircmd$
  COMMON SHARED pitems(), pnote()
  COMMON SHARED infile$, outfile$, note$(), note, notecount%

  title$ = "CMS Notebook processor "
  version$ = "v1r0m0"

  PRINT ""
  PRINT ""
  PRINT title$ + version$

  SetUp
  ShowFiles
  ShowItems
  AllDone

  END

'
' Close the .NOT and .IDX files
'
SUB AllDone
  CLS
  CLOSE #1
  CLOSE #2
  SHELL "del cmsnote.dir"
END SUB

'
' Build an index of the selected .NOT file
'
SUB BuildIndex

'        12345678.123 nnnnnnnn  mm-dd-yy  hh:mm  nnnnnnn  nnnnnnn  nnn.nn%
  PRINT "                                                                %";
  LOCATE CSRLIN, 1
  PRINT dirnote$;
'        ....+....1....+....2....+....3....+....4....+....5....+....6....+....7
  LINE INPUT #1, aline$
  notecount% = 0
  notestart = 1
  lines = 0
  OPEN outfile$ FOR OUTPUT AS #2
  WRITE #2, "    0", 0, 0

  DO
    lines = lines + 1

    IF LEFT$(aline$, 72) = STRING$(72, "=") THEN
       IF notecount% > 0 THEN
          notelines% = notelines% - 1
          size$ = RIGHT$("     " + STR$(notelines%), 5)
          item$ = from$ + " " + ndate$ + " " + size$ + " " + subj$
          FOR z = 1 TO LEN(item$)
              IF MID$(item$, z, 1) = CHR$(34) THEN
                 MID$(item$, z, 1) = "'"
              END IF
          NEXT z
          WRITE #2, item$, notestart, notelines%
       END IF

       needhdr$ = "Y"
       notelines% = 0
       notecount% = notecount% + 1
       LOCATE CSRLIN, 41
       PRINT RIGHT$("       " + STR$(notecount%), 7);
       LOCATE CSRLIN, 50
       PRINT RIGHT$("       " + STR$(lines), 7);
       LOCATE CSRLIN, 59
       PRINT USING "###.##%"; (notestart / fsize) * 100;

       notestart = SEEK(1)
    ELSE

      IF needhdr$ = "Y" THEN
         Work$ = Word$(UCASE$(aline$), 1)
         SELECT CASE Work$

            CASE "FROM:"
               from$ = LTRIM$(MID$(aline$, 7))
               from$ = LEFT$(from$ + SPACE$(19), 19)

            CASE "DATE:"
               ndate$ = LTRIM$(MID$(aline$, 7))
               ndate$ = LEFT$(ndate$ + SPACE$(14), 14)

            CASE "SUBJECT:"
               subj$ = LTRIM$(MID$(aline$, 10))

            CASE ""
               needhdr$ = "N"

         END SELECT
      END IF
    END IF
    notelines% = notelines% + 1
    LINE INPUT #1, aline$
  LOOP WHILE NOT (EOF(1))

  LOCATE CSRLIN, 41
  PRINT RIGHT$("       " + STR$(notecount%), 7);
  LOCATE CSRLIN, 50
  PRINT RIGHT$("       " + STR$(lines), 7);
  LOCATE CSRLIN, 59
  PRINT "100.00%"

  notelines% = notelines% - 1
  size$ = RIGHT$("     " + STR$(notelines%), 5)
  item$ = from$ + " " + ndate$ + " " + size$ + " " + subj$
  FOR z = 1 TO LEN(item$)
      IF MID$(item$, z, 1) = CHR$(34) THEN
         MID$(item$, z, 1) = "'"
      END IF
  NEXT z
  WRITE #2, item$, notestart, notelines%
  SEEK #2, 1
  WRITE #2, LEFT$(STR$(notecount%) + SPACE$(5), 5), 0, 0
  CLOSE #2

END SUB

'
' To convert a date string of mm/dd/yy into a numeric of yymmdd
'
FUNCTION ConvertDate (adate$)
  adate$ = RIGHT$("0" + adate$, 8)
  am$ = LEFT$(adate$, 2)
  ad$ = MID$(adate$, 4, 2)
  ay$ = RIGHT$(adate$, 2)
  ConvertDate = VAL(ay$ + am$ + ad$)
END FUNCTION

'
' to display either a item or note screen
'
SUB Display (file, pointer(), items%, first%, last%)
'   LOCATE 2, 1
'   PRINT file, pointer(first%), items%, first%, last%
    IF file = 1 THEN
       LOCATE 3, 1
    ELSE
       LOCATE 4, 1
    END IF
    FOR z% = first% TO last%
        IF z% > items% THEN
           EXIT FOR
        END IF
        SEEK file, pointer(z%)
        IF file = 1 THEN
           LINE INPUT #file, line$
           PRINT LEFT$(line$ + SPACE$(80), 80)
        ELSE
           INPUT #file, items$, start, lines%
           PRINT RIGHT$(SPACE$(5) + STR$(z%), 5) + " " + LEFT$(items$ + SPACE$(33), 73)
        END IF
    NEXT z%
    DO WHILE CSRLIN < 24
       PRINT SPACE$(80)
    LOOP

END SUB

'
' Print headers for ShowItems
'
SUB HdrItems
    CLS
    PRINT title$ + version$
    LOCATE 1, 40
    PRINT infile$
    LOCATE 1, 67
    PRINT "Items: " + STR$(notecount%)

    LOCATE 3, 1
    PRINT "    # From:               Date:          Size: Subject:"
'   PRINT "1234 1234567890123456789 12345678901234 1234 12345678901234567890123456789"

    LOCATE 24, 1
    PRINT "Up & Down arrow keys, PgUp & PgDn";
    LOCATE 24, 40
    PRINT "Bottom   Help   Quit   Read   Top";
END SUB

'
' Print headers for ReadNote
'
SUB HdrNote
    CLS
    PRINT title$ + version$
    LOCATE 1, 40
    PRINT "Note: " + STR$(note)
    LOCATE 1, 67
    PRINT "Lines: " + STR$(notesize%)

    LOCATE 24, 1
    PRINT "Up & Down arrow keys, PgUp & PgDn";
    LOCATE 24, 40
    PRINT "Bottom   Help   Next   Prev   Quit   Top";
END SUB

'
' Give help for the Items screen
'
SUB HelpItems
  CLS
  PRINT "Help for items screen"
  PRINT ""
  PRINT "Here is where you view the index of notes"
  PRINT ""
  PRINT "You can scroll through the list with the arrow keys and the"
  PRINT "PageUp and PageDown keys"
  PRINT ""
  PRINT "You read a note with the R key and leave this program with Q"
  DO
  LOOP WHILE INKEY$ = ""
END SUB

'
' Give help for the Items screen
'
SUB HelpNote
  CLS
  PRINT "Help for note screen"
  PRINT ""
  PRINT "Here is where you view the note"
  PRINT ""
  PRINT "You can scroll through the note with the arrow keys and the"
  PRINT "PageUp and PageDown keys"
  PRINT ""
  PRINT "You read the next note with the N key, see the previous with P"
  PRINT "and leave this program with Q"
  DO
  LOOP WHILE INKEY$ = ""
END SUB

'
' to take a hh:mmx time and return a 24 hour time as hh:mm
'
FUNCTION Modtime$ (atime$)
    ind$ = RIGHT$(atime$, 1)
    IF ind$ = "P" THEN
       IF LEFT$(atime$, 2) <> "12" THEN
          MID$(atime$, 1, 2) = LTRIM$(STR$(VAL(LEFT$(atime$, 2)) + 12))
       END IF
    END IF
    IF ind$ = "P" OR ind$ = "A" THEN
       atime$ = LEFT$(atime$, LEN(atime$) - 1)
    END IF
    Modtime$ = RIGHT$(atime$, 5)
END FUNCTION

'
' to pause the display
'
SUB Pause
  PRINT ""
  PRINT ""
  PRINT "Press a key to continue"
  DO
  LOOP UNTIL INKEY$ <> ""
END SUB

'
' To read in an existing .NDX file
'
SUB ReadIndex

'        12345678.123 nnnnnnnn  mm-dd-yy  hh:mm  nnnnnnn  nnnnnnn  nnn.nn%
  PRINT "                                                                 ";
  LOCATE CSRLIN, 1
  PRINT dirndx$;
'        ....+....1....+....2....+....3....+....4....+....5....+....6....+....7
  OPEN outfile$ FOR INPUT AS #2
  INPUT #2, size$, start, lines

  size% = VAL(size$)

  DIM pitems(size%)

  lines = 0
  FOR z% = 1 TO size%
      pitems(z%) = SEEK(2)
      INPUT #2, items$, start, lines%

      lines = lines + lines% + 1
      LOCATE CSRLIN, 41
      PRINT RIGHT$("       " + STR$(z%), 7);
      LOCATE CSRLIN, 50
      PRINT RIGHT$("       " + STR$(lines), 7);
      LOCATE CSRLIN, 59
      PRINT USING "###.##%"; (z% / size%) * 100;

      IF EOF(2) THEN
         EXIT FOR
      END IF

  NEXT z%

  LOCATE CSRLIN, 41
  PRINT RIGHT$("       " + STR$(z%), 7);
  LOCATE CSRLIN, 50
  PRINT RIGHT$("       " + STR$(lines), 7);
  LOCATE CSRLIN, 59
  PRINT "100.00%"

  notecount% = z%
  indexsize% = size%

END SUB

'
' Read the note selected
'
SUB ReadNote (note)
  LOCATE 2, 1
  PRINT "Reading note " + STR$(note);
  SEEK #2, pitems(note)
  INPUT #2, items$, start, lines%
  ERASE pnote
  DIM pnote(lines%)
  SEEK #1, start
  FOR z% = 1 TO lines%
      pnote(z%) = SEEK(1)
      LINE INPUT #1, aline$
  NEXT z%
  notesize% = lines%
END SUB

'
' Clear screen and other house keeping
'
SUB SetUp
    dircmd$ = "DIR"
    IF INSTR(ENVIRON$("COMSPEC"), "4DOS") <> 0 THEN
       dircmd$ = "DIR /J"
    END IF
END SUB

'
' Show all the .NOT files in the current directory
' Allow user to select the one they want
' Open that file as file #1
'
SUB ShowFiles
  PRINT "": PRINT "":
  INPUT "What is the name of the file? ", infile$
  infile$ = UCASE$(infile$)

' get the path of the file
  dot = 0
  FOR z = LEN(infile$) TO 1 STEP -1
      IF MID$(infile$, z, 1) = "\" THEN
         slash = z
         EXIT FOR
      END IF
      IF MID$(infile$, z, 1) = "." THEN
         dot = z
      END IF
  NEXT z

  IF dot = 0 THEN
     dot = LEN(infile$)
     iext$ = ""
  ELSE
     iext$ = MID$(infile$, dot + 1)
  END IF

  path$ = LEFT$(infile$, slash)
  iname$ = MID$(infile$, slash + 1, dot - slash - 1)

  outfile$ = path$ + iname$ + ".NDX"

' see if it exists
  SHELL dircmd$ + " " + path$ + iname$ + ".* > cmsnote.dir"

  OPEN "CMSNOTE.DIR" FOR INPUT AS #1
  ndate$ = "00-00-00"
  ntime$ = "00:00"
  DO
     LINE INPUT #1, aline$
     aline$ = UCASE$(aline$)

    IF Word$(aline$, 1) = iname$ THEN
       IF Word$(aline$, 2) = iext$ THEN
          dirnote$ = aline$
          fsize = VAL(Word$(aline$, 3))
          fdate$ = Word$(aline$, 4)
          ftime$ = Modtime$("0" + Word$(aline$, 5))
       END IF
    END IF

    IF Word$(aline$, 1) = iname$ THEN
       IF Word$(aline$, 2) = "NDX" THEN
          dirndx$ = aline$
          ndate$ = Word$(aline$, 4)
          ntime$ = Modtime$("0" + Word$(aline$, 5))
       END IF
    END IF
  LOOP UNTIL EOF(1)

  CLOSE 1
  IF fdate$ = "" THEN
     IF ndate$ = "" THEN
        PRINT "weird error, found no dates for input file or index file"
        END
     END IF
  END IF
  OPEN infile$ FOR INPUT AS #1

  ndate = ConvertDate(ndate$)
  fdate = ConvertDate(fdate$)

'  PRINT fdate$, ftime$, ndate$, ntime$
'  PRINT fdate, ndate
'  PRINT " "

  PRINT "Fileid        Size:     Date:    Time:  Notes:   Lines:   Done:"

  IF fdate >= ndate THEN
     IF fdate = ndate THEN
        IF ftime$ > ntime$ THEN
           BuildIndex
           dirndx$ = nfile$
        ELSE
           PRINT dirnote$
        END IF
     ELSE
        BuildIndex
        dirndx$ = nfile$
     END IF
  ELSE
     PRINT dirnote$
  END IF

  ReadIndex
  Pause

END SUB

'
' Show the .IDX of the .NOT file previously selected
'
SUB ShowItems

    nextline% = 1
    increment% = 19
    IF notecount% < increment% THEN
       increment% = notecount%
    END IF
    lastline% = nextline% + increment%
    row = 4
    HdrItems
    CALL Display(2, pitems(), indexsize%, nextline%, lastline%)
    DO
       LOCATE row, 1
       PRINT CHR$(16)
       DO
          key$ = INKEY$
       LOOP WHILE key$ = ""

       SELECT CASE key$
          CASE CHR$(27)
            key$ = "Q"

          CASE CHR$(0) + "H" ' Up arrow
            LOCATE row, 1
            PRINT " "
            row = row - 1
            IF row < 4 THEN
               row = 4
            nextline% = nextline% - 1
            IF nextline% < 1 THEN
               nextline% = 1
            END IF
            lastline% = nextline% + increment%
            CALL Display(2, pitems(), indexsize%, nextline%, lastline%)
            END IF

          CASE CHR$(0) + "P" ' Down arrow
            LOCATE row, 1
            PRINT " "
            row = row + 1
            IF row > 23 THEN
               row = 23
               nextline% = nextline% + 1
               IF nextline% > notecount% THEN
                  nextline% = nextline% - 1
               END IF
               lastline% = nextline% + increment%
               CALL Display(2, pitems(), indexsize%, nextline%, lastline%)
            ELSE
               IF CHR$(SCREEN(row, 5)) = " " THEN
                  row = row - 1
               END IF
            END IF

          CASE CHR$(0) + "I" ' Page Up
            LOCATE row, 1
            PRINT " "
            row = 4
            nextline% = nextline% - increment%
            IF nextline% < 1 THEN
               nextline% = 1
            END IF
            lastline% = nextline% + increment%
            CALL Display(2, pitems(), indexsize%, nextline%, lastline%)

          CASE CHR$(0) + "Q" ' Page Down
            LOCATE row, 1
            PRINT " "
            row = 4
            nextline% = nextline% + increment%
            IF nextline% > notecount% THEN
               nextline% = nextline% - increment%
            END IF
            lastline% = nextline% + increment%
            CALL Display(2, pitems(), indexsize%, nextline%, lastline%)

          CASE "b", "B"
             lastline% = notecount%
             nextline% = lastline% - increment%
             IF nextline% < 1 THEN
                nextline% = 1
             END IF
             CALL Display(2, pitems(), indexsize%, nextline%, lastline%)

          CASE "h", "H"
             CALL HelpItems
             HdrItems
             CALL Display(2, pitems(), indexsize%, nextline%, lastline%)

          CASE "r", "R"
             note$ = ""
             FOR z = 2 TO 5
                 note$ = note$ + CHR$(SCREEN(row, z))
             NEXT z
             note = VAL(LTRIM$(note$))
             CALL ShowNote(note)         ' Read the note
             HdrItems
             CALL Display(2, pitems(), indexsize%, nextline%, lastline%)

          CASE "t", "T"
             nextline% = 1
             lastline% = nextline% + increment%
             CALL Display(2, pitems(), indexsize%, nextline%, lastline%)

       END SELECT

    LOOP WHILE UCASE$(key$) <> "Q"

END SUB

'
' Show the note selected
'
SUB ShowNote (note)
  DO
    CALL ReadNote(note)
    nextnote = 0
    nextline% = 1
    increment% = 20
    IF notesize% < increment% THEN
       increment% = notesize%
    END IF
    lastline% = nextline% + increment%
    row = 3
    HdrNote
    CALL Display(1, pnote(), notesize%, nextline%, lastline%)

    DO
       LOCATE row, 1
       DO
          key$ = INKEY$
       LOOP WHILE key$ = ""

       SELECT CASE key$
          CASE CHR$(27)
            key$ = "Q"

          CASE CHR$(0) + "H" ' Up arrow
            nextline% = nextline% - 1
            IF nextline% < 1 THEN
               nextline% = 1
            END IF
            lastline% = nextline% + increment%
            CALL Display(1, pnote(), notesize%, nextline%, lastline%)

          CASE CHR$(0) + "P" ' Down arrow
            nextline% = nextline% + 1
            IF nextline% > notesize% THEN
               nextline% = nextline% - 1
            END IF
            lastline% = nextline% + increment%
            CALL Display(1, pnote(), notesize%, nextline%, lastline%)

          CASE CHR$(0) + "I" ' Page Up
            nextline% = nextline% - increment%
            IF nextline% < 1 THEN
               nextline% = 1
            END IF
            lastline% = nextline% + increment%
            CALL Display(1, pnote(), notesize%, nextline%, lastline%)

          CASE CHR$(0) + "Q" ' Page Down
            nextline% = nextline% + increment%
            IF nextline% > notesize% THEN
               nextline% = nextline% - increment%
            END IF
            lastline% = nextline% + increment%
            CALL Display(1, pnote(), notesize%, nextline%, lastline%)

          CASE "b", "B"
             lastline% = notesize%
             nextline% = lastline% - increment%
             IF nextline% < 1 THEN
                nextline% = 1
             END IF
             CALL Display(1, pnote(), notesize%, nextline%, lastline%)

          CASE "h", "H"
            CALL HelpNote
            HdrNote
            CALL Display(1, pnote(), notesize%, nextline%, lastline%)

          CASE "n", "N"
            nextnote = 1                   ' Want next note
            key$ = "Q"
            note = note + 1            ' Want next note
            IF note > notecount% THEN
               note = note - 1
               nextnote = 0                ' want to exit readnote
            END IF

          CASE "p", "P"
            nextnote = 1                   ' Want next note
            key$ = "Q"
            note = note - 1            ' Want next note
            IF note < 1 THEN
               note = note + 1
               nextnote = 0                ' Want to exit readnote
            END IF

          CASE "t", "T"
             nextline% = 1
             lastline% = nextline% + increment%
             CALL Display(1, pnote(), notesize%, nextline%, lastline%)

       END SELECT

    LOOP WHILE UCASE$(key$) <> "Q"
  LOOP WHILE nextnote = 1
END SUB

'
' To return any blank delimited word from a string
'
FUNCTION Word$ (aline$, num)
  Work$ = ""
  wordnum = 0
  aline$ = LTRIM$(aline$)
  FOR z = 1 TO LEN(aline$)
      achar$ = MID$(aline$, z, 1)
      IF achar$ = " " THEN
         IF Work$ > "" THEN
            wordnum = wordnum + 1
            IF wordnum = num THEN
               EXIT FOR
            ELSE
               Work$ = ""
            END IF
         END IF
      ELSE
         Work$ = Work$ + achar$
      END IF
  NEXT z

  Word$ = Work$
END FUNCTION

