/*
 * tab.c - insert a tab into the left margin of a file.  With the -o option
 *         the left margin can be indented a specified number of spaces.
 *         Reads either standard input or the named file and sends output
 *         to standard output.
 *
 * Perry A. D. Wood
 * August 14, 1989
 * Department of Electrical Engineering
 * University of Virginia
 */

#include <stdio.h>

main(argc, argv)
int argc;
char *argv[];
    {
    int c;               /* data variable */
    int j;               /* general index variable */
    int posit=0;         /* column position, start of line = 0 */
    int opt_char;        /* command line variable */
    int n=0;             /* # of blank spaces to indent */
    FILE *infile;        /* input stream */
    extern int optind, opterr;
    extern char *optarg;

    /*
     *  Read the command line options
     */

    opterr=1;     /* turns on the error messages printed by getopt */

    if ((opt_char = getopt(argc, argv, "o:")) == '?')
        {
	fprintf(stderr, "Usage: tab [-o #_of_spaces] [filename]\n");
        exit();
        }

    /* Check for a numeric argument only if the -o option was given */

    if ((n = atoi(optarg)) == NULL && opt_char == 'o')
        {
	fprintf(stderr, "%s: non-numeric argument for option -- o\n", argv[0]);
	fprintf(stderr, "Usage: tab [-o #_of_spaces] [filename]\n");
        exit();
        }

    /*
     * Determine if the user has specified an input file.  If no file
     * has been specified then use standard input.
     */

    if (argv[optind] == NULL)
        infile = stdin;

    else
        if ((infile = fopen(argv[optind], "r")) == NULL)
            {
	    fprintf(stderr, "%s: unable to open %s\n", argv[0], argv[optind]);
            exit();
	    }

    /*
     * Indent the input stream, outputting to standard output
     */

    switch(opt_char)
        {
        case EOF:         /* no argument so indent one tab */

            while((c = getc(infile)) != EOF)
                {
                posit++;

                if(c == '\n')  /* reset column position on a new line */
                    posit = 0;

                if(posit == 1)  /* put a tab at the start of the line */
                    printf("\11%c", c);
                else
                    printf("%c", c);
                }
            break;

        case 'o':       /* indent n spaces */

            while((c = getc(infile)) != EOF)
                {
                posit++;

                if(c == '\n')  /* reset column position on a new line */
                    posit = 0;

                if(posit == 1)  /* put n spaces at the start of the line */
                    {
                    for(j = 0; j < n; j++)
                        printf(" ");
                    printf("%c", c);
                    }
                else
                    printf("%c", c);
                }
            break;
        }
    }
