/*
testvir.c
Stealth Bomber Version 2.2

Kevin Dean
Fairview Mall P.O. Box 55074
1800 Sheppard Avenue East
Willowdale, Ontario
CANADA    M2J 5B9
CompuServe ID: 76336,3114

February 10, 1992

Files required: TESTVIR.C, VIRCHECK.H, SYSCHECK.C, DOSMCB.H, DOSMCB.C,
		FILECHCK.C, CALCCRC.C, BUFALLOC.C

	This program demonstrates the anti-virus CRC algorithms in SYSCHECK.C
and FILECHCK.C.  The response to error codes is entirely up to the programmer.

	To set the CRC for this program and its supporting files, the command
is:

		crcset -p testvir.exe testvir.obj -d crc.dat testvir.c

	This code is public domain.
*/


#include <stdio.h>
#include <stdlib.h>

#include "vircheck.h"


const char *fn[3] =
  {
  "TESTVIR.EXE", "TESTVIR.OBJ", "TESTVIR.C"
  };

/* Normally this would be defined by changing STEALTH_NFILES in VIRUSDAT.C to
  3; it has not been done that way for this program as this is a sample file
  only. */
const filecrc _fcrc[3] =
  {
    {
    '_', 'S', 'T', 'E', 'A', 'L', 'T', 'H'
    }
  };


/***/
int main(int argc, char *argv[])
{
unsigned sysresult, fileresult;
int errfound = 0;
FILE *crcfile;
int i;

/* Check system. */
sysresult = stealth_sys_check();

if (sysresult & STEALTH_INTR_ERR)
  fputs("System interrupts have been set beyond current code space.  This may indicate\n"
	"the presence of a virus in system memory.\n", stderr);
if (sysresult & STEALTH_DOS_MEM_ERR)
  fputs("Memory reported by DOS is inconsistent with memory reported by BIOS.  This may\n"
	"indicate the presence of a virus in system memory.\n", stderr);
if (sysresult & STEALTH_DOS_HIJACKED)
  fputs("A DOS interrupt has been covertly redirected by another program.  This may\n"
	"indicate the presence of a virus in system memory.\n", stderr);
if (sysresult)
  {
  fputc('\n', stderr);
  errfound = 1;
  }

crcfile = fopen("crc.dat", "rb");
if (crcfile)
  {
  fread(_fcrc + 2, sizeof(_fcrc[2]), 1, crcfile);
  fclose(crcfile);
  }
else
  fputs("Error opening CRC.DAT file.\n", stderr);

/* Check all files. */
for (i = 0; i < 3; i++)
  {
  if (i || _osmajor < 3)
    fileresult = stealth_file_check(fn[i], _fcrc[i]);
  else
    /* Check main program. */
    fileresult = stealth_file_check(argv[0], _fcrc[i]);

  if (fileresult & STEALTH_FILE_ERR)
    fprintf(stderr, "Error accessing %s for CRC check.\n", fn[i]);
  if (fileresult & STEALTH_FILE_DATE_ERR)
    fprintf(stderr, "Date stamp error on file %s.  This may indicate the presence of a\n"
		    "virus in the file.  Please take appropriate steps to secure your computer from\n"
		    "further possible infection.\n", fn[i]);
  if (fileresult & STEALTH_FILE_SIZE_ERR)
    fprintf(stderr, "File size error on file %s.  This may indicate the presence of a\n"
		    "virus in the file.  Please take appropriate steps to secure your computer from\n"
		    "further possible infection.\n", fn[i]);
  if (fileresult & (STEALTH_CRC_BAD_POLY | STEALTH_CRC_INVALID))
    fprintf(stderr, "CRC error on file %s.  This file has been tampered with and may be\n"
		    "infected by a computer virus.  Please take appropriate steps to secure your\n"
		    "computer from further possible infection.\n", fn[i]);
  if (fileresult & STEALTH_NO_MEM)
    fprintf(stderr, "Insufficient memory to run CRC check on file %s.\n", fn[i]);
  if (fileresult)
    {
    fputc('\n', stderr);
    errfound = 1;
    }
  }

if (!errfound)
  puts("No viruses found.");

return (0);
}
