#include <stdio.h>
#include "crc32.h"

int main(int argc, char **argv)
{
  FILE *f;
  int i;
  size_t size;
  char buffer[1024];
  unsigned long crc;

  if (argc < 2) {
    fputs("pvalid8 filespec ...\n", stderr);
    return 0;
  }
  for (i = 1; i < argc; ++i) {
    f = fopen(argv[i], "rb");
    if (!f) fprintf(stderr, "Error reading %s\n", argv[i]);
    for (crc = 0xffffffff;
         !feof(f) && !ferror(f);
         crc = addbfcrc(buffer, size, crc))
      size = fread(buffer, 1, 1024, f);
    if (ferror(f)) fprintf(stderr, "Error reading %s\n", argv[i]);
    printf(" %04lx %04lx  %s\n", crc >> 16, crc & 0xffff, argv[i]);
    fclose(f);
  }

  return 0;
}
