'
' COMTYPE.BAS
'
' Reports the UART type for COM1 thru COM4
'
' **** IMPORTANT: Boot to DOS before running under Windows! ***
'
'  To run from the VB IDE, type:
'
'       VBDOS /LPCL4VB.QLB COMTYPE.BAS
'
'$INCLUDE: 'PCL4VB.BI'

 RxBuf128$ = STRING$(128+16,0)   'must be 1st string statement
 TxBuf128$ = STRING$(128+16,0)   'must be 2nd string statement

 True = 0
 False = NOT True

' Global Variables

DIM BaudCode AS INTEGER
DIM BaudRate AS SINGLE
DIM ThePort AS INTEGER
DIM C AS INTEGER
DIM I AS INTEGER
DIM Code AS INTEGER
DIM RxBufSeg AS INTEGER
DIM TxBufSeg AS INTEGER
DIM UartString(4) AS STRING

' initialize

BaudCode = Baud19200
BaudRate = 19200

UartString(0) = "8250/16450"
UartString(1) = "16550"
UartString(2) = "16650"
UartString(3) = "16750"

IF LEN(COMMAND$) > 0 THEN
   PRINT "Usage: COMTYPE"
   STOP
END IF

'search each port in turn
FOR ThePort = COM1 TO COM4
  ' setup receive buffer
  RxBufSeg = (1+SSEG(RxBuf128$)) + (SADD(RxBuf128$) \ 16)
  Code = SioRxBuf(ThePort, RxBufSeg, Size128)
  IF SioInfo(ASC("I")) <> 0 THEN
     'setup transmit buffer
     TxBufSeg = (1+SSEG(TxBuf128$)) + (SADD(TxBuf128$) \ 16)
     Code = SioTxBuf(ThePort, TxBufSeg, Size128)
  END IF

  ' reset port
  Code = SioReset(ThePort, BaudCode)
  IF ThePort = COM1 THEN
     CLS
  END IF
  ' report
  PRINT "COM";LTRIM$(STR$(1+ThePort));": ";
  IF Code >= 0 THEN
     'found UART
     Code = SioFIFO(ThePort,LEVEL_4TH)
     PRINT UartString(Code)
     Code = SioDone(ThePort)
  ELSE
     Code = SioError(Code)
     PRINT
  END IF

NEXT ThePort
END


 