'
' FINDER.BAS (12/16/97)
'
' Connect a modem to one of COM1 to COM4, and turn it on.
' FINDER will search for the modem.
'
'  To run from the VB IDE, type:
'
'       VBDOS /LPCL4VB.QLB FINDER.BAS
'
'$INCLUDE: 'PCL4VB.BI'


DECLARE SUB ErrorCheck(BYVAL Code AS INTEGER)

True = 0
False = NOT True

PC = 1
DB = 2
BB = 3

RxBuf256$ = STRING$(256+16,0)   'must be 1st string statement
TxBuf256$ = STRING$(256+16,0)   'must be 2nd string statement

' Global Variables

DIM BaudCode AS INTEGER
DIM BaudRate AS SINGLE
DIM Port AS INTEGER
DIM C AS INTEGER
DIM I AS INTEGER
DIM Code AS INTEGER
DIM RxBufSeg AS INTEGER
DIM TxBufSeg AS INTEGER
DIM Parms AS STRING
DIM Expect AS STRING
DIM Mark AS LONG

' initialize

BaudCode = Baud19200
BaudRate = 19200

IF LEN(COMMAND$) > 0 THEN
   PRINT "Usage: FINDER"
   STOP
END IF

'search each port in turn
FOR Port = COM1 TO COM4
  ' set parmameters for the port
  CALL ErrorCheck( SioParms(Port,NoParity,OneStopBit,WordLength8) )
  ' setup receive buffer
  RxBufSeg = (1+SSEG(RxBuf256$)) + (SADD(RxBuf256$) \ 16)
  CALL ErrorCheck( SioRxBuf(Port, RxBufSeg, Size256) )
  IF SioInfo(ASC("I")) <> 0 THEN
     'setup transmit buffer
     TxBufSeg = (1+SSEG(TxBuf256$)) + (SADD(TxBuf256$) \ 16)
     CALL ErrorCheck( SioTxBuf(Port, TxBufSeg, Size256) )
  END IF

  ' reset port
  Code = SioReset(Port, BaudCode)
  IF Port = COM1 THEN
     CLS
     PRINT "FINDER: Searching for connected modem."
     PRINT
  END IF
  IF Code >= 0 THEN
     'found UART
     PRINT "COM";LTRIM$(STR$(1+Port))
     Code = SioDTR(Port,SET_LINE)
     Code = SioRTS(Port,SET_LINE)
     ' use FIFO if present
     Code = SioFIFO(Port,LEVEL_4TH)
     'modem should set DSR
     Code = SioPutc(Port,13)
     IF SioDSR(Port) = 0 THEN
       'DSR not set
       PRINT "  DSR is not set."
       Code = SioDone(Port)
     ELSE
       'modem has set DSR
       PRINT "  DSR is set."
       'send "AT"
       Code = SioPutc(Port,13)
       Code = SioDelay(5)
       Code = SioPutc(Port,ASC("A"))
       Code = SioDelay(5)
       Code = SioPutc(Port,ASC("T"))
       Code = SioDelay(5)
       Code = SioPutc(Port,13)
       Code = SioDelay(5)
       'expect "OK" back
       Expect = "O"
       Mark = SioTimer + 30
       WHILE SioTimer < Mark
         Code = SioGetc(Port,0)
         IF Code = 13 THEN
           PRINT
         ELSEIF Code >= &H20 THEN
           PRINT CHR$(Code);
           IF CHR$(Code) = Expect THEN
             IF Expect = "O" THEN
               EXPECT = "K"
             ELSE
               PRINT "  Modem detected."
               Call ShutDown
             END IF
           END IF
         END IF
       WEND
       'modem does not respond
       Code = SioDone(Port)
     END IF
  ELSE
     PRINT "Error ";Code;
     Code = SioError(Code)
     PRINT
  END IF
NEXT Port
Call ShutDown
END

SUB ErrorCheck(BYVAL Code AS INTEGER)
' trap PCL error codes
IF Code < 0 THEN
   Code = SioError(Code)
   Call ShutDown
END IF
END SUB

SUB ShutDown
DIM Code AS INTEGER
Code = SioDone(Port)
END
END SUB

 