/*===========================================================================
SOLAR v0.95.3 solar :: Module ..\solar\solar.c
Original Author: Kevin Houle <kjhoule@iowegia.des-moines.ia.us>

This source code has been placed into the public domain.
30/10/95  KJS  Added check for carrier drop after calling Rgetc()
===========================================================================*/

/* Header Files */
#include <dir.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#include <values.h>
#include <limits.h>
#include <stdlib.h>
#include "codedate.h"
#include "solar.h"

int c_break(void)
{
	fprintf(stdout,"\nControl-break pressed, Solar aborting...\n");
	fcloseall();
	cleanup();
	extern_halt();
	return 0;
}

int main(int argc, char *argv[])
{
	int c_break(void);

	extern		char		*optarg;
	unsigned	char		x;
	const 		char		*optionS = "u:U:t:T:s:S:vVFf";

	char							orig_path[MAXPATH];
  char              packetpath[MAXPATH];
  char              newpath[MAXPATH];
  char              username[10];
  int               now;
  int               exit_code     = x_success;

	int 							slrmail_status;
	int 							slrnews_status;
  int               slrxfer_status;
  int               slrreply_status;
  int               slrcmd_status;
  int               update_flag;
  int               flag;

  long              packet_size = 0L;
  long              xfer_speed  = 0L;
  long              down_time   = 0L;

  struct            ffblk ffblk;

	/* Store original directory */

	getcwd(orig_path, MAXPATH);

	/* Set default values for globals */

	strcpy(temp_path, 	"NONE");
	strcpy(user_path, 	"NONE");
  strcpy(menu_path,   "NONE");
  strcpy(config_path, "NONE");
	strcpy(log_path,		"NONE");
	strcpy(solar_path,	"NONE");
	strcpy(static_path, "NONE");
	strcpy(waffle_path, "NONE");
	strcpy(system_path, "NONE");
	strcpy(extern_path, "NONE");
  strcpy(extern_root, "solar");
  strcpy(help_path,   "NONE");
  strcpy(uucpname,    "NONE");
  strcpy(swap_path,   ".");     /* Default to current directory */

	strcpy(compress,		"NONE");
	strcpy(protocol,		"NONE");
	strcpy(username,		"NONE");
	strcpy(speed, 			"LOCAL");

  diskswap            = YES;
  use_fossil          = NO;
	port								= 99;
	verbose 						= NO;
	time_left 					= INT_MAX;

	news_area_bytes 		= MAXLONG;
	news_area_messages	= MAXLONG;
	news_total_bytes		= MAXLONG;
	news_total_messages = MAXLONG;
  disk_minimum        = MAXLONG;

	news_type 					= u;			/* Default to USENET format  */
	news_index					= c;			/* Default to full C News 	 */
	mail_type 					= m;			/* Default to UNIX format (death to MMDF) */
	mail_index					= n;			/* Default to no IDX files */
	send_mail 					= NO;
	delete_mail 				= NO;
	send_list 					= NO;
	use_wafjoin 				= NO;
  stupid_user         = 3;

  /* Parse the command line and load file settings */

	while ((x = getopt(argc, argv, optionS)) != '\xFF')
	{
		switch (toupper(x)) {
			case '?'  : exit_code = x_usage;
									goto ExitMain;
			case 'U'  : if ((strcmp(username,"NONE")) == 0)
									{
										strcpy(username,optarg);
										break;
									}
									else
									{
										exit_code = x_usage;
										goto ExitMain;
									}
			case 'V'  : verbose = YES;
									break;
			case 'T'  : time_left = atoi(optarg);
									break;
			case 'S'  : strcpy(speed,optarg);
									break;
			case 'F'  : use_fossil = YES;
									break;
      default   : exit_code = x_usage;
                  goto ExitMain;
    }
	}

	/* Check to see if username was set. If
		 not, try to set from PCBDOOR.SYS or
		 DOORS.SYS file. */

	if (strcmp(username,"NONE") == 0)
	{
		if (read_doors() != 0)
		{
			exit_code = x_usage;
			goto ExitMain;
		}
	}

  if (verbose == YES)
	{
    RPrintf("\nSOLAR v%s (%s)\n",VERSION,CODE_DATE);
    RPrintf("Serving user: %s\n\n",username);
	}

  /* Load configuration files. */

	if ((load_static(username) != 0)		|| \
			(load_config() != 0)						|| \
      (user_defaults() != 0))
	{
		exit_code = x_fatal;
		goto ExitMain;
	}

  /* Set extern file to halt Solar */

	if (extern_halt() != 0)
	{
		exit_code = x_fatal;
		goto ExitMain;
	}

  /* Log the fact we've started up. */

  sprintf(logbuf,"username %s; speed %s; time %u",username,speed,time_left);
  logit("SOLAR Startup");

  /* Cleanup the temp directory and any tmp newsrc files */

	cleanup();
  kill_newsrc(NEWSRC_TMP);

  /* Start up the user interface command line loop */

  if (verbose == YES)
    RPrintf("Starting command interface...\n");

  switch (user_options()) {

    /* Error! Halt and exit */
		case -1 : extern_halt();
							exit_code = x_fatal;
							goto ExitMain;

    /* User exit */
    case 0  : extern_halt();
              exit_code = x_success;
							break;

		/* Batch packet for download */

    case 1  : /* Make sure free disk space is available. */

              if (diskfree(temp_path) != 0)
              {
                exit_code = x_fatal;
                goto ExitMain;
              }

              /* Initialize control break handler */

              RPrintf("Press Ctrl-C to abort...\n");
							ctrlbrk(c_break);

              /* Batch mail first */

							if (send_mail == YES)
							{
                /* Check for amount of time left. */

                if (timechk(time_left) != 0)
								{
									exit_code = x_fatal;
									goto ExitMain;
								}

                /* Run slrmail.exe */

                slrmail_status = call_solar(username,"slrmail","");
                if (slrmail_status != x_success)
								{
									sprintf(_slrerr,"main(): Call to slrmail failed.");
									exit_code = x_fatal;
									goto ExitMain;
								}
              }

              /* Check time left */

              if (timechk(time_left) != 0)
							{
                exit_code = x_fatal;
								goto ExitMain;
							}

              /* Batch USENET by calling slrnews.exe */

              slrnews_status = call_solar(username,"slrnews","");
              if (slrnews_status != x_success)
							{
								sprintf(_slrerr,"main(): Call to slrnews failed.");
                exit_code = x_fatal;
                goto ExitMain;
							}

              /* Compress packet */

              packet_size = compress_packet();
              if (packet_size == 0L)
              {
                RPrintf("Subscription file will not be updated.\n");
                exit_code = x_fatal;
                goto ExitMain;
              }
              RPrintf("\nPacket size is : %lu bytes\n",packet_size);
              sprintf(logbuf,"%s compressed %lu bytes",username,packet_size);
              logit("solar");

              /* If we're not local, the packet needs to be
                 transfered. */

              if (strcmp(speed,"LOCAL") != 0)
              {
                xfer_speed = atol(speed);
                if (xfer_speed != 0)
                {
                  down_time = ((packet_size / (xfer_speed / 10L)) / 60L);
                  RPrintf("Approx. transfer time : %u minute(s)\n",down_time);
                }

                /* Check time left including transfer time. */

                if (timechk(time_left + down_time) != 0)
                {
                  exit_code = x_fatal;
                  goto ExitMain;
                }

                /* Prompt for confirmation */

                update_flag = 0;
                while (update_flag == 0)
                {
                  RPrintf("Transfer packet, or Abort [T,a] ? ");
                  now = Rgetc(port);
                  if (now == -1) {
                    sprintf(_slrerr,"main(): Carrier dropped in Rgetc().");
                    exit_code = x_fatal;
                    goto ExitMain;
                  }
                  RPrintf("\n\n");
                  if (now == 'T' || now == 't' || now == '\x0D')
                  {
                    RPrintf("If for some reason the transfer is aborted, your\n");
                    RPrintf("packet will be moved into %s\n",user_path);
                    RPrintf("Sending with %s, start receiving now...\n",protocol);
                    update_flag = 1;
                  }
                  else
                  {
                    if (now == 'A' || now == 'a')
                    {
                      update_flag = 2;
                      sprintf(_slrerr,"main(): packet transfer aborted by user");
                      exit_code = x_fatal;
                      goto ExitMain;
                    }
                    else
                    {
                      RPrintf("%c ?\n",now);
                    }
                  }
                }

                /* If not using a FOSSIL driver, slrxfer must be called
                   with Waffle's comm i/o disabled. */

                if (use_fossil == YES)
                {
                  if (extern_slrxfer(username,"-s") != 0)
                  {
                    exit_code = x_fatal;
                    goto ExitMain;
                  }
                }
                else
                {
                  /* Not using a FOSSIL, go ahead and call slrxfer */

                  slrxfer_status = call_solar(username,"slrxfer","-s");
                  if (slrxfer_status != x_success)
                  {
                    sprintf(_slrerr,"main(): Call to slrxfer failed.");
                    exit_code = x_fatal;
                    goto ExitMain;
                  }
                }
              } /* Packet transfer */
              else
              {
                RPrintf("Packet is located in %s\n",user_path);
              }

              /* Update stuff */

              if (update_newsrc() != 0)
              {
                /* A NEWSRC file update is not fatal, issue a warning
                   and log the occurance. */

                RPrintf("%s\n",_slrerr);
                sprintf(logbuf,"%s",_slrerr);
                logit("solar");
              }

              /* Done with BATCH command */
              break;

		/* Accept reply packet */

    case 2  : /* Make sure free disk space is available */

              if (diskfree(temp_path) != 0)
              {
                exit_code = x_fatal;
                goto ExitMain;
              }

              /* Check time left */

              if (timechk(time_left) != 0)
              {
                exit_code = x_fatal;
                goto ExitMain;
              }

              /* If LOCAL, accept path to packet on command line. */

              if (stricmp(speed,"LOCAL") == 0)
              {
                RPrintf("Enter full path to packet file : ");
                Rgets(packetpath);
                RPrintf("\n");
                if (strcmp(packetpath,"\x0D") == 0) break;

                /* Make sure the packet is there and get the filename.
                   Copy the packet file to the solarwork directory. */

                if (findfirst(packetpath,&ffblk,0) == 0)
                {
                  strcpy(newpath,temp_path);
                  strcat(newpath,"\\");
                  strcat(newpath,ffblk.ff_name);
                  RPrintf("copying %s --> ",packetpath);
                  if (copyfile(packetpath,newpath) != 0)
                  {
                    exit_code = x_fatal;
                    RPrintf(stdout,"\n");
                    goto ExitMain;
                  }
                  RPrintf("%s\n",newpath);
                }
                else  /* Reply packet was not found. */
                {
                  sprintf(_slrerr,"main(): reply packet %s not found",packetpath);
                  exit_code = x_fatal;
                  goto ExitMain;
                }
              } /* End LOCAL packet handling. */
              else
              {
                /* Prompt to make sure user wishes to upload a packet now */

                flag = 0;
                while (flag == 0)
                {
                  RPrintf("Upload reply packet [Y,n] ? ");
                  now = Rgetc(port);
                  if (now == -1) {
                    sprintf(_slrerr,"main(): Carrier dropped in Rgetc().");
                    exit_code = x_fatal;
                    goto ExitMain;
                  }
                  RPrintf("\n");
                  if (now == 'Y' || now == 'y' || now == '\x0D')
                  {
                    flag = 1;
                    RPrintf("Receiving with %s, start sending now...\n",protocol);

                    /* If not using a FOSSIL driver, slrxfer must be called
                       with Waffle's comm i/o disabled. Solar.exe exits
                       after writing extern file. If using a FOSSIL, we can
                       call slrxfer directly. */

                    if ((use_fossil == NO) || (strcmp(speed,"LOCAL") != 0))
                    {
                      if (extern_slrxfer(username,"-r") != 0)
                      {
                        exit_code = x_fatal;
                        goto ExitMain;
                      }
                    }
                    else
                    {
                      /* Using a FOSSIL or LOCAL, go ahead and call slrxfer */

                      slrxfer_status = call_solar(username,"slrxfer","-r");
                      if (slrxfer_status != x_success)
                      {
                        sprintf(_slrerr,"main(): Call to slrxfer failed.");
                        exit_code = x_fatal;
                        goto ExitMain;
                      }
                    }
                  }
                  else
                  {
                    if (now == 'N' || now == 'n')
                    {
                      flag = 1;
                      break;
                    }
                    else
                    {
                      RPrintf("%c ?\n",now);
                    }
                  }
                }
              } /* Remote reply packet */

              /* Now call slrreply to process reply packet. This only
                 gets called if we are using a FOSSIL or LOCAL. */

              slrreply_status = call_solar(username,"slrreply","");
              if (slrreply_status != x_success)
							{
                sprintf(_slrerr,"main(): Call to slrreply failed.");
                exit_code = x_fatal;
                goto ExitMain;
							}

              /* Finally, check for a COMMANDS file in the reply packet.
                 Call slrcmd if we find one. */

              strcpy(newpath,temp_path);
              strcat(newpath,"\\COMMANDS");
              if (findfirst(newpath,&ffblk,0) == 0)
              {
                slrcmd_status = call_solar(username,"slrcmd","");
                if (slrcmd_status != x_success)
                {
                  sprintf(_slrerr,"main(): Call to slrcmd failed.");
                  exit_code = x_fatal;
                  goto ExitMain;
                }
              }

              /* We be done with the reply packet. */
              break;
  }

ExitMain:
	set_directory(orig_path);
	switch (exit_code) {
		case x_success	: break;
		case x_usage		: usage();
                      extern_halt();
											break;
    case x_fatal    : extern_halt();
                      RPrintf("\n%s\n",_slrerr);
											sprintf(logbuf,"%s",_slrerr);
											logit("solar");
  }

  /* Log the fact we're exiting. */

  if (exit_code != x_usage)
  {
    sprintf(logbuf,"username %s exit code %u\n",username,exit_code);
    logit("SOLAR Exit");
  }

  return exit_code;
}

/*
Function: usage()
Purpose : Display Solar command line usage.
Return	: N/A
*/

void usage()
{
  RPrintf("SOLAR v%s (%s) - Simple Off-Line Article Reading System.\n\n",VERSION,CODE_DATE);
	RPrintf("Usage: solar -u username [-s speed] [-t time_left] [-v] [-f]\n");
	return;
}
