/*  Copyright (C) 1985 John B. Allison				December 1985

  mpstomp1 -	convert mps binary format files to mp1 ASCII format.
									*/
main(argc, argv)
  int  argc;
  char *argv[];{

#include "stdio.h"

FILE *fp;

#define RECSIZE 90

#define READMODE	0x8000
#define WRITEMODE	0x8001

    int	  n, ix, blank, fi;
    char  ss[80], fullname[80], c, zchar = 26;	/*  Ctrl Z - EOF  */
    float xvalue,  yvalue;
    double x, y;
    char   outname[80];




	if(argc != 3 || argv[2][1] != ':' || argv[2][2] != '\0'){
		printf("		useage: mpstomp1 file_name disk_drive\n");
		printf("\nwhere 'file_name' is a file name (excluding drive designation and extension). \n");
		printf("This program will create an mp1-formated\n");
		printf("file named 'x:file_name.mps'\n");
		exit();
	}

	/*  Input File  */

	strcpy(fullname, argv[1]);
	strcat(fullname, ".mps");

	if((fi=open(fullname, READMODE)) == -1){
		printf("Unable to open %s\n", fullname);
		exit();
	}

	/*  Output File  */

	strcpy(outname, argv[2]);
	strcat(outname, argv[1]);
	strcat(outname, ".mp1");

	if((fp=fopen(outname, "r")) != NULL){
		printf("Output file %s already exists.\n", outname);
		exit();
	}
	if((fp=fopen(outname, "w")) == NULL){
		printf("Unable to create %s\n", outname);
		exit();
	}



	/*  Read and process the binary map file.  */

	while(read(fi, &xvalue, 4) != 0){
		if(read(fi, &yvalue, 4) == -1) goto error;
		x = xvalue;
		y = yvalue;
		fprintf(fp, "%.3f %.3f", x, y);

		for(read(fi, &c, 1); c != '\n'; read(fi, &c, 1)){
			if(c == 1){
				fprintf(fp, "\n");
				continue;
			}
			fprintf(fp, "%c", c);
		}

		fprintf(fp, "\n");
	}

	fprintf(fp, "%c", zchar);	/*  End of File  -  Ctrl Z  */
	exit();

error:
	printf("Read error on file %s\n", fullname);
}