#
#
#  This command file demonstrates the BRIGHTEN command.  
#
#  First, we'll DEFINE a LAMP MODULE to a specific HOUSECODE
#  that does not have WALL SWITCHES present. 
#
#  REMEMBER: WALL SWITCH modules do not behave properly when a 
#  BRIGHTEN command is issued on the same housecode as LAMP DIMMER.  
#  For more information, refer to the documentation file: XA320.TXT. 
#
#  This first example will demonstate the BRIGHTEN
#  action using direct commands.

DEFINE Lamp_Module L1           # Assign a name to this module
Lamp_Module dim 0               # Place the MODULE at its lowest level
Lamp_Module brighten 1          # Now begin brightening the module
Lamp_Module brighten 1          # to its maximum level
Lamp_Module brighten 1
Lamp_Module brighten 1
Lamp_Module brighten 1
Lamp_Module brighten 1
Lamp_Module brighten 1
Lamp_Module brighten 1
Lamp_Module brighten 1
Lamp_Module brighten 1
Lamp_Module brighten 1
Lamp_Module brighten 1
Lamp_Module brighten 1
Lamp_Module brighten 1
Lamp_Module brighten 1
Lamp_Module brighten 1


#  This example will dim the LAMP MODULE to its lowest setting.  Next,
#  we'll store a series of events to brighten the module gradually over
#  the next 16 minutes.

Lamp_Module dim 0
Lamp_Module brighten 1 now 1
Lamp_Module brighten 1 now 2
Lamp_Module brighten 1 now 3
Lamp_Module brighten 1 now 4
Lamp_Module brighten 1 now 5
Lamp_Module brighten 1 now 6
Lamp_Module brighten 1 now 7
Lamp_Module brighten 1 now 8
Lamp_Module brighten 1 now 9
Lamp_Module brighten 1 now 10
Lamp_Module brighten 1 now 11
Lamp_Module brighten 1 now 12
Lamp_Module brighten 1 now 13
Lamp_Module brighten 1 now 14
Lamp_Module brighten 1 now 15
Lamp_Module brighten 1 now 16



#  We'll use the MONITOR token to watch the CP-290 trigger each
#  BRIGHTEN command.

MONITOR


