#============================================================================
#
#       JOYSTICK Demo Program for XA 
#
#       This command file shows you how to react to input 
#       from the Game Adapter (Joystick Port). 
#
#       In order to make this loop as efficient as possible, the statement
#       "DISPLAY OFF" is used. 
#
#       Note that this file is in fact EXECUTING...
#
#
DISPLAY OFF                          # Turn display off to speed execution
DECLARE VAR MODULE = OFF             # Intialize state to Off
DISPLAY Please press Joystick Button 1

:LOOP                                # This is the beginning of the loop
JOYSTICK                             # Read the joystick port
IF JOY1B1                            # Check Button 1
  IF (MODULE == OFF)                 # If module is currently Off...
    DISPLAY ON                       # (turn display on so we can see cmd)
    a9 on                            # ...Turn module On
    DISPLAY OFF
    MODULE = ON                      # ...update status of module to On
    DISPLAY Please press Joystick Button 2
    # DOS c:\sblaster\vplay c:\sblaster\yr.voc    # Make SoundBlaster talk
  ENDIF
ENDIF

# Check Button B
IF JOY1B2                            # Check Button 2
  IF (MODULE == ON)                  # If module is currently On...
    DISPLAY ON                       # (turn display on so we can see cmd)
    a9 off                           # ...Turn module Off
    DISPLAY OFF
    MODULE = OFF                     # ...update its status too
    DISPLAY Please press Joystick Button 1
    # DOS c:\sblaster\vplay c:\sblaster\witch.voc
  ENDIF
ENDIF

GOTO LOOP                            # Keep repeating loop until <ESC> pressed.

:EXIT                                # Special label to search for when <ESC>.
DISPLAY ON
a9 OFF                               # Put module back into a known state.
