/*
	Calendar3.cpp
	Program that allows the user to enter the year and outputs the year's calendar.
	Amol Lodha -- 15 9 1998 -- CW10 - C++
*/
//-------------------------------------------- include directives
#include <iostream.h>
#include "utility.h"
#include <conio.h>  // Win 95
#include <fstream.h>
//-------------------------------------------- constants/type definitions
//-------------------------------------------- function prototypes
void GetInput (int & Year);
void SetupCal (int Year, int M, bool file, fstream & outData);
void PrintMonths (int M, int Year, bool file, fstream & outData);
void SplitYear (int Year, int & C, int & YC);
void FixMonth(int & M, int & Year);
void Compute(int & DN, int M, int D, int YC, int C, int Year);
void PrintDays(int D, int DN, int YC, int C, int Year, int M, int days, int & leftdays,
	int & middays, int & rightdays, int & leftD, int & midD, int & rightD, bool file,
	fstream & outData);
void FindDays (int M, int Year, int & days);
void FirstLine (int DN, int & D, int max, bool file, fstream & outData);
void SaveToDisk(bool & save);
//-------------------------------------------- main function
int main()
{
	char again;
	do
	{
		int Year, M = 1, D = 0, C = 0, YC = 0, days = 0, DN = 0;
		int leftdays = 0, middays = 0, rightdays = 0, leftD = 0, midD = 0, rightD = 0;
		char wait;
		fstream outData;
		outData.open ("file.txt", ios::out);
		if (outData.fail())
				cout << "Error in reading file. Saving execution terminated.";
		bool save = false, file = false;
		GetInput (Year);
		SetupCal (Year, 1, file, outData);
		PrintDays(D, DN, YC, C, Year, 1, days, leftdays, middays, rightdays, leftD, midD, rightD,
			file, outData);
		SetupCal (Year, 4, file, outData);
		PrintDays(D, DN, YC, C, Year, 4, days, leftdays, middays, rightdays, leftD, midD, rightD,
			file, outData);
		cin.ignore (80, '\n');
		cout <<"Press return to continue: ";
		cin.get(wait);
		SetupCal (Year, 7, file, outData);
		PrintDays(D, DN, YC, C, Year, 7, days, leftdays, middays, rightdays, leftD, midD, rightD,
			file, outData);
		cout << endl;
		SetupCal (Year, 10, file, outData);
		PrintDays(D, DN, YC, C, Year, 10, days, leftdays, middays, rightdays, leftD, midD, rightD,
			file, outData);
		SaveToDisk(save);
		if (save == true)
		{
			clrscr();
			cout << "Saving....";
			file = true;
			outData << "                      Calendar for the Year " << Year << endl;
			SetupCal (Year, 1, file, outData);
			PrintDays(D, DN, YC, C, Year, 1, days, leftdays, middays, rightdays, leftD, midD, rightD,
				file, outData);
			outData << endl;
			SetupCal (Year, 4, file, outData);
			PrintDays(D, DN, YC, C, Year, 4, days, leftdays, middays, rightdays, leftD, midD, rightD,
				file, outData);
			outData << endl;
			SetupCal (Year, 7, file, outData);
			PrintDays(D, DN, YC, C, Year, 7, days, leftdays, middays, rightdays, leftD, midD, rightD,
				file, outData);
			outData << endl;
			SetupCal (Year, 10, file, outData);
			PrintDays(D, DN, YC, C, Year, 10, days, leftdays, middays, rightdays, leftD, midD, rightD,
				file, outData);
			outData.close();
			cout << "Done." << endl;
			cout << "Your calendar is currently saved in the same directory as cal3.exe " << endl
				<< "and is called file.txt" << endl;
		}
		cout << "Again? (y/n) ";
		cin >> again;
	}
	while (again == 'Y' || again == 'y');
	cout << "It is now safe to turn off this program.";
	return 0;
}
//-------------------------------------------- function definitions
void GetInput (int & Year)
{
	clrscr();
	cout << "Enter the year (>= 1752): ";
	cin >> Year;
	while (Year < 1752)
	{
		cout << "Invalid Year!" << endl << "Enter the year (>= 1752): ";
		cin >> Year;
	}
}
void SetupCal (int Year, int M, bool file, fstream & outData)
{
	int i;
	if (file == false)
	{
		if (M == 1 || M == 7)
			clrscr();
		cout << "                      Calendar for the Year " << Year << endl;
		cout << "---------------------------------------------------------------------" << endl;
		for (i = 0; i < 3; i++)
		{
			PrintMonths (M, Year, file, outData);
			cout << "   ";
			M++;
		}
		cout << endl << "---------------------   ---------------------   ---------------------";
		cout << endl << " S  M  T  W  T  F  S     S  M  T  W  T  F  S     S  M  T  W  T  F  S";
		cout << endl;
	}
	else
	{
		outData << "---------------------------------------------------------------------" << endl;
		for (i = 0; i < 3; i++)
		{
			PrintMonths (M, Year, file, outData);
			outData << "   ";
			M++;
		}
		outData << endl << "---------------------   ---------------------   ---------------------";
		outData << endl << " S  M  T  W  T  F  S     S  M  T  W  T  F  S     S  M  T  W  T  F  S";
		outData << endl;
	}
}
void PrintMonths (int M, int Year, bool file, fstream & outData)
{
	if (file == false)
	{
		switch (M)
		{
			case 1 : cout << "        Jan " << Year << "     ";
			break;
			case 2 : cout << "        Feb " << Year << "     ";
			break;
			case 3 : cout << "        Mar " << Year << "     ";
			break;
			case 4 : cout << "        Apr " << Year << "     ";
			break;
			case 5 : cout << "        May " << Year << "     ";
			break;
			case 6 : cout << "        Jun " << Year << "     ";
			break;
			case 7 : cout << "        Jul " << Year << "     ";
			break;
			case 8 : cout << "        Aug " << Year << "     ";
			break;
			case 9 : cout << "        Sep " << Year << "     ";
			break;
			case 10 : cout << "        Oct " << Year << "     ";
			break;
			case 11 : cout << "        Nov " << Year << "     ";
			break;
			case 12 : cout << "        Dec " << Year << "     ";
			break;
		}
	}
	else
	{
		switch (M)
		{
			case 1 : outData << "        Jan " << Year << "     ";
			break;
			case 2 : outData << "        Feb " << Year << "     ";
			break;
			case 3 : outData << "        Mar " << Year << "     ";
			break;
			case 4 : outData << "        Apr " << Year << "     ";
			break;
			case 5 : outData << "        May " << Year << "     ";
			break;
			case 6 : outData << "        Jun " << Year << "     ";
			break;
			case 7 : outData << "        Jul " << Year << "     ";
			break;
			case 8 : outData << "        Aug " << Year << "     ";
			break;
			case 9 : outData << "        Sep " << Year << "     ";
			break;
			case 10 : outData << "        Oct " << Year << "     ";
			break;
			case 11 : outData << "        Nov " << Year << "     ";
			break;
			case 12 : outData << "        Dec " << Year << "     ";
			break;
		}
	}
}
void PrintDays(int D, int DN, int YC, int C, int Year, int M, int days, int & leftdays,
	int & middays, int & rightdays, int & leftD, int & midD, int & rightD, bool file,
	fstream & outData)
{
	D = 1;
	int daynum = 0, count, max;
	max = M + 2;
	for (count = M; count <= max; count++)
	{
		D = 1;
		Compute (DN, count, D, YC, C, Year);
		FirstLine (DN, D, 9, file, outData);
		if (file == false)
			cout << "    ";
		else
			outData << "    ";
		FindDays (count, Year, days);
		if (count == 1 || count == 4 || count == 7 || count == 10)
		{
			leftdays = days;
			leftD = D;
		}
		else if (count == 2 || count == 5 || count == 8 || count == 11)
		{
			middays = days;
			midD = D;
		}
		else
		{
			rightdays = days;
			rightD = D;
		}
	}
	if (file == false)
		cout << endl;
	else
		outData << endl;
	while (leftD <= rightdays || midD <= middays || rightD <= rightdays)
	{
		for (count = M; count <= max; count++)
		{
			if (count == 1 || count == 4 || count == 7 || count == 10)
			{
				FirstLine(0, leftD, leftdays, file, outData);
				if (file == false)
					cout << "    ";
				else
					outData << "    ";
			}
			else if (count == 2 || count == 5 || count == 8 || count == 11)
			{
				FirstLine(0, midD, middays, file, outData);
				if (file == false)
					cout << "    ";
				else
					outData << "    ";
			}
			else
			{
				FirstLine(0, rightD, rightdays, file, outData);
				if (file == false)
					cout << endl;
				else
					outData << endl;
			}
		}
	}
}
void Compute (int & DN, int M, int D, int YC, int C, int Year)
{

	FixMonth (M, Year);
	SplitYear (Year, C, YC);
	DN = ((13 * M - 1) / 5 + D + YC + YC / 4 + C / 4 - 2 * C) % 7;
	while (DN < 0)
		DN = DN + 7;
}
void FixMonth (int & M, int & Year)
{
	if (M == 1 || M == 2)
	{
		M = M + 10;
		Year = Year - 1;
	}
	else
		M = M - 2;
}
void SplitYear (int Year, int & C, int & YC)
{
	C = Year / 100;
	YC = Year - C * 100;
}
void FindDays (int M, int Year, int & days)
{
	if (M == 2 && Year % 400 == 0)
		days = 29;
	else if (M == 2 && Year % 100 == 0)
		days = 28;
	else if (M == 2	&& Year % 4 == 0)
		days = 29;
	else if (M == 2)
		days = 28;
	else if (M == 1 || M == 3 || M == 5 || M == 7 || M == 8 || M == 10 || M == 12)
		days = 31;
	else
		days = 30;
}
void FirstLine (int DN, int & D, int max, bool file, fstream & outData)
{
	int i = 0;
	if (file == false)
	{
		if (D <= max)
		{
			if (D < 10)
			{
				switch (DN)
				{
					case 0: cout << " " << D; // SUNDAY
					break;
					case 1: cout << "    "  << D; // MONDAY
					break;
					case 2: cout << "       " << D; // TUESDAY
					break;
					case 3: cout << "          " << D; // WEDNESDAY
					break;
					case 4: cout << "             " << D; // THURSDAY
					break;
					case 5: cout << "                " << D; // FRIDAY
					break;
					case 6: cout << "                   " << D; // SATURDAY
					break;
				}
			}
			else
			{
				switch (DN)
				{
					case 0: cout << D; // SUNDAY
					break;
					case 1: cout << "   "  << D; // MONDAY
					break;
					case 2: cout << "      " << D; // TUESDAY
					break;
					case 3: cout << "         " << D; // WEDNESDAY
					break;
					case 4: cout << "            " << D; // THURSDAY
					break;
					case 5: cout << "               " << D; // FRIDAY
					break;
					case 6: cout << "                  " << D; // SATURDAY
					break;
				}
			}
			D++;
			i = DN + 2;
			while (i <= 7)
			{
				if (D <= max)
				{
					if (D < 10)
						cout << "  " << D;
					else
						cout << " " << D;
				}
				else
					cout << "   ";
				D++;
				i++;
			}
		}
		else
			cout << "                    ";
	}
	else
	{
		if (D <= max)
		{
			if (D < 10)
			{
				switch (DN)
				{
					case 0: outData << " " << D; // SUNDAY
					break;
					case 1: outData << "    "  << D; // MONDAY
					break;
					case 2: outData << "       " << D; // TUESDAY
					break;
					case 3: outData << "          " << D; // WEDNESDAY
					break;
					case 4: outData << "             " << D; // THURSDAY
					break;
					case 5: outData << "                " << D; // FRIDAY
					break;
					case 6: outData << "                   " << D; // SATURDAY
					break;
				}
			}
			else
			{
				switch (DN)
				{
					case 0: outData << D; // SUNDAY
					break;
					case 1: outData << "   "  << D; // MONDAY
					break;
					case 2: outData << "      " << D; // TUESDAY
					break;
					case 3: outData << "         " << D; // WEDNESDAY
					break;
					case 4: outData << "            " << D; // THURSDAY
					break;
					case 5: outData << "               " << D; // FRIDAY
					break;
					case 6: outData << "                  " << D; // SATURDAY
					break;
				}
			}
			D++;
			i = DN + 2;
			while (i <= 7)
			{
				if (D <= max)
				{
					if (D < 10)
						outData << "  " << D;
					else
						outData << " " << D;
				}
				else
					outData << "   ";
				D++;
				i++;
			}
		}
		else
			outData << "                    ";
	}

}
void SaveToDisk(bool & save)
{
	char ans;
	cout << "Save calendar to disk? (y/n) ";
	cin >> ans;
	if (ans == 'y' || ans == 'Y')
		save = true;
}
