{ Copyright  1996, Con Brio, Seward, all rights reserved.

Although I retain the copyright, this unit and demo are totally
free (along with source code).  You may use the unit i2bConvert
in any program, private or commercial.

If you find it useful (or even if you don't) then I would
appreciate any of the following:

   * An email message with greetings and where you hail from.
   * Comments, suggestions, bug finds, etc.
   * If you improve the unit, please send me a copy of the
     changes.
   * If you create a component from this code, please send me
     a copy (along with the source, if possible).

Mike Reith
Seward, NE, USA
mike@seward.ccsn.edu

This unit and the associated demo program can be freely used
and distributed in commercial and private environments, provided
this notice is not modified in any way and there is no charge
for it.

Date last modified:  28 July 1996
}
unit MainWin;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Buttons, Spin;

type
  TMainForm = class(TForm)
    IconImage: TImage;
    ANDMask: TImage;
    ConvertedImage: TImage;
    IconSB: TSpeedButton;
    LoadDlg: TOpenDialog;
    SaveDlg: TSaveDialog;
    ColorDlg: TColorDialog;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    ExitBtn: TSpeedButton;
    LoadBtn: TSpeedButton;
    SaveBtn: TSpeedButton;
    SaveAllBtn: TSpeedButton;
    ColorBtn: TSpeedButton;
    HelpBtn: TSpeedButton;
    EnableSB: TCheckBox;
    SpinEdit: TSpinEdit;
    TotalFreeMemory: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
    procedure LoadBtnClick(Sender: TObject);
    procedure SaveBtnClick(Sender: TObject);
    procedure SaveAllBtnClick(Sender: TObject);
    procedure HelpBtnClick(Sender: TObject);
    procedure EnableSBClick(Sender: TObject);
    procedure SpinEditChange(Sender: TObject);
    procedure ColorBtnClick(Sender: TObject);
  private
    { Private declarations }
    NumIcons : integer;      { the number of icons in the file }
    HeapStat : THeapStatus;  { get information about memory to check
                               for leaks }
    TransColor : TColor;     { Color to use for the transparent color }
    procedure LoadIcon(IconNum : integer);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

uses
  ShellAPI, I2BConvert;

procedure TMainForm.LoadIcon(IconNum : integer);
var
  Bitmap : TBitmap;
  IconInfo : TIconInfo;
begin
Bitmap := TBitmap.Create;
try
  IconImage.Picture.Icon.Handle := ExtractIcon(hInstance,
                    PChar(LoadDlg.FileName),IconNum);
  ConvertIcon2Bitmap(IconImage.Picture.Icon,TransColor,Bitmap);
  ConvertedImage.Picture.Bitmap.Assign(Bitmap);
  IconSB.Glyph.Assign(Bitmap);
  GetIconInfo(IconImage.Picture.Icon.Handle,IconInfo);
  ANDMask.Picture.Bitmap.Handle := IconInfo.hbmMask;
finally
  Bitmap.Free;
  HeapStat := GetHeapStatus;
  TotalFreeMemory.Caption := IntToStr(HeapStat.TotalFree);
  end;
end;

procedure TMainForm.LoadBtnClick(Sender: TObject);
var
  OldFileName : string;   { Save the old info just in case the file that }
  OldNumIcons : integer;  { is chosen has no icons in it. }
begin
OldFileName := LoadDlg.FileName;
OldNumIcons := NumIcons;
if LoadDlg.Execute then
  begin  { LoadDlg.Execute }
  NumIcons := ExtractIcon(hInstance, PChar(LoadDlg.FileName), -1);
  if NumIcons > 0 then
    begin  { NumIcons > 0 }
    SpinEdit.Value := 0;
    IconImage.Picture.Icon.Handle := ExtractIcon(hInstance,
              PChar(LoadDlg.FileName),0);
    LoadIcon(0);
    SaveBtn.Enabled := true;
    end   { NumIcons > 0 }
  else
    begin
    MessageDlg('No icons in this file',mtInformation,[mbOk],0);
    LoadDlg.FileName := OldFileName;
    NumIcons := OldNumIcons;
    end;
  end;  { LoadDialog.Execute }
if NumIcons > 1 then
  begin  { enable spin control to see more icons }
  SpinEdit.Visible := true;
  SpinEdit.MaxValue := NumIcons - 1;
  end   { enable spin control to see more icons }
else
  SpinEdit.Visible := false;
SaveAllBtn.Enabled := NumIcons > 1;
HeapStat := GetHeapStatus;
TotalFreeMemory.Caption := IntToStr(HeapStat.TotalFree);
end;

procedure TMainForm.ExitBtnClick(Sender: TObject);
begin
Close;
end;

procedure TMainForm.SpinEditChange(Sender: TObject);
begin
if SpinEdit.Value > NumIcons - 1 then
  SpinEdit.Value := NumIcons - 1
else if SpinEdit.Value < 0 then
  SpinEdit.Value := 0;
LoadIcon(SpinEdit.Value);
end;

procedure TMainForm.SaveBtnClick(Sender: TObject);
begin
SaveDlg.Title := 'Save this icon';
SaveDlg.FileName := ChangeFileExt(LoadDlg.FileName,'.BMP');
if SaveDlg.Execute then
  ConvertedImage.Picture.Bitmap.SaveToFile(SaveDlg.FileName);
end;

function SequentialFileName(FileName : string;
                            Num : integer) : string;
var
  JustName : string;
begin
JustName := ChangeFileExt(FileName,'');
Result := JustName + ' ' + IntToStr(Num) + ExtractFileExt(FileName);
end;

procedure TMainForm.SaveAllBtnClick(Sender: TObject);
var
  i : integer;
begin
SaveDlg.FileName := ChangeFileExt(LoadDlg.FileName,'.BMP');
SaveDlg.Title := 'Save all icons in this file';
if SaveDlg.Execute then
  begin
  IconImage.Visible := false;
  ConvertedImage.Visible := false;
  try
    for i := 0 to NumIcons - 1 do
      begin
      LoadIcon(i);
      IconSB.Update;
      ConvertedImage.Picture.Bitmap.SaveToFile(
                SequentialFileName(SaveDlg.FileName,i));
      end;
  finally
    IconImage.Visible := true;
    ConvertedImage.Visible := true;
    SpinEdit.Value := 0;
    LoadIcon(0);
    end;
  end;
end;

procedure TMainForm.EnableSBClick(Sender: TObject);
begin
if EnableSB.Checked then
  IconSB.Enabled := false
else
  IconSB.Enabled := true;
end;

procedure TMainForm.HelpBtnClick(Sender: TObject);
begin
Application.HelpFile := ChangeFileExt(Application.ExeName,'.HLP');
Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
  HeapStat : THeapStatus;
begin
HeapStat := GetHeapStatus;
TotalFreeMemory.Caption := IntToStr(HeapStat.TotalFree);
TransColor := i2bDefaultColor;
end;

procedure TMainForm.ColorBtnClick(Sender: TObject);
begin
if ColorDlg.Execute then
  if ColorDlg.Color <> TransColor then
    begin  { new color }
    TransColor := ColorDlg.Color;
    if LoadDlg.FileName <> '' then
      begin
      LoadIcon(SpinEdit.Value);
      end;
    end;  { new color }
end;

end.

