unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Menus, ExtCtrls, Buttons, PGTray95;

type
  TMainForm = class(TForm)
    ShowIconButton: TButton;
    HideIconButton: TButton;
    BrowseForIconDialog: TOpenDialog;
    TrayIcon: TPGTrayIcon95;
    NotepadPopupMenu: TPopupMenu;
    Exit2: TMenuItem;
    N2: TMenuItem;
    ShowHintLabel: TLabel;
    ShowHintCheckbox: TCheckBox;
    AutoPopupCheckbox: TCheckBox;
    AutoPopupLabel: TLabel;
    HintEdit: TEdit;
    Label4: TLabel;
    About1: TMenuItem;
    Registration1: TMenuItem;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    DisabledRadioButton: TRadioButton;
    EnabledRadioButton: TRadioButton;
    AnimatedRadioButton: TRadioButton;
    EnabledIconImage: TImage;
    DisabledIconImage: TImage;
    EnabledLabel: TLabel;
    DisabledLabel: TLabel;
    AnimatedLabel: TLabel;
    SamplesComboBox: TComboBox;
    Label2: TLabel;
    Label3: TLabel;
    ShowDemo1: TMenuItem;
    HideDemo1: TMenuItem;
    N1: TMenuItem;
    Memo1: TMemo;
    procedure ShowIconButtonClick(Sender: TObject);
    procedure HintEditChange(Sender: TObject);
    procedure HideIconButtonClick(Sender: TObject);
    procedure RegisterNowButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure AutoPopupCheckboxClick(Sender: TObject);
    procedure ShowHintCheckboxClick(Sender: TObject);
    procedure AutoPopupLabelClick(Sender: TObject);
    procedure ShowHintLabelClick(Sender: TObject);
    procedure TrayIconClick(Sender: TObject);
    procedure EnabledRadioButtonClick(Sender: TObject);
    procedure DisabledRadioButtonClick(Sender: TObject);
    procedure AnimatedRadioButtonClick(Sender: TObject);
    procedure SamplesComboBoxChange(Sender: TObject);
    procedure AnimatedLabelClick(Sender: TObject);
    procedure DisabledLabelClick(Sender: TObject);
    procedure EnabledLabelClick(Sender: TObject);
    procedure EnabledIconImageDblClick(Sender: TObject);
    procedure DisabledIconImageDblClick(Sender: TObject);
    procedure TrayIconDblClick(Sender: TObject);
    procedure ShowDemo1Click(Sender: TObject);
    procedure HideDemo1Click(Sender: TObject);
    procedure Exit2Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  public
    procedure ChangeDirectory(APath: string);
    procedure ShowDemoDialog;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{ Include a resource file that has some icons in it.  This is used }
{ to demonstrate how you can use the TPGTrayIcon95 VCL with icons }
{ that reside in the current executable.  See the "SamplesComboBoxChange" }
{ method for some sample code. }
{$IFDEF VER80}
  {$R ICONS16.RES}
{$ELSE}
  {$R ICONS32.RES}
{$ENDIF}

procedure TMainForm.ShowIconButtonClick(Sender: TObject);
begin
  { Show the tray icon in the system tray. }
  TrayIcon.ShowIcon;
end;

procedure TMainForm.HideIconButtonClick(Sender: TObject);
begin
  { Hide the tray icon. }
  TrayIcon.HideIcon;
end;

procedure TMainForm.AutoPopupCheckboxClick(Sender: TObject);
begin
  { Toggles displaying the Popup menu on right click on/off. }
  TrayIcon.AutoPopup := AutoPopupCheckBox.Checked;
end;

procedure TMainForm.ShowHintCheckboxClick(Sender: TObject);
begin
  { Toggles displaying the icon's hint on/off. }
  TrayIcon.ShowHint := ShowHintCheckBox.Checked;
end;

procedure TMainForm.AutoPopupLabelClick(Sender: TObject);
begin
  { Toggles displaying the right click Popup menu on and off. }
  AutoPopupCheckBox.Checked := not AutoPopupCheckBox.Checked;
end;

procedure TMainForm.ShowHintLabelClick(Sender: TObject);
begin
  { Toggles displaying the icon's hint on and off. }
  ShowHintCheckBox.Checked := not ShowHintCheckBox.Checked;
end;

procedure TMainForm.HintEditChange(Sender: TObject);
begin
  { Display the hint that the user just typed in. }
  TrayIcon.Hint := HintEdit.Text;
end;

procedure TMainForm.TrayIconClick(Sender: TObject);
begin
  { Respond to the icon begin single clicked. }
  MessageDlg('That was a single click !!!', mtInformation, [mbOk], 0);
end;

procedure TMainForm.TrayIconDblClick(Sender: TObject);
begin
  { Respond to the icon begin double clicked. }
  MessageDlg('That was a double click !!!', mtInformation, [mbOk], 0);
end;

procedure TMainForm.RegisterNowButtonClick(Sender: TObject);
begin
  { Display the Registration help topic in the component help file. }
  Application.HelpJump('Ordering_Information_Order_Form');
end;

procedure TMainForm.About1Click(Sender: TObject);
begin
  { Display the About information for this component. }
  Application.HelpJump('About');
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  { Show the components help if the user needs help. }
  Application.HelpFile := 'PGTRAY95.HLP';

  { Change to the project directory so the help file will be available. }
  ChangeDirectory(ExtractFilePath(Application.Exename));

  { Initially display the "Smiley Face" sample when the Demo begins. }
  SamplesComboBox.ItemIndex := 0;
  SamplesComboBoxChange(Self);

  { Display a dialog that explains what the Demo demonstrates. }
  ShowDemoDialog;
end;

procedure TMainForm.EnabledRadioButtonClick(Sender: TObject);
begin
  { Tell the TrayIcon to display the icon in it's "Icon" property. }
  TrayIcon.State := tsEnabled;
end;

procedure TMainForm.DisabledRadioButtonClick(Sender: TObject);
begin
  { Tell the TrayIcon to display the icon in it's "DisabledIcon" property. }
  TrayIcon.State := tsDisabled;
end;

procedure TMainForm.AnimatedRadioButtonClick(Sender: TObject);
begin
  { Tell the TrayIcon to display the icons that are listed in }
  { the Animation.Icons property. }
  TrayIcon.State := tsAnimated;
end;

{ This event is responsible for setting up the tray icon to }
{ display various icons and animations, depending on the }
{ option that the user selected.  Normally all of this would }
{ be done at design time, in the Object Inspector. }
procedure TMainForm.SamplesComboBoxChange(Sender: TObject);
begin
  { Make sure that we're in the application directory, so }
  { we can find the sample icons. }
  ChangeDirectory(ExtractFilePath(Application.Exename));

  { Load the group of icons that the user selected. }
  { i.e. Make the TrayIcon display:  }
  {       1. A Smiley Face.          }
  {       2. A Burning Trashcan.     }
  {       3. A Flashing light bulb.  }
  case SamplesComboBox.ItemIndex of

    0: { Smiley Face !!! }
      begin
      { Set the icons that will be displayed when the }
      { TrayIcon is in its enabled and disabled states. }
      TrayIcon.Icon.LoadFromFile('SMILEY3.ICO');
      TrayIcon.DisabledIcon.LoadFromFile('SAD.ICO');

      { Tell the TrayIcon that the icons to be used in the }
      { animation are icon files. }
      TrayIcon.Animation.Options := aoIconsAreFiles;
      TrayIcon.Animation.Icons.Clear;
      TrayIcon.Animation.Icons.Add('SMILEY1.ICO');
      TrayIcon.Animation.Icons.Add('SMILEY2.ICO');
      TrayIcon.Animation.Icons.Add('SMILEY3.ICO');
      TrayIcon.Animation.Icons.Add('SMILEY4.ICO');
      TrayIcon.Animation.Icons.Add('SMILEY3.ICO');

      { Make the animation of the face smiling and winking a "slow" }
      { animation so we can see the expressions clearly. }
      TrayIcon.Animation.Interval := 400;
      end;

    1: { Flashing Light }
       { Note: The following code sets up the TrayIcon to use icons }
       { that were included as resources in the current executable. }
       { This allows developers to create TrayIcon applications that will }
       { not require external icon files at runtime. }
      begin
      { Set the icons that will be displayed when the }
      { TrayIcon is in its enabled and disabled states. }
      { In the above example, these icons were loaded from }
      { external icon files.  In this example, the icons are }
      { included in the executable, so we load the icons by }
      { using the LoadIcon API call. }
      TrayIcon.Icon.Handle := WinProcs.LoadIcon(HInstance, 'LIGHTON');
      TrayIcon.DisabledIcon.Handle := WinProcs.LoadIcon(HInstance, 'LIGHTOFF');

      { Tell the TrayIcon that the icons to be used in the }
      { animation are icon resources that are included in }
      { the current executable.  While the above Icon and DisabledIcon }
      { properties required us to use the LoadIcon API call to load }
      { an icon from the executable, the Animation property takes care }
      { of these details "behind the scenes", once it is has been }
      { told where to look. }
      TrayIcon.Animation.Options := aoIconsInExe;
      TrayIcon.Animation.Icons.Clear;
      TrayIcon.Animation.Icons.Add('LIGHTON');
      TrayIcon.Animation.Icons.Add('LIGHTON');
      TrayIcon.Animation.Icons.Add('LIGHTOFF');
      TrayIcon.Animation.Icons.Add('LIGHTOFF');
      TrayIcon.Animation.Icons.Add('LIGHTON');
      TrayIcon.Animation.Icons.Add('LIGHTOFF');
      TrayIcon.Animation.Icons.Add('LIGHTON');
      TrayIcon.Animation.Icons.Add('LIGHTOFF');

      { Make the animation of the light bulb flashing on and off }
      { a "fast" animation. }
      TrayIcon.Animation.Interval := 150;
      end;

    2: { Burning Trashcan }
      begin
      { Set the icons that will be displayed when the }
      { TrayIcon is in its enabled and disabled states. }
      TrayIcon.Icon.LoadFromFile('TRASH3.ICO');
      TrayIcon.DisabledIcon.LoadFromFile('NOTRASH.ICO');

      { Tell the TrayIcon that the icons to be used in the }
      { animation are icon files. }
      TrayIcon.Animation.Options := aoIconsAreFiles;
      TrayIcon.Animation.Icons.Clear;
      TrayIcon.Animation.Icons.Add('TRASH1.ICO');
      TrayIcon.Animation.Icons.Add('TRASH2.ICO');
      TrayIcon.Animation.Icons.Add('TRASH3.ICO');

      { Make the animation of the fire burning in the trashcan }
      { a "fast" animation to simulate the flickering of a fire. }
      TrayIcon.Animation.Interval := 150;
      end;
  end;

  { Display the icons for this sample on the form. }
  EnabledIconImage.Picture.Icon.Assign(TrayIcon.Icon);
  DisabledIconImage.Picture.Icon.Assign(TrayIcon.DisabledIcon);

  { Set the hint of the TrayIcon to display the name of the }
  { current sample being displayed. }
  TrayIcon.Hint := SamplesComboBox.Text;
end;

procedure TMainForm.AnimatedLabelClick(Sender: TObject);
begin
  { Animates the TrayIcon if it is not already being animated. }
  if not AnimatedRadioButton.Checked then
    AnimatedRadioButton.Checked := true;
end;

procedure TMainForm.DisabledLabelClick(Sender: TObject);
begin
  { Disables the TrayIcon if it is not already disabled. }
  if not DisabledRadioButton.Checked then
    DisabledRadioButton.Checked := true;
end;

procedure TMainForm.EnabledLabelClick(Sender: TObject);
begin
  { Enables the TrayIcon if it is not already enabled. }
  if not EnabledRadioButton.Checked then
    EnabledRadioButton.Checked := true;
end;

procedure TMainForm.EnabledIconImageDblClick(Sender: TObject);
begin
  { Change the enabled icon to the icon that the user }
  { selected in the browse dialog. }
  if BrowseForIconDialog.Execute then
    begin
    TrayIcon.Icon.LoadFromFile(BrowseForIconDialog.Filename);
    EnabledIconImage.Picture.LoadFromFile(BrowseForIconDialog.Filename);
    end;
end;

procedure TMainForm.DisabledIconImageDblClick(Sender: TObject);
begin
  { Change the disabled icon to the icon that the user }
  { selected in the browse dialog. }
  if BrowseForIconDialog.Execute then
    begin
    TrayIcon.DisabledIcon.LoadFromFile(BrowseForIconDialog.Filename);
    DisabledIconImage.Picture.LoadFromFile(BrowseForIconDialog.Filename);
    end;
end;

procedure TMainForm.HideDemo1Click(Sender: TObject);
begin
  { Hide's the application by hiding both the Main Form and }
  { the Application's task bar icon. }
  TrayIcon.HideApplication;
end;

procedure TMainForm.ShowDemo1Click(Sender: TObject);
begin
  { Shows the application by showing both the Main Form and }
  { the Application's task bar icon. }
  TrayIcon.ShowApplication;
end;

procedure TMainForm.Exit2Click(Sender: TObject);
begin
  { Exit the Demo. }
  Application.Terminate;
end;

{ In Delphi 1.0, If you try and "ChDir" to a directory that was }
{ extracted from a filename with "ExtractFilePath", you will get an error }
{ because "ChDir" doesn't like trailing slashes, and "ExtractFilePath" }
{ leaves trailing slashes on.  This removes the trailing slash.  This }
{ problem only occurs under Windows95. }
procedure TMainForm.ChangeDirectory(APath: string);
var
  LastCharPos: Integer;
begin
  { Remove the trailing slash if it exists. }
  LastCharPos := Length(APath);
  if APath[LastCharPos] = '\' then
    Delete(APath, LastCharPos, 1);

  { Change to the destination directory. }
  ChDir(APath);
end;

procedure TMainForm.ShowDemoDialog;
var
  MsgStr: string;
begin
  MsgStr := EmptyStr;
  MsgStr := MsgStr + 'This application demonstrates key features' + #10;
  MsgStr := MsgStr + 'of the TPGTrayIcon95 component.' + #10#10;
  MsgStr := MsgStr + 'Click OK, and right click the "Smiley Face"' + #10;
  MsgStr := MsgStr + 'tray icon to display a Popup menu and' + #10;
  MsgStr := MsgStr + 'further explore the components features.' + #10;

  MessageDlg(MsgStr, mtInformation, [mbOk], 0);
end;

procedure TMainForm.FormActivate(Sender: TObject);
begin
  ActiveControl := ShowIconButton;
end;

end.
