Attribute VB_Name = "HelpBuilderDeclarations"

' MODULE:  HELPVB5.BAS
'
' PURPOSE: Help system definitions for Visual Basic V3
'
' AUTHOR:  GPP Software
'
' DATE:    29/12/1999

Option Explicit

' Commands to pass WinHelp()
Global Const HELP_CONTEXT = &H1         ' Display topic in ulTopic
Global Const HELP_QUIT = &H2            ' Terminate help
Global Const HELP_INDEX = &H3           ' Display index
Global Const HELP_CONTENTS = &H3
Global Const HELP_HELPONHELP = &H4      ' Display help on using help
Global Const HELP_SETINDEX = &H5        ' Set the current Index for multi index help
Global Const HELP_SETCONTENTS = &H5
Global Const HELP_CONTEXTPOPUP = &H8
Global Const HELP_FORCEFILE = &H9
Global Const HELP_KEY = &H101           ' Display topic for keyword in dwData
Global Const HELP_COMMAND = &H102
Global Const HELP_POPUPID = &H104
Global Const HELP_PARTIALKEY = &H105    ' Partial key search (display search dialog)
Global Const HELP_CLOSEWINDOW = &H107
Global Const HELP_CONTEXTNOFOCUS = &H108
Global Const HELP_MULTIKEY = &H201
Global Const HELP_SETWINPOS = &H203

' API declarations
Public Const HBWM_KEYDOWN = &H100
Public Const HBVK_F1 = &H70
Declare Function HbSendMessage Lib "User32" Alias "SendMessageA" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long

' Function declarations
Declare Function WinHelp32V Lib "User32" Alias "WinHelpA" (ByVal hWnd As Long, ByVal lpHelpFile As String, ByVal wCommand As Long, ByVal dwData As String) As Long
Declare Function WinHelp32L Lib "User32" Alias "WinHelpA" (ByVal hWnd As Long, ByVal lpHelpFile As String, ByVal wCommand As Long, dwData As Long) As Long

Function HelpContents(rfrmMain As Form) As Long

    HelpContents = WinHelp(rfrmMain.hWnd, App.HelpFile, HELP_INDEX, 0)

End Function

Function HelpSearch(rfrmMain As Form) As Long

    Dim lsDummy As String


    lsDummy = ""
    HelpSearch = WinHelp(rfrmMain.hWnd, App.HelpFile, HELP_PARTIALKEY, lsDummy)

End Function

Function HelpUsing(rfrmMain As Form) As Long

    HelpUsing = WinHelp(rfrmMain.hWnd, "", HELP_HELPONHELP, 0)

End Function

Function WinHelp(ByVal vhWnd As Long, ByVal vlpHelpFile As String, ByVal vwCommand As Long, rdwdata As Variant) As Long

    Dim llLong As Long


    If VarType(rdwdata) = 3 Then  ' V_LONG
        ' Handle call where rdwData is a numeric ie a context ID

        llLong = rdwdata
        WinHelp = WinHelp32L(vhWnd, vlpHelpFile, vwCommand, llLong)

    Else
        ' Handle call where rdwData is a string ie a search string

        WinHelp = WinHelp32V(vhWnd, vlpHelpFile, vwCommand, rdwdata)
    End If

End Function

Sub HelpButton(rfrmForm As Form)

    Dim llRc As Long


    llRc = HbSendMessage(rfrmForm.hWnd, HBWM_KEYDOWN, HBVK_F1, 0)

End Sub
