/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.distribution.simple;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Category;
import org.nakedobjects.distribution.simple.SocketedObjectServer;

public abstract class Listener
implements Runnable {
    static final Category LOG = Category.getInstance((Class)(class$org$nakedobjects$distribution$simple$Listener == null ? (class$org$nakedobjects$distribution$simple$Listener = Listener.class$("org.nakedobjects.distribution.simple.Listener")) : class$org$nakedobjects$distribution$simple$Listener));
    private ThreadGroup clientThreadGroup;
    private ServerSocket listenSocket;
    private boolean acceptConnections = true;
    private SocketedObjectServer server;
    static /* synthetic */ Class class$org$nakedobjects$distribution$simple$Listener;

    public Listener(String string, int n, SocketedObjectServer socketedObjectServer) {
        this.server = socketedObjectServer;
        try {
            if (string == null) {
                this.listenSocket = new ServerSocket(n);
            } else {
                socketedObjectServer.log("Setting up socket server on " + string);
                this.listenSocket = new ServerSocket(n, 50, InetAddress.getByName(string));
            }
            this.listenSocket.setSoTimeout(1000);
            socketedObjectServer.log(this + " set up on port " + n);
        }
        catch (IOException iOException) {
            socketedObjectServer.log("Failed to start " + this + " socket on port " + n + " (" + iOException.getMessage() + ")");
            LOG.error((Object)"Failed to start listener socket", (Throwable)iOException);
            System.exit(0);
        }
        this.clientThreadGroup = new ThreadGroup("clients");
    }

    protected void acceptConnection() {
        try {
            Socket socket = this.listenSocket.accept();
            Runnable runnable = this.createConnection(socket, this.server);
            new Thread(this.clientThreadGroup, runnable).start();
        }
        catch (InterruptedIOException interruptedIOException) {
        }
        catch (SocketException socketException) {
        }
        catch (IOException iOException) {
            LOG.error((Object)"Server failed to accept connection!", (Throwable)iOException);
            this.server.log("Server failed to accept connection! " + iOException.getMessage());
        }
    }

    protected abstract Runnable createConnection(Socket var1, SocketedObjectServer var2);

    public abstract String getName();

    public void run() {
        LOG.debug((Object)"Status: Awaiting client connections");
        LOG.info((Object)("Listening on " + this.listenSocket.getInetAddress().getHostName() + "/" + this.listenSocket.getInetAddress().getHostAddress() + " on port " + this.listenSocket.getLocalPort()));
        while (this.acceptConnections) {
            this.acceptConnection();
        }
        LOG.debug((Object)"Listener shutdown");
    }

    public void shutdown() {
        this.acceptConnections = false;
    }

    public void start() {
        new Thread((Runnable)this, this.getName()).start();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

