/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.persistence.file;

import java.util.Vector;
import org.nakedobjects.object.NakedClass;
import org.nakedobjects.object.ObjectNotFoundException;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.persistence.file.CollectionData;
import org.nakedobjects.persistence.file.Data;
import org.nakedobjects.persistence.file.FileOid;
import org.nakedobjects.persistence.file.ObjectData;

public abstract class DataManager {
    public final void create(Data data) throws ObjectStoreException {
        if (data.getOid() == null) {
            throw new IllegalArgumentException("Oid must be non-null");
        }
        this.write(data);
        String string = data.getClassName();
        FileOid fileOid = data.getOid();
        Vector vector = this.readInstanceFile(string);
        vector.addElement(fileOid);
        this.writeInstanceFile(string, vector);
    }

    public final FileOid createOid() throws ObjectStoreException {
        return new FileOid(this.nextId());
    }

    public final Data read(Object object) throws ObjectNotFoundException, ObjectStoreException {
        return this.readDataFile(((FileOid)object).getSerialNo());
    }

    public final CollectionData readCollection(Object object) throws ObjectNotFoundException, ObjectStoreException {
        return (CollectionData)this.read(object);
    }

    public final Vector readInstances(NakedClass nakedClass) throws ObjectStoreException {
        return this.readInstanceFile(nakedClass.getName());
    }

    public final ObjectData readObject(Object object) throws ObjectNotFoundException, ObjectStoreException {
        return (ObjectData)this.read(object);
    }

    public final void remove(Object object) throws ObjectNotFoundException, ObjectStoreException {
        Data data = this.read(object);
        String string = data.getClassName();
        Vector vector = this.readInstanceFile(string);
        vector.remove(object);
        this.writeInstanceFile(string, vector);
        this.deleteFile(((FileOid)object).getSerialNo());
    }

    public final void write(Data data) throws ObjectStoreException {
        this.writeDataFile(data.getOid().getSerialNo(), data);
    }

    public long readSerialNumber(String string) throws ObjectStoreException {
        return this.readSerialNumberFile(string);
    }

    public void writeSerialNumber(String string, long l) throws ObjectStoreException {
        this.writeSerialNumberFile(string, l);
    }

    protected abstract void deleteFile(long var1) throws ObjectStoreException;

    protected abstract long nextId() throws ObjectStoreException;

    protected abstract Data readDataFile(long var1) throws ObjectNotFoundException, ObjectStoreException;

    protected abstract Vector readInstanceFile(String var1) throws ObjectStoreException;

    protected abstract long readSerialNumberFile(String var1) throws ObjectStoreException;

    protected abstract void writeDataFile(long var1, Data var3) throws ObjectStoreException;

    protected abstract void writeInstanceFile(String var1, Vector var2) throws ObjectStoreException;

    protected abstract void writeSerialNumberFile(String var1, long var2) throws ObjectStoreException;
}

