/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.shell.deployment;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.tomcat.core.LifecycleInterceptor;
import org.apache.tomcat.core.ServiceInterceptor;
import org.apache.tomcat.shell.deployment.ConnectorConfig;
import org.apache.tomcat.shell.deployment.ContextConfig;
import org.apache.tomcat.shell.deployment.ContextManagerConfig;
import org.apache.tomcat.shell.deployment.ParameterConfig;
import org.apache.tomcat.util.XMLTree;

public class ServerConfig {
    private int adminPort = -1;
    private String workDir = "work";
    private Vector contextManagers = new Vector();

    ServerConfig(XMLTree config) {
        if (config.getName().equals("Server")) {
            this.setAdminPort((String)config.getAttribute("adminPort"));
            this.setWorkDir((String)config.getAttribute("workDir"));
            this.setContextManagers(this.getContextManagerConfigs(config));
        }
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    private Vector getContextManagerConfigs(XMLTree config) {
        Vector<ContextManagerConfig> contextManagers = new Vector<ContextManagerConfig>();
        Enumeration enumeration = config.elements();
        while (enumeration.hasMoreElements()) {
            XMLTree contextManager = (XMLTree)enumeration.nextElement();
            if (!contextManager.getName().equals("ContextManager")) continue;
            ContextManagerConfig contextManagerConfig = new ContextManagerConfig();
            contextManagerConfig.setPort((String)contextManager.getAttribute("port"));
            contextManagerConfig.setHostName((String)contextManager.getAttribute("hostName"));
            contextManagerConfig.setINet((String)contextManager.getAttribute("inet"));
            Enumeration contexts = contextManager.getElements("Context").elements();
            while (contexts.hasMoreElements()) {
                XMLTree context = (XMLTree)contexts.nextElement();
                ContextConfig contextConfig = new ContextConfig();
                contextConfig.setPath((String)context.getAttribute("path"));
                contextConfig.setDocumentBase((String)context.getAttribute("docBase"));
                contextConfig.setDefaultSessionTimeOut((String)context.getAttribute("defaultSessionTimeOut"));
                contextConfig.setIsWARExpanded((String)context.getAttribute("isWARExpanded"));
                contextConfig.setIsWARValidated((String)context.getAttribute("isWARValidated"));
                contextConfig.setIsInvokerEnabled((String)context.getAttribute("isInvokerEnabled"));
                contextConfig.setIsWorkDirPersistent((String)context.getAttribute("isWorkDirPersistent"));
                contextManagerConfig.addContextConfig(contextConfig);
            }
            Enumeration interceptors = contextManager.getElements("Interceptor").elements();
            while (interceptors.hasMoreElements()) {
                XMLTree interceptor = (XMLTree)interceptors.nextElement();
                String className = (String)interceptor.getAttribute("className");
                System.out.println("Adding Global Interceptor: " + className);
                try {
                    Object instance = Class.forName(className).newInstance();
                    String docBase = (String)interceptor.getAttribute("docBase");
                    Enumeration e = contextManagerConfig.getContextConfigs();
                    while (e.hasMoreElements()) {
                        ContextConfig contextConfig = (ContextConfig)e.nextElement();
                        if (!contextConfig.getDocumentBase().equals(docBase) && (!docBase.endsWith("*") || !contextConfig.getDocumentBase().toString().startsWith(docBase.substring(0, docBase.length() - 1)))) continue;
                        if (instance instanceof ServiceInterceptor) {
                            contextConfig.addServiceInterceptor((ServiceInterceptor)instance);
                            continue;
                        }
                        if (!(instance instanceof LifecycleInterceptor)) continue;
                        contextConfig.addLifecycleInterceptor((LifecycleInterceptor)instance);
                    }
                }
                catch (Throwable except) {
                    System.out.println("Error creating interceptor " + className + ": " + except);
                }
            }
            Enumeration connectors = contextManager.getElements("Connector").elements();
            while (connectors.hasMoreElements()) {
                XMLTree connector = (XMLTree)connectors.nextElement();
                ConnectorConfig connectorConfig = new ConnectorConfig();
                connectorConfig.setClassName((String)connector.getAttribute("className"));
                Enumeration parameters = connector.getElements("Parameter").elements();
                while (parameters.hasMoreElements()) {
                    XMLTree parameter = (XMLTree)parameters.nextElement();
                    ParameterConfig parameterConfig = new ParameterConfig();
                    parameterConfig.setName((String)parameter.getAttribute("name"));
                    parameterConfig.setValue((String)parameter.getAttribute("value"));
                    connectorConfig.addParameter(parameterConfig);
                }
                contextManagerConfig.addConnectorConfig(connectorConfig);
            }
            contextManagers.addElement(contextManagerConfig);
        }
        return contextManagers;
    }

    public Enumeration getContextManagers() {
        return this.contextManagers.elements();
    }

    public String getWorkDir() {
        return this.workDir;
    }

    void setAdminPort(int adminPort) {
        this.adminPort = adminPort;
    }

    void setAdminPort(String adminPort) {
        try {
            this.setAdminPort(Integer.parseInt(adminPort));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    void setContextManagers(Vector contextManagers) {
        this.contextManagers = contextManagers;
    }

    void setWorkDir(String workDir) {
        this.workDir = workDir;
    }
}

