                                                                                /*
  OpenGL viewer of Alchemy MOL-files and GAMESS/Gaussian OUT-files
  by Andrew Ryzhkov and Arcady Antipin    (mailto:RedAndr@mail.ru)
                                                                                */

#include "aux_glut.h"
#include "vm_math.h"
#include "vm_func.h"

void makeraster(GLenum mode, GLint x, GLint y) {

    if (windH == 0) windH = 1;

    if (mode == GL_SELECT) glGetIntegerv(GL_VIEWPORT, vp);

    glViewport (0, 0, windW, windH);

    glMatrixMode (GL_PROJECTION);

    glLoadIdentity();

    if (mode == GL_SELECT) gluPickMatrix(x,windH-y, 1, 1, vp);

    if (!persp) {

        if (windW <= windH)

                glOrtho (-maxcor, maxcor, -maxcor*windH/windW, maxcor*windH/windW, -maxcor, maxcor);

        else    glOrtho (-maxcor*windW/windH, maxcor*windW/windH, -maxcor, maxcor, -maxcor, maxcor);

    } else {

        gluPerspective (60.0, (GLdouble)windW / (GLdouble)windH, 1.0, 20.0);

    }

    glMatrixMode (GL_MODELVIEW);

    glLoadIdentity ();

    if (persp) glTranslated (0.0, 0.0, -2 * maxcor);  // viewing transform

}





void GLUTCALLBACK display(void)

{

        if (!spread) glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

        glShadeModel(GL_SMOOTH);


        glPushMatrix();

        makeraster(GL_RENDER,0,0);

        myRender (GL_RENDER);

        glPopMatrix();



        glFlush();

        glutSwapBuffers();

}



GLint DoSelect(GLint x, GLint y)

{

        GLint hits,i,o;



        glSelectBuffer(MAXSELECT, selectBuf);

        (void)glRenderMode(GL_SELECT);

        glInitNames();

        glPushName((GLuint)~0);



        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

        glShadeModel(GL_SMOOTH);



        glPushMatrix();

        makeraster(GL_SELECT,x,y);

        myRender(GL_SELECT);

        glPopMatrix();

    

        hits = glRenderMode(GL_RENDER); 



        if (hits <= 0)  return -1;

        else {

            if(debug) printf("----------\n* hits=%d\n* as:\n",hits);

            for(o=i=0;i<hits;i++) {

                if (selectBuf[o*4+1] > selectBuf[i*4+1]) o=i;

                if(debug) printf("%d %u %u %d\n",

                                selectBuf[i*4+0],

                                selectBuf[i*4+1],

                                selectBuf[i*4+2],

                                selectBuf[i*4+3]);

            }

            return selectBuf[o*4+3];

        }

}





void GLUTCALLBACK myReshape(GLsizei w, GLsizei h)

{

        windW = w;

        windH = h;

        makeraster(GL_RENDER,0,0);

        if (spread) glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

}



void printvec() {

  char img[2]=" I";

  printf("View IR vectors: %3d Frequency %7.2f%c Intensity: %9.5f\n",

  frcur,freqs[frcur].freqv,img[freqs[frcur].img],freqs[frcur].inten);

}



void GLUTCALLBACK got_away(void) { exit(0); } 
void GLUTCALLBACK dis1   (void) { maxcor/=1.2;   makeraster(GL_RENDER,0,0); }

void GLUTCALLBACK dis2   (void) { maxcor*=1.2;   makeraster(GL_RENDER,0,0); }

void GLUTCALLBACK dis3   (void) { persp=1-persp; makeraster(GL_RENDER,0,0); }

void GLUTCALLBACK dis5   (void) { wire=1-wire; }

void GLUTCALLBACK dis6   (void) { dline=1-dline; }

void GLUTCALLBACK dis7   (void) { chg=1-chg; if(debug){printf("Charge Mode: "); if(chg==1)puts("ON\n");else puts("OFF\n");} }

void GLUTCALLBACK dis8   (void) { morb=1-morb; printf("MO# %3d\n",monum);}

void GLUTCALLBACK dis9   (void) { viewir=1-viewir; if(viewir==1) printvec();}

void GLUTCALLBACK moinc  (void) { if(monum!=NumOrb)monum++;else monum=1; printf("MO# %3d\n",monum);}

void GLUTCALLBACK modec  (void) { if(monum!=1)monum--;else monum=NumOrb; printf("MO# %3d\n",monum);}

void GLUTCALLBACK frinc  (void) { if(frcur!=NumAtoms*3)frcur++;else frcur=1; printvec(); }

void GLUTCALLBACK frdec  (void) { if(frcur!=1)frcur--;else frcur=NumAtoms*3; printvec(); }

void GLUTCALLBACK swrad  (void) { trad=1-trad; }

void GLUTCALLBACK swbond (void) { bond=1-bond; }

void GLUTCALLBACK move0  (void) { ax=0; ay=0; az=0; }

void GLUTCALLBACK movex1 (void) { rotxyz(1,0,0, inca,roma); }

void GLUTCALLBACK movex2 (void) { rotxyz(1,0,0,-inca,roma); }

void GLUTCALLBACK movey1 (void) { rotxyz(0,1,0, inca,roma); }

void GLUTCALLBACK movey2 (void) { rotxyz(0,1,0,-inca,roma); }

void GLUTCALLBACK movez1 (void) { rotxyz(0,0,1, inca,roma); }

void GLUTCALLBACK movez2 (void) { rotxyz(0,0,1,-inca,roma); }

void GLUTCALLBACK shatom (void) { atnum = 1 - atnum; }

void GLUTCALLBACK chklen (void) { printf("bond(%d,%d)=%lg\n",ap1+1,ap2+1,getBondLen(ap1,ap2)); }

void GLUTCALLBACK chkang (void) { printf("angle(%d,%d,%d)=%lg\n",ap1+1,ap2+1,ap3+1,getAngle(ap1,ap2,ap3)); }

void GLUTCALLBACK chkda  (void) { printf("dihedral(%d,%d,%d,%d)=%lg\n",ap1+1,ap2+1,ap3+1,ap4+1,getDA(ap1,ap2,ap3,ap4)); }



/*-------------------------------------------------*\

|* Main Loop                                       *|

|* Open window with initial window size, title bar,*|

|* RGBA display mode, and handle input events.     *|

\*-------------------------------------------------*/

int main(int argc, char** argv)

{

  char  xstr[32];

  float mx[2],my[2],mz[2];

  int   i;

  printf("OpenGL viewer for Alchemy MOL-files and GAMESS/Gaussian9x OUT-files, ver. %4.2f\n"

         "Internet: http://RedAndr.tripod.com/vm3/\n\n",ver);



  if (argc < 2) {

    puts ("Usage : ViewMol3D <FileName.(mol/out/gms/mop)> [white] [debug] [allbonds] [atomic] [smear] [stick]\n");

    helpmsg ();

    return 1;

  }

  BondTresh = 0.5;



  for (i = 2; i < argc; i++) {

    if (strnicmp (argv[i], "white",    5) == 0) present   = 1;

    if (strnicmp (argv[i], "debug",    5) == 0) debug     = 1;

    if (strnicmp (argv[i], "allbonds", 5) == 0) BondTresh = 0;

    if (strnicmp (argv[i], "atomic",   6) == 0) atnum     = 1;

    if (strnicmp (argv[i], "smear",    5) == 0) spread = 1;

    if (strnicmp (argv[i], "stick",    5) == 0) { bond=1; dline =1; }

  }



  if (debug) printf ("BondTresh=%8.4f\n", BondTresh);



  strcpy (fname, argv[1]);

  strcpy (xstr, &fname[strlen (fname) - 3]);

  if ((strnicmp (xstr, "out", 3) == 0) ||

      (strnicmp (xstr, "gms", 3) == 0) ||

      (strnicmp (xstr, "mop", 3) == 0)) {

    if (ReadMoleculeGAMESS (fname) != 0) {

      printf ("Can't open GAMESS/G98/MOPAC OUT file '%s'\n", fname);

      return -1;

    }

  } else if (strnicmp (xstr, "mol", 3) == 0) {

      if (ReadMoleculeALCHEMY (fname) != 0) {

        printf ("Can't open ALCHEMY MOL file '%s'\n", fname);

        return -1;

      } else dline=0;

  } else if (strnicmp (xstr, "dat", 3) == 0) {

      if (ReadMOPACdat(fname)!=0) {

      } else {

      }

  } else {

      puts ("I don't known that it's file. Please give me suitable extention (MOL/OUT/GMS/MOP)");

      return -2;

    }



  // Centering molecule to (0,0,0)

  mx[0]=mx[1]=atoms[0].x; my[0]=my[1]=atoms[0].y; mz[0]=mz[1]=atoms[0].z;

  for(i=1;i<NumAtoms;i++) {

    if(atoms[i].x>mx[0])mx[0]=atoms[i].x; else if(atoms[i].x<mx[1])mx[1]=atoms[i].x;

    if(atoms[i].y>my[0])my[0]=atoms[i].y; else if(atoms[i].y<my[1])my[1]=atoms[i].y;

    if(atoms[i].z>mz[0])mz[0]=atoms[i].z; else if(atoms[i].z<mz[1])mz[1]=atoms[i].z;

  }

  mx[0]+=(mx[1]-mx[0])/2; my[0]+=(my[1]-my[0])/2; mz[0]+=(mz[1]-mz[0])/2;

  for(i=0;i<NumAtoms;i++) { atoms[i].x-=mx[0]; atoms[i].y-=my[0]; atoms[i].z-=mz[0]; }



  windW = 460;

  windH = 440;


    glutInit(&argc, argv);
    glutInitWindowPosition(128, 20);
    glutInitWindowSize(windW, windH);
    glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGBA | GLUT_ACCUM | GLUT_DEPTH);

    if (glutCreateWindow("ViewMol 3D") == GL_FALSE) {
	puts("error: glutCreateWindow == GL_FALSE");
	exit(1);
    }

    printf("OpenGL initialized:\n"

         "     Vendor  : %s\n"

         "     Renderer: %s\n"

         "     Version : %s\n",

         glGetString(GL_VENDOR),

         glGetString(GL_RENDERER),

         glGetString(GL_VERSION));

  helpmsg ();



  if (myinit () != 0) {

    puts ("Error My Own OpenGL initialization.");

    return 2;

  };


    glutReshapeFunc(myReshape);
    glutKeyboardFunc(auxKey);
    glutSpecialFunc(auxSpec);
    glutMouseFunc(auxMouseButton);
    glutMotionFunc(auxMouseMotion);
//    glutPassiveMotionFunc(auxMousePos);
    glutDisplayFunc(display);
//    glutIdleFunc(glut_post_redisplay_p);



  auxKeyFunc   (AUX_1, dis1);

  auxKeyFunc   (AUX_2, dis2);

  auxKeyFunc   (AUX_3, dis3);

  auxKeyFunc   (AUX_4, swbond);

  auxKeyFunc   (AUX_5, dis5);

  auxKeyFunc   (AUX_6, dis6);

  auxKeyFunc   (AUX_7, dis7);

  auxKeyFunc   (AUX_8, dis8);

  auxKeyFunc   (AUX_9, dis9);


  auxKeyFunc   (AUX_ESCAPE, got_away);

  auxKeyFunc   (3, got_away); /* ^C exits.. */
  auxKeyFunc   (AUX_RETURN, swrad);

  auxKeyFunc   (AUX_SPACE,  move0);

  auxKeyFunc   (AUX_UP,     movex1);

  auxKeyFunc   (AUX_DOWN,   movex2);

  auxKeyFunc   (AUX_LEFT,   movey1);

  auxKeyFunc   (AUX_RIGHT,  movey2);

  auxKeyFunc   (AUX_x,      movez1);

  auxKeyFunc   (AUX_z,      movez2);

  auxKeyFunc   (AUX_r,      Reload);

  auxKeyFunc   (AUX_v,      moinc);

  auxKeyFunc   (AUX_c,      modec);

  auxKeyFunc   (AUX_n,      shatom);

  auxKeyFunc   (AUX_l,      chklen);

  auxKeyFunc   (AUX_a,      chkang);

  auxKeyFunc   (AUX_d,      chkda);

  auxKeyFunc   (AUX_w,      frinc);

  auxKeyFunc   (AUX_q,      frdec);


  auxMouseFunc (AUX_RIGHTBUTTON, AUX_MOUSEDOWN, Mouse_right);

  auxMouseFunc (AUX_LEFTBUTTON , AUX_MOUSEDOWN, Mouse_left);

  auxMouseFunc (AUX_LEFTBUTTON , AUX_MOUSELOC,  Mouse_move);

  auxMouseFunc (AUX_LEFTBUTTON , AUX_MOUSEUP,   Mouse_leftup);

  

    glutMainLoop();


  return 0;

}





int ReadMOPACdat(char* fname)

{

  char s[80];

  FILE *f;



printf("Open file:%s\n",fname);

  f=fopen(fname,"r");

  if(f==NULL) return -1;

  fgets(s,80,f);



  fclose(f);



if(debug)printf("Atoms:%3d Bonds:%3d\n",NumAtoms,NumBonds);

  return 0;

}