/**********************************************************
*
*
*
* Timer v1.0
*
* Timer is a secret stopwatch utility for Windows 95/98/NT.
* The source code may be used for your own developments.
* Please send me your interesting extensions of the code.
*
*                                       F.Balmer 1999
*                                       textview@bluewin.ch
*
* 
**********************************************************/

#include <windows.h>
#include <string.h>


// Functions
LRESULT CALLBACK TimerWndProc(HWND,UINT,WPARAM,LPARAM);
LRESULT TimerThreadProc(LPARAM);
void    LogTime();


// Text data
#define WINDOWTITLE "Timer"
#define WINDOWCLASS "TimerWindow"
#define EVENTNAME   "TimerEvent"

#define LOGFILENAME "Timer.log"
#define LOGCOUNT    "Log Entries"
#define LOGSECTION  "Log Entry %i"
#define LOGSTART    "Start"
#define LOGEND      "Stop"
#define LOGMINUTES  "Approx. Length in Minutes"


HWND   hwndTimer;
HANDLE hEvTimer;
HANDLE hEvThread;
HANDLE hThread;
DWORD  dwtid;

SYSTEMTIME stStart;
DWORD      dwStartTicks;


///////////////////////////////////////////////////////////
//
//  WinMain() - entry point
//
//
int WINAPI WinMain(HINSTANCE hInstance,
                   HINSTANCE hPrevInstance,
                   PSTR szCmdLine,int iCmdShow)
{

  MSG msg;
  WNDCLASSEX wc;

  // Save time information
  GetLocalTime(&stStart);
  dwStartTicks = GetTickCount();
  
  // Set timer event if already created
  if (hEvTimer = OpenEvent(EVENT_MODIFY_STATE,
                           FALSE,EVENTNAME))
  {
    SetEvent(hEvTimer);
    return(0);
  }
  
  // Create control events
  hEvTimer = CreateEvent(NULL,TRUE,FALSE,EVENTNAME);
  hEvThread = CreateEvent(NULL,FALSE,FALSE,NULL);

  // Observation thread
  CreateThread(NULL,0,
               (LPTHREAD_START_ROUTINE)TimerThreadProc,
               NULL,0,&dwtid);
  
  // Setup window (remains hidden)
  wc.cbSize        = sizeof(wc);
  wc.style         = 0;
  wc.lpfnWndProc   = TimerWndProc;
  wc.cbClsExtra    = 0;
  wc.cbWndExtra    = 0;
  wc.hInstance     = hInstance;
  wc.hIcon         = NULL;
  wc.hCursor       = NULL;
  wc.hbrBackground = (HBRUSH)(COLOR_3DFACE+1);
  wc.lpszMenuName  = NULL;
  wc.lpszClassName = WINDOWCLASS;
  wc.hIconSm       = NULL;

  RegisterClassEx(&wc);

  hwndTimer = CreateWindowEx(WS_EX_CLIENTEDGE,
                             WINDOWCLASS,
                             WINDOWTITLE,
                             WS_OVERLAPPEDWINDOW,
                             CW_USEDEFAULT,
                             CW_USEDEFAULT,
                             CW_USEDEFAULT,
                             CW_USEDEFAULT,
                             NULL,
                             NULL,
                             hInstance,
                             NULL);
                        
  while (GetMessage(&msg,NULL,0,0))
  {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
  
  // Destroy events
  CloseHandle(hEvTimer);
  CloseHandle(hEvThread);
  
  return(msg.wParam);

}


///////////////////////////////////////////////////////////
//
//  TimerWndProc() - window procedure for hidden window
//
//
LRESULT CALLBACK TimerWndProc(HWND hwnd,UINT uMsg,
                              WPARAM wParam,LPARAM lParam)
{

  switch(uMsg)
  {
  
    case WM_DESTROY:
      
      SetEvent(hEvTimer);
      SetThreadPriority(hThread,
                        THREAD_PRIORITY_TIME_CRITICAL);
      WaitForSingleObject(hEvThread,INFINITE);
      
      // Save time information
      LogTime();
      
      PostQuitMessage(0);
      
      break;

    case WM_ENDSESSION:
      
      if (wParam)
      {
        SetEvent(hEvTimer);
        SetThreadPriority(hThread,
                          THREAD_PRIORITY_TIME_CRITICAL);
        WaitForSingleObject(hEvThread,INFINITE);
        
        // Save time information
        LogTime();
      }
      
      break;

    default:
      
      return DefWindowProc(hwnd,uMsg,wParam,lParam);

  }

  return(0);

}


///////////////////////////////////////////////////////////
//
//  TimerThreadProc - just wait signal to terminate
//
//
LRESULT TimerThreadProc(LPARAM lParam)
{

  WaitForSingleObject(hEvTimer,INFINITE);
  SetEvent(hEvThread);
  PostMessage(hwndTimer,WM_CLOSE,0,0);
  ExitThread(0);
  
  return(0);

}


///////////////////////////////////////////////////////////
//
//  LogTime() - save time information to log file
//
//
void LogTime()
{

  SYSTEMTIME  stEnd;
  DWORD       dwEndTicks;
  int         iLog;
  char        szLogFile[MAX_PATH];
  char        *p;
  char        szSection[128];
  char        szBuf1[128];
  char        szBuf2[128];
  int         iMinutes;

  // Save stop time
  GetLocalTime(&stEnd);
  dwEndTicks = GetTickCount();

  // Build name of log file
  GetModuleFileName(GetModuleHandle(NULL),
                    szLogFile,MAX_PATH);
  p = strrchr(szLogFile,'\\');
  if (!p)
    p = szLogFile;
  else
   p++;
  lstrcpy(p,LOGFILENAME);

  // Entry number
  iLog = GetPrivateProfileInt(LOGCOUNT,LOGCOUNT,0,
                              szLogFile);
  iLog += 1;
  
  // Entry section
  wsprintf(szSection,LOGSECTION,iLog);

  // New entry number
  wsprintf(szBuf1,"%i",iLog);
  WritePrivateProfileString(LOGCOUNT,LOGCOUNT,
                            szBuf1,szLogFile);

  // Format start time
  GetDateFormat(LOCALE_SYSTEM_DEFAULT,
                DATE_SHORTDATE,
                &stStart,
                NULL,
                szBuf1,128);
  GetTimeFormat(LOCALE_SYSTEM_DEFAULT,
                0,
                &stStart,
                NULL,
                szBuf2,128);
  lstrcat(szBuf1," ");
  lstrcat(szBuf1,szBuf2);
  WritePrivateProfileString(szSection,LOGSTART,
                            szBuf1,szLogFile);

  // Format stop time
  GetDateFormat(LOCALE_SYSTEM_DEFAULT,
                DATE_SHORTDATE,
                &stEnd,
                NULL,
                szBuf1,128);
  GetTimeFormat(LOCALE_SYSTEM_DEFAULT,
                0,
                &stEnd,
                NULL,
                szBuf2,128);
  lstrcat(szBuf1," ");
  lstrcat(szBuf1,szBuf2);
  WritePrivateProfileString(szSection,LOGEND,
                            szBuf1,szLogFile);

  // Calculate approximate length in minutes
  iMinutes = (dwEndTicks - dwStartTicks) / (1000 * 60);
  wsprintf(szBuf1,"%i",iMinutes);
  WritePrivateProfileString(szSection,LOGMINUTES,
                            szBuf1,szLogFile);

}


// End of Timer.c
