// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 02/04/1997  
// Date Last Modified: 06/12/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

gxDatabase persistent checksum example.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <iomanip.h>
#include <string.h>
#include "gxdbase.h"
#include "gxfloat.h"
#include "gxdstats.h"

const int name_length = 16;

class DatabaseObject
{ 
public:
  DatabaseObject() { name[0] = 0; oid = (gxINT32)0, cid = (gxFLOAT64)0; }
  DatabaseObject(const char *s, long i, double d);

public:
  void DisplayObject();
  
public: // Platform independent data members
  char name[name_length]; // Fixed string type
  gxINT32 oid;            // Integer type
  gxFLOAT64 cid;          // Floating point type
};

DatabaseObject::DatabaseObject(const char *s, long i, double d)
{
  for(int j = 0; j < name_length; j++) name[j] = 0; // Clear the name string
  strcpy(name, s);
  oid = i;  
  cid = d;
}

void DatabaseObject::DisplayObject()
{
  cout << "Database object name: " << name << endl;
  cout << "Database object OID:  " << oid << endl;
  cout.setf(ios::showpoint | ios::fixed);
  cout.precision(3);
  cout << "Database object CID:  " << cid << endl;
}

void PausePrg()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

int main()
{
  gxDatabase *f = new gxDatabase;
  const char *fname = "simple.gxd";
  int exists;

  cout << endl;
  cout << "Simple checksum example." << endl;

  if(!gxDatabase::Exists(fname)) {
    cout << "Creating new file..." << endl;
    f->Create(fname);
    if(CheckError(f) != 0) return 1;
    exists = 0;
  }
  else {
    cout << "Opening existing file..." << endl;
    f->Open(fname);
    if(CheckError(f) != 0) return 1;
    exists = 1;
  }
  
  PausePrg();
  DatabaseStats(f);
  PausePrg();
  
  FAU addr;
  int rv;
  __ULWORD__ object_crc, calc_crc;
  
  if(!exists) {
    cout << "Adding object to database file..." << endl;
    // Allocate a block to store the object
    addr = f->Alloc(sizeof(DatabaseObject)); 

    // Construct the datbase object
    DatabaseObject ob("Mouse", (long)addr, 1035.101);

    f->Write(&ob, sizeof(DatabaseObject));
    
    // CRC checksum routines
    __SBYTE__ rev_letter = f->GetRevLetter();
    if((rev_letter == ' ') || (rev_letter == 0)) {
      cout << "This database revision does not support persistent checksums"
	   << endl;
    }
    else {
      f->WriteObjectChecksum(addr);
      f->ReadObjectChecksum(addr, &object_crc, &calc_crc);
      cout.setf(ios::uppercase);
      cout << "Object CRC =     0x" << setfill('0') << setw(8) << hex
	   << object_crc << endl;
      cout << "Calculated CRC = 0x" << setfill('0') << setw(8) << hex
	   << calc_crc << dec << endl;
      BlockStats(f, addr);
    }
  }
  else {
    f->Open(fname); 
    cout << "Reading the first object from the database file..." << endl;
    addr = f->FindFirstBlock();

    // CRC checksum routines
    __SBYTE__ rev_letter = f->GetRevLetter();
    if((rev_letter == ' ') || (rev_letter == 0)) {
      cout << "This database revision does not support persistent checksums"
	   << endl;
    }
    else {
      rv = f->ReadObjectChecksum(addr+f->BlockHeaderSize(),
				 &object_crc, &calc_crc);
      if(!rv) cout << "Checksum error!" << endl;
      cout.setf(ios::uppercase);
      cout << "Object CRC =     0x" << setfill('0') << setw(8) << hex
	   << object_crc << endl;
      cout << "Calculated CRC = 0x" << setfill('0') << setw(8) << hex
	   << calc_crc << dec << endl;
      cout.unsetf(ios::uppercase);
      cout << endl;
    }
    DatabaseObject buf;
    f->Read(&buf, sizeof(DatabaseObject), addr+f->BlockHeaderSize());
    buf.DisplayObject();
  }

  cout << "Exiting..." << endl;
  f->Close();
  if(CheckError(f) != 0) return 1;
  delete f;
  
  return 0; 
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
