// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: gxconfig.cpp 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 02/19/1996 
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The configuration manager class is used to load program parameters 
from a text based (ASCII) configuration file. 
*/
// ----------------------------------------------------------- // 
#include <stdlib.h>
#include <stdio.h>
#include <fstream.h>
#include <string.h>
#include <ctype.h>
#include "gxconfig.h"

gxConfig::~gxConfig()
{
  UnLoad();
}

void gxConfig::UnLoad()
{
  ClearList();
}         

int gxConfig::Load(char *fname)
{
  FileName = fname;
  return Load();
}

int gxConfig::Load(const char *fname)
{
  FileName = fname;
  return Load();
}

int gxConfig::Load(const gxString &fname)
{
  FileName = fname;
  return Load();
}

int gxConfig::ReLoad()
{
  UnLoad();
  return Load();
}

int gxConfig::ReLoad(char *fname)
{
  UnLoad();
  return Load(fname);
}

int gxConfig::ReLoad(const char *fname)
{
  UnLoad();
  return Load(fname);
}

int gxConfig::ReLoad(const gxString &fname)
{
  UnLoad();
  return Load(fname);
}

void gxConfig::FilterLineFeed(char &c)
// Added to filter the end of line sequence from a line of text.
{
  switch(c) {
    case '\r':
      c = '\0';
      break;
    case '\n':
      c = '\0';
      break;
    default:
      break;
  }
}

int gxConfig::Load()
{
  const int MaxLine = 1024;
  char LineBuffer[MaxLine];
  gxString buf;
  int Status, i;
  
  // Open gxConfig file
#ifdef __BCC32__
  // The BCC 32 ios class does not have an enumeration for "nocreate"
  ifstream InFile(FileName.c_str(), ios::in);
#else
  ifstream InFile(FileName.c_str(), ios::in|ios::nocreate);
#endif
  if(!InFile) return 0; 
        
  while(!InFile.eof()) {
    // Clear the line buffer before each read
    for(i = 0; i < MaxLine; i++) LineBuffer[i] = '\0';
    
    // Read in config file line by line
    InFile.getline(LineBuffer, MaxLine);
    
    // Get rid of the end of line sequence
    for(i = 0; i < MaxLine; i++) FilterLineFeed(LineBuffer[i]);
    
    // Copy each line to temporary holding buffer
    buf = LineBuffer;
    
    // Load config file data into singly-linked list
    Status = StoreCfgData(buf);
    if(!Status) return 0;
  }

  InFile.close();
  return 1; // Indicates success
}

int gxConfig::StoreCfgData(const gxString &str)
{
  gxConfigListNode *chsptr;
  gxString buf(str);
  
  // Remove any leading space 
  unsigned offset = buf.Find(" ");
  if(offset == 0) buf.DeleteAt(offset, 1);

  if(filter_comments) { // Ignore all lines starting with a comment ID
    if(buf[0] == comment_char)
      return 1; 
  }
  
  // Look for lines containing a parm ID string
  offset = buf.Find(parm_ID.c_str());
  if(offset != -1) {
    gxString Name(buf);
    gxString Value(buf);

    // Separate the parameter name and value
    Name.DeleteAt(offset, (Name.length() - offset));
    offset = Name.Find(" "); // Remove any trailing spaces
    if(offset != -1) Name.DeleteAt(offset, 1);
    chsptr = Add(Name); // Store the parameter name
    if(!chsptr) return 0;

    // Store the config file parameter value 
    offset = Value.Find(parm_ID.c_str());
    Value.DeleteAt(0, (offset+parm_ID.length()));
    offset = Value.Find(" "); // Remove any leading spaces
    if(offset == 0) Value.DeleteAt(offset, 1);
    offset = Value.Find(" "); // Look for any trailing spaces or other chars
    if(offset != -1) {
      // Remove any comments following a space but leave long
      // character strings for values such as file names with
      // white spaces or multiple config values on one line
      if(filter_comments) {
      if(Value[offset+1] == comment_char) 
	Value.DeleteAt(offset, (Value.length() - offset));
      }
    }
    chsptr = Add(Value);
    if(!chsptr) return 0;
  }

  return 1; // Indicate success
}

gxConfigListNode *gxConfig::Add(const gxString &s)
{
  gxConfigListNode *node = new gxConfigListNode(s);
  if(!node) return 0; // Could not allocate memory for the node
  InsertAtTail((gxListNodeB *)node);
  return node;
}

gxConfigListNode *gxConfig::FindAny(const gxString &s, gxConfigListNode *ptr)
{
  if(ptr == 0) ptr = (gxConfigListNode *)GetHead();

  unsigned offset = 0;
  
  while(ptr) { // Scan until end of list
    offset = 0;
    offset = ptr->node_data.Find(s.c_str());
    if(offset != -1) return ptr; // Match found
    ptr = (gxConfigListNode *)ptr->next;
  }
  return 0; // No match
}

gxConfigListNode *gxConfig::Find(const gxString &s, gxConfigListNode *ptr)
{
  if(ptr == 0) ptr = (gxConfigListNode *)GetHead();

  while(ptr) { // Scan until end of list
    if(ptr->node_data == s) return ptr; // Match found
    ptr = (gxConfigListNode *)ptr->next;
  }
  return 0; // No match
}

char* gxConfig::GetStrValue(const gxString &Name, int fn)
// Search for string matching the "Name" variable. Will search
// using the full name unless the "fn" variable is false.
{
  gxConfigListNode *ptr;

  if(fn)
    ptr = Find(Name);
  else
    ptr = FindAny(Name);
  
  if(ptr) {
    gxString *s = (gxString *)ptr->next->data;
    if(s) return s->c_str();
  }

  // Return NULL if config value is not found
  return 0;
}

char* gxConfig::GetStrValue(char *Name, int fn)
{
  gxString buf(Name);
  return GetStrValue(buf, fn);
}

char* gxConfig::GetStrValue(const char *Name, int fn)
{
  gxString buf(Name);
  return GetStrValue(buf, fn);
}

int gxConfig::GetIntValue(const gxString &Name, int fn)
// Search for string matching the "Name" variable. Will search
// using the full name unless the "fn" variable is false.
{
  gxConfigListNode *ptr;

  if(fn)
    ptr = Find(Name);
  else
    ptr = FindAny(Name);
  
  if(ptr) {
    gxString *s = (gxString *)ptr->next->data;
    if(s) return atoi(s->c_str());
  }

  //Return NULL if config value is not found
  return 0;
}

int gxConfig::GetIntValue(char *Name, int fn)
{
  gxString buf(Name);
  return GetIntValue(buf, fn);
}


int gxConfig::GetIntValue(const char *Name, int fn)
{
  gxString buf(Name);
  return GetIntValue(buf, fn);
}

double gxConfig::GetFloatValue(const gxString &Name, int fn)
// Search for string matching the "Name" variable. Will search
// using the full name unless the "fn" variable is false.
{
  gxConfigListNode *ptr;

  if(fn)
    ptr = Find(Name);
  else
    ptr = FindAny(Name);

  if(ptr) {
    gxString *s = (gxString *)ptr->next->data;
    if(s) return atof(s->c_str());
  }

  //Return NULL if config value is not found
  return 0;
}

double gxConfig::GetFloatValue(char *Name, int fn)
{
  gxString buf(Name);
  return GetFloatValue(buf, fn);
}

double gxConfig::GetFloatValue(const char *Name, int fn)
{
  gxString buf(Name);
  return GetFloatValue(buf, fn);
}

double gxConfig::GetDFPValue(const gxString &Name, int fn)
{
  return GetFloatValue(Name, fn);
}

double gxConfig::GetDFPValue(char *Name, int fn)
{
  gxString buf(Name);
  return GetFloatValue(buf, fn);
}

double gxConfig::GetDFPValue(const char *Name, int fn)
{
  gxString buf(Name);
  return GetFloatValue(buf, fn);
}

long gxConfig::GetLongValue(const gxString &Name, int fn)
// Search for string matching the "Name" variable. Will search
// using the full name unless the "fn" variable is false.
{
  gxConfigListNode *ptr;

  if(fn)
    ptr = Find(Name);
  else
    ptr = FindAny(Name);


  if(ptr) {
    gxString *s = (gxString *)ptr->next->data;
    if(s) return atol(s->c_str());
  }

  //Return NULL if config value is not found
  return 0;
}

long gxConfig::GetLongValue(char *Name, int fn)
{
  gxString buf(Name);
  return GetLongValue(buf, fn);
}

long gxConfig::GetLongValue(const char *Name, int fn)
{
  gxString buf(Name);
  return GetLongValue(buf, fn);
}

int gxConfig::WriteConfigLine(const gxString &parm, const gxString &value)
// Write a line to the config file.  NOTE: All parameter values should
// not contain a parameter ID label at the end of the string. The 
// parameter ID label will be added to mark it as a config file parameter.
// By default an equal sign will be used as a parameter ID.
{
  ofstream outfile(FileName.c_str(), ios::app);

  if(!outfile) {
    outfile.close();
    return 0;
  }

  outfile << parm << parm_ID.c_str() << value << endl;
  outfile.close();
  return 1;
}  

int gxConfig::WriteConfigLine(const char *parm, const char *value)
{
  gxString p(parm); gxString v(value);
  return WriteConfigLine(p, v);
}

int gxConfig::WriteConfigLine(char *parm, char *value)
{
  gxString p(parm); gxString v(value);
  return WriteConfigLine(p, v);
}

int gxConfig::WriteCommentLine(const gxString &s)
// Write a comment line to the config file.  NOTE: Do not include the
// comment ID character. The comment ID will by automatically inserted.
{
  ofstream outfile(FileName.c_str(), ios::app);

  if(!outfile) {
    outfile.close();
    return 0;
  }

  outfile << comment_char << ' ' << s.c_str() << endl;
  outfile.close();
  return 1;
}  

int gxConfig::WriteCommentLine(const char *s)
{
  gxString cm(s);
  return WriteCommentLine(cm);
}

int gxConfig::WriteCommentLine(char *s)
{
  gxString cm(s);
  return WriteCommentLine(cm);
}

int gxConfig::WriteLine(const gxString &s)
// Write a line of text to the config file.  
{
  ofstream outfile(FileName.c_str(), ios::app);

  if(!outfile) {
    outfile.close();
    return 0;
  }

  outfile << s.c_str() << endl;
  outfile.close();
  return 1;
}  

int gxConfig::WriteLine(const char *s)
{
  gxString line(s);
  return WriteLine(line);
}

int gxConfig::WriteLine(char *s)
{
  gxString line(s);
  return WriteLine(line);
}

int gxConfig::ChangeConfigLine(const gxString &string_to_replace,
			       const gxString &string_to_insert,
			       int check_case, int append_lines)
// This function is used to replace strings in the config file.
// Returns the number of strings processed or zero if an error occurs.
{
  const int MAX_LINE = 1024;   // Maximum characters per line
  char LineBuffer[MAX_LINE];
  char rawLineBuffer[MAX_LINE];
  gxString LineData;
  gxString appendLineBuffer;
  gxConfig list;
  int i, j;
  unsigned offset = 0;
  unsigned long line_number = 0;
  int num_processed = 0;      
  
#if defined (__WIN32__) || defined (__DOS__) 
  // In MS-DOS there are two file types, text and binary
#ifdef __BCC32__
  // The BCC 32 ios class does not have an enumeration for "nocreate"
  fstream iofile(FileName.c_str(), ios::in|ios::binary);
#else
  fstream iofile(FileName.c_str(), ios::in|ios::nocreate|ios::binary);
#endif
  
#elif defined (__UNIX__) 
  // In UNIX there is only one file type
  fstream iofile(FileName.c_str(), ios::in|ios::nocreate);
#else
#error "You must define a file system type: __WIN32__ __UNIX__ or __DOS__"
#endif

  if(!iofile) return 0;
	
  while(!iofile.eof()) { // Read in the file line by line

    // Clear the buffers
    for(i = 0; i < MAX_LINE; i++) LineBuffer[i] = '\0';
    for(i = 0; i < MAX_LINE; i++) rawLineBuffer[i] = '\0';
    LineData.DeleteAt(0, LineData.length());
    offset = 0; // Reset string offset
    
    iofile.getline(rawLineBuffer, MAX_LINE);
    line_number++;
        
    // Filter each line of text
    for(i = 0, j = 0; i < MAX_LINE; i++) {
      if((rawLineBuffer[i] == '\r') || (rawLineBuffer[i] == '\n')) break;
      LineBuffer[j++] = rawLineBuffer[i];
    }

    // Detect backslashes used to mark the continuation of a line
    if((LineBuffer[strlen(LineBuffer)-1] == '\\') && (append_lines == 1)) {
      appendLineBuffer += LineBuffer;
      appendLineBuffer += '\n'; // Insert LF after the backslash 
      continue;  // Goto the top of loop and append next line
    }
    if(appendLineBuffer.length() > 0) { // Append the next line
      appendLineBuffer += LineBuffer;
      LineData = appendLineBuffer;
      appendLineBuffer.DeleteAt(0, appendLineBuffer.length());
    }
    else
      LineData = LineBuffer;
    
    // Get rid of EOF marker
    if((strcmp(LineData.c_str(), "\0") == 0) && (iofile.eof())) break;

    // Routine to replace a line
    // ----------------------------------------------------------- 
    if(check_case) { // Find entire match checking the case of the string
      offset = LineData.Find((char *)string_to_replace.c_str(),
			     string_to_replace.length(), 0);
    }
    else {
      offset = LineData.IFind((char *)string_to_replace.c_str(),
			      string_to_replace.length(), 0);
    }

    if(offset == -1) { // The configurable parameter was not found
      list.Add(LineData); // Store the line and continue
      continue;
    }
    
    unsigned parm_id_offset = LineData.Find(parm_ID.c_str());
    if(parm_id_offset == -1) { // This is not a configurable parameter
      list.Add(LineData); // Store the line and continue
      continue;
    }
    
    offset += string_to_replace.length();

    // Ensure the complete string is matched before modifing the parameter
    if((LineData[offset] == ' ') || 
       (LineData[offset] == parm_ID[0])) {
      LineData.DeleteAt(offset, (LineData.length() - offset));
      LineData.InsertAt(offset, parm_ID.c_str()); // Insert parameter ID string
      LineData.InsertAt(++offset, string_to_insert);
      num_processed++;    // Record number of string processed for this file
    }
    list.Add(LineData); // Store all the lines and continue
  }
  
  // If any strings were replaced in the file, rewrite the file
  // ----------------------------------------------------------- 
  if(num_processed > 0) {
    char *EndOfLineSequence;
    iofile.close(); 
#if defined (__WIN32__) || defined(__DOS__)
    // In DOS/Windows there are two file types, text and binary
    fstream iofile(FileName.c_str(), ios::out|ios::trunc|ios::binary);
    EndOfLineSequence = "\r\n"; 
#else 
    // In UNIX there is only one file type
    fstream iofile(FileName.c_str(), ios::out|ios::in|ios::trunc);
    EndOfLineSequence = "\n"; 
#endif
    
    if(!iofile) return 0;

    gxConfigListNode *list_ptr = (gxConfigListNode *)list.GetHead();
    while(list_ptr) {
      if(list_ptr->data) {
	iofile.write(list_ptr->node_data.c_str(),
		     list_ptr->node_data.length());
	iofile.write(EndOfLineSequence, strlen(EndOfLineSequence));
      }
      list_ptr = (gxConfigListNode *)list_ptr->next; 
    }

    iofile.close();

    // Make the changes to the config list in already in memory
    ReLoad();
  }
  else
    iofile.close();
  
  list.ClearList();
  return num_processed;
}

int gxConfig::ChangeConfigValue(const gxString &parm, const gxString &value)
// Modify the config file. NOTE: All parameter values should not contain 
// a parameter ID label at the end of the string. The parameter ID label
// will be added to mark it as a config file parameter. By default an
// equal sign will be used as a parameter ID.
{
  int rv = ChangeConfigLine(parm, value, 1, 1);

  // Write the parameter if it does not exist
  if(!rv) return WriteConfigLine(parm, value);

  return rv;
}

int gxConfig::ChangeConfigValue(const char *parm, const gxString &value)
{
  gxString p(parm); gxString v(value);
  return ChangeConfigValue(p, v);
}

int gxConfig::ChangeConfigValue(const gxString &parm, const char *value)
{
  gxString p(parm); gxString v(value);
  return ChangeConfigValue(p, v);
}

int gxConfig::ChangeConfigValue(char *parm, const gxString &value)
{
  gxString p(parm); gxString v(value);
  return ChangeConfigValue(p, v);
}

int gxConfig::ChangeConfigValue(const gxString &parm, char *value)
{
  gxString p(parm); gxString v(value);
  return ChangeConfigValue(p, v);
}

int gxConfig::ChangeConfigValue(const char *parm, const char *value)
{
  gxString p(parm); gxString v(value);
  return ChangeConfigValue(p, v);
}

int gxConfig::ChangeConfigValue(char *parm, char *value)
{
  gxString p(parm); gxString v(value);
  return ChangeConfigValue(p, v);
}

int gxConfig::ChangeConfigValue(const gxString &parm, int value)
{
  char buf[255];
  sprintf(buf, "%d", value);
  gxString val(buf);
  return ChangeConfigValue(parm, val);
}

int gxConfig::ChangeConfigValue(const char *parm, int value)
{
  gxString p(parm);
  return ChangeConfigValue(p, value);
}

int gxConfig::ChangeConfigValue(char *parm, int value)
{
  gxString p(parm);
  return ChangeConfigValue(p, value);
}

int gxConfig::ChangeConfigValue(const gxString &parm, unsigned value)
{
  char buf[255];
  sprintf(buf, "%u", value);
  gxString val(buf);
  return ChangeConfigValue(parm, val);
}

int gxConfig::ChangeConfigValue(const char *parm, unsigned value)
{
  gxString p(parm);
  return ChangeConfigValue(p, value);
}

int gxConfig::ChangeConfigValue(char *parm, unsigned value)
{
  gxString p(parm);
  return ChangeConfigValue(p, value);
}

int gxConfig::ChangeConfigValue(const gxString &parm, long value)
{
  char buf[255];
  sprintf(buf, "%d", value);
  gxString val(buf);
  return ChangeConfigValue(parm, val);
}

int gxConfig::ChangeConfigValue(const char *parm, long value)
{
  gxString p(parm);
  return ChangeConfigValue(p, value);
}

int gxConfig::ChangeConfigValue(char *parm, long value)
{
  gxString p(parm);
  return ChangeConfigValue(p, value);
}

int gxConfig::ChangeConfigValue(const gxString &parm, float value)
{
  char buf[255];
  sprintf(buf, "%g", value);
  gxString val(buf);
  return ChangeConfigValue(parm, val);
}

int gxConfig::ChangeConfigValue(const char *parm, float value)
{
  gxString p(parm);
  return ChangeConfigValue(p, value);
}
  
int gxConfig::ChangeConfigValue(char *parm, float value)
{
  gxString p(parm);
  return ChangeConfigValue(p, value);
}

int gxConfig::ChangeConfigValue(const gxString &parm, double value)
{
  char buf[255];
  sprintf(buf, "%g", value);
  gxString val(buf);
  return ChangeConfigValue(parm, val);
}

int gxConfig::ChangeConfigValue(const char *parm, double value)
{
  gxString p(parm);
  return ChangeConfigValue(p, value);
}

int gxConfig::ChangeConfigValue(char *parm, double value)
{
  gxString p(parm);
  return ChangeConfigValue(p, value);
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
