// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Source Code File Name: testprog.cpp 
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 11/17/1995
// Date Last Modified: 05/25/2001
// ----------------------------------------------------------- // 
// ------------- Program description and details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This is a test program for the LogFile and ProgramLog classes.
*/
// ----------------------------------------------------------- //   
#include <iostream.h>
#include "logfile.h"

#ifdef __MSVC_DEBUG__
#include "leaktest.h"
#endif

static LogFile *SysLog;

int main()
{
#ifdef __MSVC_DEBUG__
  InitLeakTest();
#endif

  SysLog = new LogFile;
  char *fname = "logfile.log";
  
  cout << "Writing to logfile.log" << endl;
  if(SysLog->OverWrite(fname) != 0) {
    cout << "Could not write to log file" << endl;
    return 0;
  }
  *(SysLog) << "Writing to log file.";
  SysLog->WriteSysTime();
  *(SysLog) << endl;

  SysLog->Flush();
  
  cout << "Appending 10 entries to logfile.log" << endl;
  for(int i = 0; i < 10; i++) {
    *(SysLog) << "Appending to log file [" << i << "]" << endl;
  }
  
  cout << "Appending two strings to logfile" << endl;
  *(SysLog) << "Appending string " << 1 << " and " << 2 << endl;
  
  cout << "Appending three strings to logfile" << endl;
  *(SysLog) << "Appending string " << 1.5 << ' ' << 2.5 << " and " << 3.5
	    << endl;
  
  delete SysLog;
  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
