// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 03/25/2000
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or 
modify it under the terms of the GNU Lesser General Public 
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version. 
  
This library is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
USA
 
Test program demonstrating the basic operation of the gxThread
class using mutex and condition variable synchronization 
primitives.
*/
// ----------------------------------------------------------- //   
#include <iostream.h>
#include "gxthread.h"
#include "gxmutex.h"
#include "gxcond.h"

#ifdef __MSVC_DEBUG__
#include "leaktest.h"
#endif

// Constants
const int NUMTHREADS = 2;

// Global synchronization objects
gxMutex dataMutex;
gxCondition dataPresentCondition;

// Global variables
int dataPresent = 0;
int sharedData = 0;
 
class ConsumerThread : public gxThread
{
private: // Base class interface
  void *ThreadEntryRoutine(gxThread_t *thread);
};

void *ConsumerThread::ThreadEntryRoutine(gxThread_t *thread)
// Thread's entry function
{
  int retries = 1;
 
  cout << "Entering consumer thread" << endl;
  if(dataMutex.MutexLock() != 0) {
    cout << "Consumer thread mutex lock failed!" << endl;
    cout << dataMutex.MutexExceptionMessage() << endl;
    return ExitThread(thread, 1);
  }
  
  while(retries--) {
    // The boolean dataPresent value is required for safe use of
    // condition variables. If no data is present we wait, other 
    // wise we process immediately.
    while(!dataPresent) {
      cout << "Consumer thread waiting for data to be produced" << endl;
      if(dataPresentCondition.ConditionWait(&dataMutex) != 0) {
	cout << "Consumer thread condition wait failed!" << endl;
	cout << dataPresentCondition.ConditionExceptionMessage() << endl;
	dataMutex.MutexUnlock();
	return ExitThread(thread, 1);
      }
    }

    cout << "Consumer thread found data or notified" << endl;
    cout << "CONSUME DATA while holding lock" << endl;

    // Typically an application should remove the data from being 
    // in the shared structure or Queue, then unlock. Processing 
    // of the data does not necessarily require that the lock is held
    // Access to shared data goes here
    --sharedData;
      
    // We consumed the last of the data 
    if(sharedData == 0) dataPresent = 0;

    // Repeat holding the lock.
    // The gxCondition::ConditionWait() function releases it atomically 
  }

  cout << "Consumer thread done" << endl;

  if(dataMutex.MutexUnlock() != 0) {
    cout << "Consumer thread mutex unlock failed!" << endl;
    cout << dataMutex.MutexExceptionMessage() << endl;
    return ExitThread(thread, 1);
  }

  return 0;
}
  
// Program's main thread of execution
int main()
{
#ifdef __MSVC_DEBUG__
  InitLeakTest();
#endif

  ConsumerThread t;
  gxThread_t *thread[NUMTHREADS];

  int amountOfData = 4;
  int i;
 
  cout << "Create/start threads" << endl;
  for(i = 0; i < NUMTHREADS; ++i) {
    thread[i] = t.CreateThread();
    if(thread[i]->GetThreadError() != gxTHREAD_NO_ERROR)
      cout << thread[i]->ThreadExceptionMessage() << endl;
   }
 
  // The producer loop 
  while(amountOfData--) {
    cout << "Producer finding data..." << endl;
    t.sSleep(1);
    
    if(dataMutex.MutexLock() != 0) { // Protect shared data and flag
      cout << "Producer thread mutex lock failed!" << endl;
      cout << dataMutex.MutexExceptionMessage() << endl;
    }
    
    cout << "Producer thread make data shared and notify consumer" << endl;
    ++sharedData;    // Add data
    dataPresent = 1; // Set boolean predicate
    
    // Wake up a consumer
    if(dataPresentCondition.ConditionSignal() != 0) {
      cout << "Producer thread condition signal failed!" << endl;
      cout << dataPresentCondition.ConditionExceptionMessage() << endl;
      dataMutex.MutexUnlock();
      return 1;
    }
 
    cout << "Producer thread unlock shared data and flag" << endl;
    if(dataMutex.MutexUnlock() != 0) {
      cout << "Producer thread mutex unlock failed!" << endl;
      cout << dataMutex.MutexExceptionMessage() << endl;
    }
  }
 
  cout << "Wait for the threads to complete, and release their resources"
       << endl;

  for(i = 0; i < NUMTHREADS; i++) {
    if(t.JoinThread(thread[i]) != 0)
      cout << "Could not join the thread" << endl;
    if(thread[i]->GetThreadExitCode() != 0)
      cout << "This thread exited with an error" << endl;
  }

  // Release any memory the thread is still holding
  for(i = 0; i < NUMTHREADS; i++) {
    if(t.DestroyThread(thread[i]) != 0) {
      cout << "Error destroying thread!" << endl;
    }
  }
  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
