// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 01/25/2000
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This program is used to test gxsURL classes. 
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include "gxsurl.h"
#include "gxs_ver.h"

#ifdef __MSVC_DEBUG__
#include "leaktest.h"
#endif

// Version number and program name
const double ProgramVersionNumber = gxSocketVersion;
const char *ProgramName = "gxsURL test program";

// Author information
const char *ProducedBy = "Doug Gaer";
const char *EmailAddress = "dgaer@email.com";

// Program globals
int parsing_url = 0;

void PrintURLInfo(gxsURLInfo &u)
{
  cout << "Uniform resource locator infomation" << endl;
  cout << "-------------------------------------------------------" << endl;
  cout << "Unchanged URL = " << u.url << endl; 
  cout << "URL protocol = " << u.proto << endl; 
  cout << "Extracted hostname = " << u.host << endl;
  cout << "Port number = " << u.port << endl;
  cout << "FTP type = " << u.ftp_type << endl;
  cout << "Path = " << u.path << endl;
  cout << "Directory = " << u.dir << endl;
  cout << "File = " << u.file << endl;
  cout << "Username = " << u.user << endl;
  cout << "Password = " << u.passwd << endl; 
  cout << "Local filename of the URL document = " << u.local << endl;
  cout << "Source that requested URI was obtained = " << u.referer << endl;

  if(u.proxy) { // The exact string to pass to proxy server
    cout << endl;
    cout << "Proxy server infomation" << endl;
    cout << "-------------------------------------------------------" << endl;
    cout << "Unchanged URL = " << u.proxy->url << endl; 
    cout << "URL protocol = " << u.proxy->proto << endl; 
    cout << "Extracted hostname = " << u.proxy->host << endl;
    cout << "Port number = " << u.proxy->port << endl;
    cout << "FTP type = " << u.proxy->ftp_type << endl;
    cout << "Path = " << u.proxy->path << endl;
    cout << "Directory = " << u.proxy->dir << endl;
    cout << "File = " << u.proxy->file << endl;
    cout << "Username = " << u.proxy->user << endl;
    cout << "Password = " << u.proxy->passwd << endl; 
    cout << "Local filename of the URL document = " << u.proxy->local << endl;
    cout << "Source that requested URI was obtained = "
	 << u.proxy->referer << endl;
  }
  cout << endl;
}

void ListSupportedProtocols()
{
  gxsURL url;
  for(unsigned i = 0; i < gxsMAX_PROTOCOL_STRINGS; i++) {
    cout << url.GetProtocolString(i) << "//" << " Port Number - ";
    gxString u(url.GetProtocolString(i)); u += "//";
    int port; url.GetPortNumber(u, port);
    cout << port << endl;
  }
}

void ParseURL(const char *URL)
{
  gxsURLInfo u;
  gxsURL gxsurl;
  if(!gxsurl.ParseURL(URL, u)) {
    cout << "Error parsing URL" << endl;
    return;
  }
			       
  PrintURLInfo(u);  
}

void HelpMessage(const char *program_name, const double version_number)
{
  cout << endl;
  cout.setf(ios::showpoint | ios::fixed);
  cout.precision(3);
  cout << endl;
  cout << program_name << " version " << version_number  << endl;
  cout << "Produced by: " << ProducedBy << ' ' << EmailAddress << endl;
  cout << endl;
  cout << "Usage: " << program_name << " [switches] URL" << endl;
  cout << "Example: " << program_name << " -p http://www.xyz.com/index.html" << endl;
  cout << "Switches: " << endl;
  cout << "          -L = List all the protocols supported by this program." 
       << endl;
  cout << "          -p = Parse the specifed URL" << endl;
  cout << endl;
  return;
}

int ProcessArgs(char *arg)
{
  switch(arg[1]) {
    case 'L' :
      ListSupportedProtocols();
      return 0;

    case 'p' :
      parsing_url = 1;
      break;

    default:
      cerr << endl;
      cerr << "Unknown switch " << arg << endl;
      cerr << "Exiting..." << endl;
      cerr << endl;
      return 0;
  }
  arg[0] = '\0';
  return 1; // All command line arguments were valid
}

int main(int argc, char **argv)
{
#ifdef __MSVC_DEBUG__
  InitLeakTest();
#endif

  if(argc < 2) { 
    HelpMessage(ProgramName, ProgramVersionNumber);
    return 0;
  }
  
  // Process command ling arguments and files 
  int narg;
  char *arg = argv[narg = 1];

  while (narg < argc) {
    if(arg[0] != '\0') {
      if(arg[0] == '-') { // Look for command line arguments
	if(!ProcessArgs(arg)) return 0; // Exit if argument is not valid
      }
      else { 
	if(parsing_url) {
	  ParseURL((const char *)arg);
	}
      }
      arg = argv[++narg];
    }
  }

  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
