// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Header File Name: gxsftp.h
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 02/23/2001
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

File Transfer Protocol (FTP) classes used with applications
that require use of embedded FTP client/server functions.
*/
// ----------------------------------------------------------- // 
#ifndef __GX_EMBEDDED_FTP_LIB_HPP__
#define __GX_EMBEDDED_FTP_LIB_HPP__

#include <fstream.h>
#include "gxsocket.h"

// FTP client - See RFC 959 for specifications
class gxsFTPClient : public gxSocket
{
public:
  gxsFTPClient() { 
    time_out_sec = 5; // Default blocking timeout value   
    time_out_usec = 0;
    reply_buf[0] = 0; 
    command_buf[0] = 0;
    ftp_data_port = 0;
  }
  ~gxsFTPClient() { }

public:
  gxSocketError ConnectClient(const char *host, int port = gxSOCKET_FTP_PORT);
  gxSocketError SendCommand(const char *command, const char *response, 
			     const char *args = 0);
  gxSocketError FTPLogin(const char *username, const char *password);
  gxSocketError FTPLogout();
  gxSocketError FTPImageType(char type = 'I');
  gxSocketError FTPList(char *sbuf, unsigned bytes, int full = 1,
			 const char *args = 0);
  gxSocketError FTPChDir(const char *dname);
  gxSocketError FTPMkDir(const char *dname);
  gxSocketError FTPRmDir(const char *dname);
  gxSocketError FTPPWD();
  gxSocketError FTPStat();
  gxSocketError FTPSize(const char *fname);
  gxSocketError FTPDelete(const char *fname);
  gxSocketError FTPMove(const char *from, const char *to);
  gxSocketError FTPGet(const char *fname, fstream &stream, unsigned &bytes);
  gxSocketError FTPPut(const char *fname, fstream &stream, unsigned &bytes);
  gxSocketError OpenDataPort();
  int ReadDataPort(void *buf, unsigned bytes);
  int WriteDataPort(void *buf, unsigned bytes);
  void CloseDataPort();
  int RecvResponse(char *buf, int bytes, const char *response);
  int RecvResponse(gxsSocket_t s, char *buf, int bytes, const char *response);
  int WaitForReply(gxsSocket_t s);
  void SetTimeOut(int seconds, int useconds) {
    time_out_sec = seconds;
    time_out_usec = useconds;
  }

public:
  gxSocket ftp_data;             // Socket used to transfer data to this client
  int ftp_data_port;             // FTP data port client is listening on
  char reply_buf[gxsBUF_SIZE];   // Buffer used to hold the last reply
  char command_buf[gxsBUF_SIZE]; // Buffer used to hold the last command
  int time_out_sec;  // Number of seconds before a blocking timeout
  int time_out_usec; // Number of microseconds before a blocking timeout
};

#endif // __GX_EMBEDDED_FTP_LIB_HPP__
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
