// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: gxshttp.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 01/25/2000
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

HTTP client class.
*/
// ----------------------------------------------------------- // 
#include <stdio.h>
#include <stdlib.h>
#include "gxshttp.h"
#include "gxshttpc.h"
#include "gxs_b64.h"

#ifdef __wxWIN201__
#include "wx2incs.h"  // Include files for wxWindows version 2.2.0
#endif

gxsHTTPClient::gxsHTTPClient(int CacheSize) : cache(CacheSize) 
{
  // Default client header settings
  HTTP_VERSION_STRING = "HTTP/1.0\r\n";
  HTTP_AGENT_STRING = "User-Agent: gxsHTTPLibrary/4000.101\r\n";
  HTTP_ACCEPT_STRING = "Accept: */*\r\n";
  HTTP_PRAGMA_STRING = "Pragma: no-cache\r\n";
  HTTP_DEFAULT_FILE_REQUEST_STRING = " /";
  HTTP_COOKIE_STRING = HTTP_REFERER_STRING = HTTP_IF_MOD_STRING = "\0";
 
  // Default device settings
  ready_for_writing = 1; 
  ready_for_reading = 1;
  cache.Connect(this); 
  write_error = read_error = 0;
}

gxsHTTPClient::~gxsHTTPClient() 
{ 

}

char *gxsHTTPClient::GetMethod(int method)
{
  return (char *)gxsHTTPMethodMessage(method);
}

int gxsHTTPClient::ConnectClient(const char *host, int port)
{
  if(InitSocketLibrary() == 0) {
    if(InitSocket(SOCK_STREAM, port, (char *)host) < 0) return socket_error;
  }
  else {
    return socket_error;
  }

  if(Connect() < 0) return socket_error;

  return socket_error = gxSOCKET_NO_ERROR;
}
 
int gxsHTTPClient::SimpleRequest(const gxsURLInfo &u, fstream *stream)
// Request a document with no header information. Returns 0 if no
// errors occur.
{
  file_ptr = stream;
  write_error = read_error = 0;
  bytes_received = 0;

  if(ConnectClient(u.host.c_str(), u.port) != 0) return socket_error;

  // Request the specified file from the server
  gxString request;
  BuildSimpleRequestString(u, gxsHTTP_GET, request);
  if(Send(request.c_str(), request.length()) < 0) return socket_error;
    
  gxDeviceTypes o_device = gxDEVICE_DISK_FILE;     // Output device
  gxDeviceTypes i_device = gxDEVICE_MEMORY_BUFFER; // Input device
  
  int nRet = 0;
  while(1) { // Read the file into the device cache
#ifdef __wxWIN201__
    ::wxYield(); // Yield to the calling process invoking the HTTP process
#endif
    // Setup a pointer to the cache buckets
    httpCachePointer p(cache, o_device, i_device); 
    
    nRet = RawRead(rxBuffer, __HTTP_PACKET_SIZE__);
    if(nRet < 0) return socket_error;
    
    bytes_received += nRet;

    // Exit if the server closed the connection
    if(nRet == 0) break;

    // Load the cache buckets
    p.Alloc(nRet);
  }

  Close();
  return socket_error = gxSOCKET_NO_ERROR;
}

int gxsHTTPClient::RequestHeader(const gxsURLInfo &u, gxsHTTPHeader &hdr)
// Request a document header passing back the header information in the
// "hdr" variable. Returns 0 if no errors occur.
{
  if(ConnectClient(u.host.c_str(), u.port) != 0) return socket_error;

  gxString request;
  BuildRequestString(u, gxsHTTP_HEAD, request);
  
  gxString header;
  int nRet = 0;

  // Request a header for the specified file
  if(Send(request.c_str(), request.length()) < 0) return socket_error;
  
  while(1) { // Read the file header into the header string
#ifdef __wxWIN201__
    ::wxYield(); // Yield to the calling process invoking the HTTP process
#endif
    
    nRet = RawRead(rxBuffer, __HTTP_PACKET_SIZE__);
    if(nRet < 0) return socket_error;

    rxBuffer[nRet] = '\0'; // Null terminate the receive buffer
    header += rxBuffer;

    // Exit if the server closed the connection
    if(nRet == 0) break;

  }

  ParseHTTPHeader(u, header, hdr);
  Close();
  return socket_error = gxSOCKET_NO_ERROR;
}

int gxsHTTPClient::RequestFile(const gxsURLInfo &u, const gxsHTTPHeader &hdr,
			       fstream *stream)
// Request a file and write it to the specified stream. This function
// assumes that the document header has already been requested and placed
// in the "hdr" variable. Returns 0 if no errors occur.
{
  file_ptr = stream;
  write_error = read_error = 0;
  bytes_received = 0;

  if(ConnectClient(u.host.c_str(), u.port) != 0) return socket_error;

  // Request the specified file from the server
  gxString request;
  BuildRequestString(u, gxsHTTP_GET, request);
  if(Send(request.c_str(), request.length()) < 0) return socket_error;
  
  gxDeviceTypes o_device = gxDEVICE_DISK_FILE;    // Output device
  gxDeviceTypes i_device = gxDEVICE_MEMORY_BUFFER; // Input device
  
  int nRet = 0;
  int byte_count;
  int found_header = 0;
  int header_length = (int)hdr.http_header.length();

  while(1) { // Read the file into the device cache
#ifdef __wxWIN201__
    ::wxYield(); // Yield to the calling process invoking the HTTP process
#endif

    // Setup a pointer to the cache buckets
    httpCachePointer p(cache, o_device, i_device); 
    
    nRet = RawRead(rxBuffer, __HTTP_PACKET_SIZE__);
    if(nRet < 0) return socket_error;
    
    // Exit if the server closed the connection
    if(nRet == 0) break;

    if(!found_header) {
      if(nRet > header_length) { // Header was returned with document's body
	byte_count = (nRet - header_length);
	bytes_received += (nRet - header_length);
	found_header = 1;
	char *s_ptr = (char *)rxBuffer;
	// Move the document body over the header information
	memmove(s_ptr, s_ptr+header_length, (nRet - header_length)); 
      }
      else if(nRet == header_length) { // The header was received by itself  
	// Ignore the header and continue
	found_header = 1;
	continue;
      }
      else { // Part of the header was received (nRet < header_length)
	header_length -= nRet;
	continue; // Continue until the entire header is received
      }
    }
    else {
      byte_count = nRet;
      bytes_received += nRet;
    }

    // Load the cache buckets
    p.Alloc(byte_count);
  }
  
  Close();
  return socket_error = gxSOCKET_NO_ERROR;
}

void gxsHTTPClient::Read(void *buf, unsigned Bytes, gxDeviceTypes dev) 
// Read a specified number of bytes and copy them to the device cache.
{
  int rv;
  switch(dev) {
    case gxDEVICE_DISK_FILE:
      if(file_ptr->eof()) { // At the end of the file
	read_error = (int)gxDEVICE_DISK_FILE;
	break;
      }

      file_ptr->read((char *)buf, Bytes);
      
      if(!file_ptr->good()) { // An I/O error occurred
	if(file_ptr->bad()) { // The I/O error was fatal
	  read_error = (int)gxDEVICE_DISK_FILE;
	}
      }
      break;
            
    case  gxDEVICE_STREAM_SOCKET:
#ifdef __wxWIN201__
    ::wxYield(); // Yield to the calling process invoking the socket read
#endif
      rv = RawRead((char *)buf, Bytes);
      if(rv < 0) read_error = (int)gxDEVICE_STREAM_SOCKET;
      break;

    case gxDEVICE_MEMORY_BUFFER:
      memmove(buf, rxBuffer, Bytes);
      break;

    default:
      break;
  }
}
  
void gxsHTTPClient::Write(const void *buf, unsigned Bytes,
			  gxDeviceTypes dev) 
// Write a specified number of bytes from the device cache to
// the output device.
{
  int rv;
  switch(dev) {
    case gxDEVICE_CONSOLE:
      cout.write((char *)buf, Bytes);
      break;

    case gxDEVICE_DISK_FILE:
      file_ptr->write((char *)buf, Bytes);
      if(!file_ptr->good()) { // An I/O error occurred
	if(file_ptr->eof()) { // End of the file error
	  write_error = (int)gxDEVICE_DISK_FILE;
	}
	if(file_ptr->bad()) { // The I/O error was fatal
	  write_error = (int)gxDEVICE_DISK_FILE;
	}
      }
      break;
      
    case  gxDEVICE_STREAM_SOCKET:
      rv = Send((char *)buf, Bytes);
      if(rv < 0) write_error =  (int)gxDEVICE_STREAM_SOCKET;
      break;

    default:
      break;
  }
}
 
int gxsHTTPClient::ParseHTTPHeader(const gxsURLInfo &u,
				   const gxString &header, gxsHTTPHeader &hdr)
// Parse an HTTP header passing back the header information in the
// "hdr" variable. Returns 0 if no errors occur.
{
  hdr.http_header = header;
  gxString dup_header(header);
  
  char status[1024], status2[1024], rest[1024];
  status[0] = status2[0] = rest[0] = 0;
  unsigned offset, index;
  gxString sbuf, ibuf;
  
  // Read the headers status line
  sscanf(dup_header.c_str(), "HTTP/%f %d %[^\r\n]", 
	 &hdr.http_version, &hdr.http_status, status);

  if (hdr.http_status == gxsHTTP_STATUS_UNAUTHORIZED) { 
    // The 401 (unauthorized) response message is used by an origin server
    // to challenge the authorization of a user agent. This response must
    // include a WWW-Authenticate header field containing at least one
    // challenge applicable to the requested resource. 
    hdr.authentication_needed = 1;
  }
  else if (hdr.http_status == gxsHTTP_STATUS_FORBIDDEN) {
    hdr.authentication_scheme = hdr.realm = hdr.auth_cookie = "\0";
  }
  else if ((hdr.http_status >= 200) && (hdr.http_status <= 299)) {
    if (hdr.http_status == gxsHTTP_STATUS_NO_CONTENT) {
      hdr.no_cache = 1;
      hdr.length = 0;
    }
  }
  else if ((hdr.http_status >= 500) && (hdr.http_status <= 599)) { 
    // Proxy error 
  }
  else {
    hdr.not_found = 1;
  }
  
  // In HTTP/1.1 connections are assumed to be persistent
  // unless otherwise notified.
  if (hdr.http_version >= 1.1F)
    hdr.keep_alive = 1;
  else
    hdr.keep_alive = 0;

  // Get the rest of the header parameters
  offset = dup_header.IFind("Server:");
  if(offset != -1) {
    sscanf(dup_header.c_str()+offset, "%*[^:]: %[^\r\n]", status);
    hdr.current_server = status;
  }
  offset = dup_header.IFind("Location:");
  if(offset != -1) {
    // The Location response-header field defines the exact location of
    // the resource that was identified by the Request-URI. For 3xx
    // responses, the location must indicate the server's preferred URL
    // for automatic redirection to the resource. Only one absolute URL is
    // allowed.
    sscanf(dup_header.c_str()+offset, "%*[^:]: %[^\r\n]", status);
    hdr.location = status;
  }
  offset = dup_header.IFind("Last-Modified:");
  if(offset != -1) {
    // The Last-Modified entity-header field indicates the date and time
    // at which the sender believes the resource was last modified.
    sscanf(dup_header.c_str()+offset, "%*[^:]: %[^\r\n]", status);
    hdr.http_last_modified = status;
  }
  offset = dup_header.IFind("Date:");
  if(offset != -1) {
    // The Date general-header field represents the date 
    // and time at which the message was originated.
    sscanf(dup_header.c_str()+offset, "%*[^:]: %[^\r\n]", status);
    hdr.date = status;
  }
  offset = dup_header.IFind("Expires:");
  if(offset != -1) {
    // The Expires entity-header field gives the date/time after which
    // the entity should be considered stale. This allows information
    // providers to suggest the volatility of the resource, or a date
    // after which the information may no longer be valid. Applications
    // must not cache this entity beyond the date given.
    sscanf(dup_header.c_str()+offset, "%*[^:]: %[^\r\n]", status);
    hdr.http_expires = status;
  }
  offset = dup_header.IFind("ETag:");
  if(offset != -1) {
    sscanf(dup_header.c_str()+offset, "%*[^:]: %[^\r\n]", status);
    hdr.etag = status;
  }
  offset = dup_header.IFind("Content-Encoding:");
  if(offset != -1) {
    // The Content-Encoding entity-header field is used as a modifier
    // to the media-type. When present, its value indicates what additional
    // content coding has been applied to the resource, and thus what
    // decoding mechanism must be applied in order to obtain the media-type
    // referenced by the Content-Type header field. The Content-Encoding is
    // primarily used to allow a document to be compressed without
    // losing the identity of its underlying media type.
    sscanf(dup_header.c_str()+offset, "%*[^:]: %[^\r\n]", status);
    hdr.content_encoding = status;
  }
  offset = dup_header.IFind("WWW-Authenticate:");
  if(offset != -1) {
    // If a request is authenticated and a realm specified, the same
    // credentials should be valid for all other requests within this
    // realm. 
    if(sscanf(dup_header.c_str()+offset, "%*[^:]: %s %[^\r\n]",
	      status, status2) == 2) {
      hdr.authentication_scheme = status;
      hdr.realm = status2;
    }
  }
  offset = dup_header.IFind("Keep-Alive:");
  if((hdr.http_version == 1.0F) && (offset != -1)) {
    if(sscanf(dup_header.c_str()+offset, "%*[^:]: timeout=%d, max=%d",
	      &hdr.timeout, &hdr.max_conns) == 2) {
      hdr.keep_alive = 1;
    }
    else if(sscanf(dup_header.c_str()+offset, "%*[^:]: max=%d, timeout=%d",
		   &hdr.max_conns, &hdr.timeout) == 2) {
      hdr.keep_alive = 1;
    }
  }
  offset = dup_header.IFind("Connection:");
  if(offset != -1) {
    sscanf(dup_header.c_str()+offset, "%*[^:]: %[^,\r\n],%[^,\r\n]",
	   status, status2);
    sbuf = status;
    offset = sbuf.IFind("keep-alive");
    if(offset != -1) hdr.keep_alive = 1;
    offset = sbuf.IFind("persist");
    if(offset != -1) hdr.keep_alive = 1;
    offset = sbuf.IFind("close");
    if(offset != -1) hdr.keep_alive = 0;

    sbuf = status2;
    offset = sbuf.IFind("keep-alive");
    if(offset != -1) hdr.keep_alive = 1;
    offset = sbuf.IFind("persist");
    if(offset != -1) hdr.keep_alive = 1;
    offset = sbuf.IFind("close");
    if(offset != -1) hdr.keep_alive = 0;
  }
  offset = dup_header.IFind("Content-Type:");
  if(offset != -1) {
    // The Content-Type entity-header field indicates the media type
    // of the Entity-Body sent to the recipient or, in the case of
    // the HEAD method, the media type that would have been sent had
    // the request been a GET. 
    sscanf(dup_header.c_str()+offset, "%*[^:]: %[^;\r\n]", status);
    char ext[256];
    sscanf(status, "%*[^/]/%[^;]", ext);
    hdr.file_extension = ".";
    hdr.file_extension += ext;

    hdr.content_type = hdr.mime_type = status;

#if defined(__DOS__) || defined(__WIN32__)
    if(hdr.mime_type == "audio/x-wav")
      hdr.file_extension = ".wav";
    else if(hdr.mime_type == "image/x-ms-bmp")
      hdr.file_extension = ".bmp";
    else if(hdr.mime_type == "application/x-msvideo")
      hdr.file_extension = ".avi";
#endif
  }
  offset = dup_header.IFind("Content-Length:");
  if(offset != -1) {
    // The Content-Length entity-header field 
    // indicates the size of the Entity-Body.
    offset += strlen("Content-Length:");
    char *src = (char *)(dup_header.c_str()+offset);
    while(*src == ' ') src++;
    hdr.length = atol(src);
  }

  offset = dup_header.IFind("Pragma:");
  if(offset != -1) {
    // The Pragma general-header field is used to include implementation-
    // specific directives that may apply to any recipient along the
    // request/response chain. All pragma directives specify optional
    // behavior from the viewpoint of the protocol; however, some systems
    // may require that behavior be consistent with the directives.
    sscanf(dup_header.c_str()+offset, "%*[^:]: %[^\r\n]", status);
    hdr.pragma = status;
    offset = hdr.pragma.IFind("no-cache");
    if(offset != -1) hdr.no_cache = 1;
  }

  offset = dup_header.IFind("Cache-Control:");
  if(offset != -1) {
    sscanf(dup_header.c_str()+offset, "%*[^:]: %[^\r\n]", status);
    hdr.cache_control = status;
    offset = hdr.cache_control.IFind("no-cache");
    if(offset != -1) hdr.no_cache = 1;
  }
  
  offset = dup_header.IFind("Accept-Ranges:");
  if(offset != -1) {
    sscanf(dup_header.c_str()+offset,"%*[^:]: %s", status);
    sbuf = status;
    if(CaseICmp(sbuf, "bytes") == 0) hdr.accept_ranges = 1;
  }

  offset = 0;
  sbuf = header;
  while(1) { // Parse all the cookies
    offset = sbuf.IFind("Set-Cookie:", offset);
    if((offset != -1) && (hdr.use_cookies)) {
      if(sscanf(dup_header.c_str()+offset, "%*[^:]: %[^=]=%[^;\r\n]; %[^\r\n]",
		status, status2, rest) >= 2) {
	gxsNetscapeCookie citem;
	citem.host = u.host;
	citem.name = status;
	citem.value = status2;
	citem.secure = 0;
	
	ibuf = rest;
	index = ibuf.IFind("Expires");
	if(index != -1) {
	  ibuf.DeleteAt(0, index);
	  ibuf.DeleteBeforeIncluding("=");
	  ibuf.DeleteAfterIncluding(";");
	  citem.expires = ibuf;
	}
	ibuf = rest;
	index = ibuf.IFind("Domain");
	if(index != -1) {
	  ibuf.DeleteAt(0, index);
	  ibuf.DeleteBeforeIncluding("=");
	  ibuf.DeleteAfterIncluding(";");
	  citem.domain = ibuf;
	}
	ibuf = rest;
	index = ibuf.IFind("Path");
	if(index != -1) {
	  ibuf.DeleteAt(0, index);
	  ibuf.DeleteBeforeIncluding("=");
	  ibuf.DeleteAfterIncluding(";");
	  citem.path = ibuf;
	}
	ibuf = rest;
	index = ibuf.IFind("Secure");
	if(index != -1) {
	  citem.secure = 1;
	}
	hdr.netscape_cookies.Insert(citem);
      }
    }
    if(offset == -1) break;
    offset++;
  }
  
  return 0;
}

void gxsHTTPClient::BuildSimpleRequestString(const gxsURLInfo &u,
					     int method, 
					     gxString &request)
// Build a simple request string.
{
  gxString filebuf;
  
  if(u.path.length() > 0) {
    filebuf = u.path;
  }
  else { // No path was specified so request a directory listing
    if(HTTP_DEFAULT_FILE_REQUEST_STRING.length() > 0)
      filebuf = HTTP_DEFAULT_FILE_REQUEST_STRING;
    else
      filebuf = " /";
  }
 
  char sbuf[1024];
  sprintf(sbuf, "%s %s//%s:%d%s\r\n",
	  GetMethod(gxsHTTP_GET),
	  url.GetProtocolString(u.proto_type),
	  u.host.c_str(), 
	  u.port,
	  filebuf.c_str());

  request = sbuf;
}

void gxsHTTPClient::BuildRequestString(const gxsURLInfo &u,
				       int method, 
				       gxString &request)
// Build a request string.
{
  char sbuf[255];
  gxString filebuf;
  unsigned offset = 0;
  
  if(u.path.length() > 0) {
    filebuf = u.path;
  }
  else { // No path was specified so request a directory listing
    if(HTTP_DEFAULT_FILE_REQUEST_STRING.length() > 0)
      filebuf = HTTP_DEFAULT_FILE_REQUEST_STRING;
    else
      filebuf = " /";
  }
  
  gxString wwwauth;
  if(u.user.length() > 0 && u.passwd.length() > 0) {
    gxsBasicAuthenticationEncode(u.user.c_str(), u.passwd.c_str(),
				 "Authorization", wwwauth);
  }
						    
  request = GetMethod(method);
  request += " ";
  request += filebuf;
  request += ' ';
  if(HTTP_VERSION_STRING.length() > 0) {
    offset = HTTP_VERSION_STRING.IFind("\r\n");
    if(offset == -1) HTTP_VERSION_STRING += "\r\n";
    request += HTTP_VERSION_STRING;
  }
  else {
    request += "HTTP/1.0\r\n";
  }
  if(HTTP_AGENT_STRING.length() > 0) {
    offset = HTTP_AGENT_STRING.IFind("\r\n");
    if(offset == -1) HTTP_AGENT_STRING += "\r\n";
    request += HTTP_AGENT_STRING;
  }
  else {
    request += "User-Agent: gxsHTTPLibrary\r\n";
  }
  request += "Host: ";
  request += u.host;
  sprintf(sbuf, "%d", u.port);
  request += ":";
  request += sbuf;
  request += "\r\n";
  if(HTTP_ACCEPT_STRING.length() > 0) {
    offset = HTTP_ACCEPT_STRING.IFind("\r\n");
    if(offset == -1) HTTP_ACCEPT_STRING += "\r\n";
    request += HTTP_ACCEPT_STRING;
  }
  if(HTTP_REFERER_STRING.length() > 0) {
    offset = HTTP_REFERER_STRING.IFind("\r\n");
    if(offset == -1) HTTP_REFERER_STRING += "\r\n";
    request += HTTP_REFERER_STRING;
  }
  if(wwwauth.length() > 0) {
    offset = wwwauth.IFind("\r\n");
    if(offset == -1) wwwauth += "\r\n";
    request += wwwauth;
  }
  if(HTTP_PRAGMA_STRING.length() > 0) {
    offset = HTTP_PRAGMA_STRING.IFind("\r\n");
    if(offset == -1) HTTP_PRAGMA_STRING += "\r\n";
    request += HTTP_PRAGMA_STRING;
  }
  if(HTTP_IF_MOD_STRING.length() > 0) {
    offset = HTTP_IF_MOD_STRING.IFind("\r\n");
    if(offset == -1) HTTP_IF_MOD_STRING += "\r\n";
    request += HTTP_IF_MOD_STRING;
  }
  if(HTTP_COOKIE_STRING.length() > 0) {
    offset = HTTP_COOKIE_STRING.IFind("\r\n");
    if(offset == -1) HTTP_COOKIE_STRING += "\r\n";
    request += HTTP_COOKIE_STRING;
  }
  // End of request
  request += "\r\n";
}

int gxsHTTPClient::SimpleRequest(const gxsURLInfo &u, MemoryBuffer &mbuf)
// Request a document with no header information and write it to a
// memory buffer. Returns 0 if no errors occur.
{
  bytes_received = 0;

  if(ConnectClient(u.host.c_str(), u.port) != 0) return socket_error;

  // Request the specified file from the server
  gxString request;
  BuildSimpleRequestString(u, gxsHTTP_GET, request);
  if(Send(request.c_str(), request.length()) < 0) return socket_error;

  // Clear the memory buffer
  mbuf.Clear();

  int nRet = 0;
  while(1) { // Read the file into the device cache
#ifdef __wxWIN201__
    ::wxYield(); // Yield to the calling process invoking the HTTP process
#endif

    nRet = RawRead(rxBuffer, __HTTP_PACKET_SIZE__);
    if(nRet < 0) return socket_error;
    
    bytes_received += nRet;

    // Exit if the server closed the connection
    if(nRet == 0) break;
    
    // Copy the file to a memory buffer
    mbuf.Cat((char *)rxBuffer, (unsigned)nRet);
  }

  Close();
  return socket_error = gxSOCKET_NO_ERROR;
}

int gxsHTTPClient::RequestFile(const gxsURLInfo &u, const gxsHTTPHeader &hdr,
			       MemoryBuffer &mbuf)
// Request a file and write it to a memory buffer. This function assumes that
// the document header has already been requested and placed in the "hdr"
// variable. Returns 0 if no errors occur.
{
  bytes_received = 0;

  if(ConnectClient(u.host.c_str(), u.port) != 0) return socket_error;

  // Request the specified file from the server
  gxString request;
  BuildRequestString(u, gxsHTTP_GET, request);
  if(Send(request.c_str(), request.length()) < 0) return socket_error;
  
  int nRet = 0;
  int byte_count;
  int found_header = 0;
  int header_length = (int)hdr.http_header.length();

  // Clear the memory buffer
  mbuf.Clear();

  while(1) { // Read the file into the device cache
#ifdef __wxWIN201__
    ::wxYield(); // Yield to the calling process invoking the HTTP process
#endif

    nRet = RawRead(rxBuffer, __HTTP_PACKET_SIZE__);
    if(nRet < 0) return socket_error;
    
    // Exit if the server closed the connection
    if(nRet == 0) break;

    if(!found_header) {
      if(nRet > header_length) { // Header was returned with document's body
	byte_count = (nRet - header_length);
	bytes_received += (nRet - header_length);
	found_header = 1;
	char *s_ptr = (char *)rxBuffer;
	// Move the document body over the header information
	memmove(s_ptr, s_ptr+header_length, (nRet - header_length)); 
      }
      else if(nRet == header_length) { // The header was received by itself  
	// Ignore the header and continue
	found_header = 1;
	continue;
      }
      else { // Part of the header was received (nRet < header_length)
	header_length -= nRet;
	continue; // Continue until the entire header is received
      }
    }
    else {
      byte_count = nRet;
      bytes_received += nRet;
    }

    // Copy the file to a memory buffer
    mbuf.Cat((char *)rxBuffer, byte_count);
  }
  
  Close();
  return socket_error = gxSOCKET_NO_ERROR;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
