unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  RTCalcExpress, Spin, StdCtrls, ExtCtrls, Math;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Memo1: TMemo;
    Splitter1: TSplitter;
    Panel1: TPanel;
    Label1: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label2: TLabel;
    Label5: TLabel;
    Edit2: TEdit;
    ComboBox1: TComboBox;
    Button1: TButton;
    SpinEdit1: TSpinEdit;
    SpinEdit4: TSpinEdit;
    ComboBox2: TComboBox;
    RTCalcExpress1: TRTCalcExpress;
    procedure RTCalcExpress1CalcFunction(s_name: String; n_kolarg: Integer;
      is_check: Boolean; var n_arg1, code_err: Integer;
      var s_rslt: String);
    procedure RTCalcExpress1ErrorFunction(t_lang: TtLang; s_title: String;
      code_err: Integer);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.RTCalcExpress1CalcFunction(s_name: String;
  n_kolarg: Integer; is_check: Boolean; var n_arg1, code_err: Integer;
  var s_rslt: String);
begin
 with RTCalcExpress1 do begin
  if AnsiUpperCase(s_name) = 'DATE' then begin
   if is_check then begin
    s_rslt := '1'; exit;
   end;
   if n_kolarg > 0 then begin
    code_err := 201;
    exit;
   end;
   s_rslt := FloatToStr(Date);
  end
//-------------------------------
  else if AnsiUpperCase(s_name) = 'STRADD' then begin
   if is_check then begin
    s_rslt := '1'; exit;
   end;
    if n_kolarg <> 2 then begin
     code_err := 201;
     exit;
    end;
    if tt_arglist[0][1] = #39 then tt_arglist[0] := StrFilter(tt_arglist[0], 39)
    else if not CheckIsAlpha(tt_arglist[0]) then begin
     code_err := 202;
     exit;
    end;
    if tt_arglist[1][1] = #39 then tt_arglist[1] := StrFilter(tt_arglist[1], 39)
    else if not CheckIsAlpha(tt_arglist[1]) then begin
     code_err := 202;
     exit;
    end;
    s_rslt := tt_arglist[0] + tt_arglist[1];
  end
//-----------------------------------
  else if AnsiUpperCase(s_name) = 'STREQUAL' then begin
   if is_check then begin
    s_rslt := '1'; exit;
   end;
   if n_kolarg <> 2 then begin
    code_err := 201;
    exit;
   end;
   if tt_arglist[0][1] = #39 then tt_arglist[0] := StrFilter(tt_arglist[0], 39)
   else if not CheckIsAlpha(tt_arglist[0]) then begin
    code_err := 202;
    exit;
   end;
   if tt_arglist[1][1] = #39 then tt_arglist[1] := StrFilter(tt_arglist[1], 39)
   else if not CheckIsAlpha(tt_arglist[1]) then begin
    code_err := 202;
    exit;
   end;
   if AnsiCompareText(tt_arglist[0], tt_arglist[1]) = 0 then s_rslt := '1'
   else s_rslt := '0';
  end
//-----------------------------------
  else if AnsiUpperCase(s_name) = 'ROUND' then begin
   if is_check then begin
    s_rslt := '1'; exit;
   end;
   if n_kolarg <> 1 then begin
    code_err := 201;
    exit;
   end;
   if not CheckIsNumeric(tt_arglist[0]) then begin
    code_err := 204;
    exit;
   end;
   s_rslt := FloatToStr(Round(StrToFloat(tt_arglist[0]) * 100) / 100);
  end
//-------------------------------------
  else if AnsiUpperCase(s_name) = 'MAX' then begin
   if is_check then begin
    s_rslt := '1'; exit;
   end;
   if n_kolarg <> 2 then begin
    code_err := 201;
    exit;
   end;
   if not CheckIsNumeric(tt_arglist[0]) then begin
    code_err := 204;
    exit;
   end;
   if not CheckIsNumeric(tt_arglist[1]) then begin
    code_err := 204;
    exit;
   end;
   s_rslt := FloatToStr(Max(StrToFloat(tt_arglist[0]), StrToFloat(tt_arglist[1])));
  end
//-----------------------------------
  else if AnsiUpperCase(s_name) = 'MIN' then begin
   if is_check then begin
    s_rslt := '1'; exit;
   end;
   if n_kolarg <> 2 then begin
    code_err := 201;
    exit;
   end;
   if not CheckIsNumeric(tt_arglist[0]) then begin
    code_err := 204;
    exit;
   end;
   if not CheckIsNumeric(tt_arglist[1]) then begin
    code_err := 204;
    exit;
   end;
   s_rslt := FloatToStr(Min(StrToFloat(tt_arglist[0]), StrToFloat(tt_arglist[1])));
  end;
//-----------------------------------
 end; // end of with
end;

procedure TForm1.RTCalcExpress1ErrorFunction(t_lang: TtLang;
  s_title: String; code_err: Integer);
var s_mes: string;
begin
 if t_lang = ttRussian then case code_err of
  201: s_mes := '   ';
  202: s_mes := '    ';
  203: s_mes := '    ';
  204: s_mes := '   ';
  205: s_mes := '    ';
  else exit;
 end
 else if t_lang = ttEnglish then case code_err of
  201: s_mes := 'Wrong amount of arguments of function';
  202: s_mes := 'Argument of function not string';
  203: s_mes := 'Argument of function not integer';
  204: s_mes := 'Argument of function not number';
  205: s_mes := 'Argument of function not boolean';
  else exit;
 end;
 Application.MessageBox(PChar(s_mes), PChar(s_title), MB_OK + MB_ICONINFORMATION);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 ComboBox1.ItemIndex := 1;
 ComboBox2.ItemIndex := 0;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
 p_tmp: PChar;
 rslt: double;
 n_tmp, code_err: integer;
 s_tmp: string;
begin
 p_tmp := StrAlloc(160);
 n_tmp := SpinEdit1.Value;
 code_err := SpinEdit4.Value;
 if ComboBox2.ItemIndex = 0 then RTCalcExpress1.MessLanguage := ttEnglish
 else RTCalcExpress1.MessLanguage := ttRussian;
 if ComboBox1.ItemIndex = 1 then RTCalcExpress1.ReturnType := ttString
 else RTCalcExpress1.ReturnType := ttNumeric;
 rslt := RTCalcExpress1.Evaluate(PChar(Memo1.Lines.Text), n_tmp, code_err, p_tmp);
 case ComboBox1.ItemIndex of
  0: Edit2.Text := IntToStr(Round(rslt));
  1: Edit2.Text := string(p_tmp);
  3: begin
   s_tmp := ShortDateFormat;
   ShortDateFormat := 'dd.MM.yyyy';
   Edit2.Text := DateToStr(rslt);
   ShortDateFormat := s_tmp;
  end;
  else Edit2.Text := FloatToStr(rslt);
 end;
 StrDispose(p_tmp);
 SpinEdit1.Value := n_tmp;
 SpinEdit4.Value := code_err;
end;

end.
