unit MinModal;

{
-----------------------------
Hi to all Delphi-programmers!
-----------------------------

MinModal: minimizer for modal windows. Why we can't minimize an
          application when a modal window is active? Drop this
          component to the form, open form by method 'ShowModal'
          and try minimize this form at run time.
          All your application will be minimized!

Author: Zimin Sergey. Russia, august 1999.
E-mail: szimin@mypad.com
Web-site: http://members.xoom.com/seregaz/

Status: Freeware with full source.

Tested under Windows 9x, Windows NT.
Component realized for Delphi 3,4,5, C++ Buider 4,5.
(Also must work in C++ Buider 3, but not tested)

Installation: firstly locate the wavepanel.pas and wavepanel.dcr
in the same directory. Choose 'Install Component...' at the main
menu. Choose the 'Into new package' tab. Select in the 'Unit file
name' the minmodal.pas. And in the 'Package file name' input any
file name ('minmodalpack', for example). Press 'Ok' button. That's all!

Other my shareware & freeware programs and components
-----------------------------------------------------
MaxSpace
~~~~~~~~
MaxSpace is a special program for programmers, who use Delphi or
C++ Builder (version insensitive). It turns your Object Inspector and
IDE toolbar into "Auto-Hide" windows. This mean that now you can write
code on a full screen. The normal state of Object Inspector and IDE
tollbar will be out of the screen. But as you will be needed their you
move the pointer of mouse to the left side of screen for appearance
Object Inspector or move to the top for appearance IDE toolbar. And
after you used the Object Inspector or IDE tollbar they automatic move
out of the screen and you again can use a FULL SCREEN. It's perfect for
Delphi 4,5 and C++ Builder 4,5 where the Code Explorer is added  - very
useful addition, but it take the working space and minimum space is
leaved for Code Editor.

CachedQuery
~~~~~~~~~~~
This component is query without BDE's errors in cached updates and
with possibility of saving several queries in one transaction.
If you are using a Borland's TQuery then when you'll try to apply
updates to SQL server and it (SQL server) generate an error (error of
primary key, error of foreign key, insufficient SQL rights, ...)
you'll lose a data. CachedQuery correct this problem and all rows will
be applied or all rows will not be applied.

Asynchronous SQL Components
~~~~~~~~~~~~~~~~~~~~~~~~~~~
These components allow you asynchronously execute several queries
and stored procedures at the same time. The asynchronous executing
is possibility to execute several queries and stored procedures at
the same time (parallel). When queries and stored procedures are
executing asynchronously your application can respond to the user's
and system's requirements and can execute any action that you will
define. Thus the users can refuse executing queries (stored
procedures) at any time. Opening several big dataset take place
in 3-5 time quicker, than if open their synchronously. The bigger
dataset the quicker asynchronous queries is opened (relatively
synchronous). Tested under Microsoft SQL Server 6.5-7.


ElegantMDI
~~~~~~~~~~
This component is a new elegant realiztion of the old squalid MDI
interface. All windows (MDIChild) will be presented as buttons on
autohiding panel, with this component. User can toggle between windows
without choosing items in main menu. It looks very effectively.

Active Banner for Applications
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
You can use it for trial version of your applications or as advertising
your programs, servers, services and so on. For this you locate several
animated or nonanimated gifs to your ftp or web server and indicate to
component their exact URL. And when your application, with this
component, will be started, users can see this gifs. Through some time
you can change this gifs on your ftp (web) server and all your users
will see new gifs at once! And what is more that you can use
a 'URLForGifList' property for indication exact URL for text file with
list of the URL all gifs that you want that users can see through your
applications.

WavePanel
~~~~~~~~~
WavePanel - component with running colors, like panel at the bottom
of the screen when Windows 9x loading.

All this programs you can download from my web site at:
http://members.xoom.com/seregaz/

That's all!
I shall be glad if my components will be useful for you.

                                                             Good luck!
                                                      Sergey, May 2000
                                                      szimin@mypad.com
                                       http://members.xoom.com/seregaz/
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TMinModal = class(TComponent)
  private
    Form: TForm;
    OldModalWndProc: Pointer;
    InstanceModalWndProc: Pointer;
    FAbout: String;
    FOnMinimize: TNotifyEvent;
    procedure SetAbout(const Value: String);
  protected
    procedure ModalWndProc(var Message: TMessage); virtual;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property About: String read FAbout write SetAbout stored False;
    property OnMinimize: TNotifyEvent read FOnMinimize write FOnMinimize;
  end;

procedure Register;

implementation

uses AboutMinModal, DsgnIntf;

const
  EMail = 'szimin@mypad.com';

type
  TAboutProperty = class(TStringProperty)
  protected
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

procedure Register;
begin
  RegisterComponents('Additional', [TMinModal]);

  RegisterPropertyEditor(TypeInfo(String), TMinModal, 'About',
      TAboutProperty);
end;

procedure RememberMe(Sender: TObject);
begin
  with TFormAboutMinModal.Create(Application) do begin
    WavePanel5.Caption := Email;
    Caption := 'http://members.xoom.com/seregaz/';
    Left := (Screen.Width-Width) div 2;
    Top  := (Screen.Height-Height) div 2;
    ShowModal;
    Free;
  end;
end;

{ TMinModal }

constructor TMinModal.Create(AOwner: TComponent);
var
  Component: TComponent;
begin
  inherited Create(AOwner);
  FAbout := 'Minimizer For Modal Windows ('+EMail+')';

  if not(csDesigning in ComponentState) then begin
    Component:=Owner;
    while Assigned(Component) and not (Component is TForm) do
      Component:= Component.Owner;
    if not Assigned(Component) then
      Exit;
    Form := Component as TForm;

    if (not (csDesigning in ComponentState)) then begin
      InstanceModalWndProc := MakeObjectInstance(ModalWndProc);
      OldModalWndProc := Pointer(GetWindowLong(Form.Handle, GWL_WNDPROC));
      SetWindowLong(Form.Handle, GWL_WNDPROC, Longint(InstanceModalWndProc));
    end;
  end;
end;

destructor TMinModal.Destroy;
begin
  if Assigned(InstanceModalWndProc) then begin
    SetWindowLong(Form.Handle, GWL_WNDPROC, Longint(OldModalWndProc));
    FreeObjectInstance(InstanceModalWndProc);
    InstanceModalWndProc := nil;
  end;
  inherited Destroy;
end;

procedure TMinModal.ModalWndProc(var Message: TMessage);
begin
  case Message.Msg of
    WM_SYSCOMMAND:
      begin
        if Message.WParam=SC_MINIMIZE then begin
          if Assigned(FOnMinimize) then FOnMinimize(Self);
          ShowWindow(Application.Handle, SW_SHOWMINNOACTIVE);
          Exit;
        end;
      end;
    WM_DESTROY:
      begin
        if Assigned(InstanceModalWndProc) then begin
          SetWindowLong(Form.Handle, GWL_WNDPROC, Longint(OldModalWndProc));
          FreeObjectInstance(InstanceModalWndProc);
          InstanceModalWndProc := nil;
        end;
      end;
    WM_ACTIVATE:
      begin
        if Message.WParamLo<>WA_INACTIVE then begin
          ShowWindow(Application.Handle, SW_SHOWNORMAL);
//          Exit;
        end;
      end;
  end;
  Message.Result:= CallWindowProc(OldModalWndProc, Form.Handle, Message.Msg, Message.WParam, Message.LParam);
end;

procedure TMinModal.SetAbout(const Value: String);
begin
  if FAbout<>Value then RememberMe(Self);
end;

{ TAboutProperty }

procedure TAboutProperty.Edit;
begin
  RememberMe(Self);
end;

function TAboutProperty.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paReadOnly, paDialog];
end;

end.
