unit BarcodeDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,Barcode1D, ComCtrls;

type
  TRBarcodeDemo = class(TForm)
    Image1: TImage;
    btnRefresh: TButton;
    btnPrint: TButton;
    btnExit: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Label1: TLabel;
    txtCode: TEdit;
    lblMode: TLabel;
    cType: TComboBox;
    Label4: TLabel;
    cCheck: TComboBox;
    Label3: TLabel;
    cCode128Set: TComboBox;
    cSupplement: TComboBox;
    Label2: TLabel;
    lblSymbol: TLabel;
    txtxSupplement: TEdit;
    Label5: TLabel;
    txtX: TEdit;
    Label6: TLabel;
    txtN: TEdit;
    Label7: TLabel;
    txtI: TEdit;
    Label8: TLabel;
    Label9: TLabel;
    txtXPrinter: TEdit;
    Label10: TLabel;
    Label11: TLabel;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btnRefreshClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure btnPrintClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    barcode:TBarcode1D;
  public
    { Public declarations }
  end;

var
  RBarcodeDemo: TRBarcodeDemo;

implementation

uses printers;

{$R *.DFM}

procedure TRBarcodeDemo.FormCreate(Sender: TObject);
begin

barcode:=TBarcode1D.create(nil);
cCode128Set.itemIndex:=0;
cSupplement.itemindex:=0;
cCheck.itemindex:=0;
cType.itemIndex:=0;
btnRefreshClick(nil);
end;

procedure TRBarcodeDemo.btnRefreshClick(Sender: TObject);
var
value:integer;
dummy:integer;
begin


barcode.processTilde:=true;

barcode.code:=txtCode.text;

if (cType.itemIndex>=0) then barcode.bartype:=TSymbology(cType.itemIndex)
else barcode.bartype:=CODE39;

if (cCode128Set.itemIndex=0) then barcode.Code128Set:='A';
if (cCode128Set.itemIndex=1) then barcode.Code128Set:='B';
if (cCode128Set.itemIndex=2) then barcode.Code128Set:='C';

barcode.checkCharacter:=true;
if (cCheck.itemindex=1) then barcode.checkCharacter:=false;

barcode.UPCEANSupplement2:=false;
barcode.UPCEANSupplement5:=false;
if (cSupplement.itemindex=1) then barcode.UPCEANSupplement2:=true;
if (cSupplement.itemindex=2) then barcode.UPCEANSupplement5:=true;

barcode.supplement:=txtxSupplement.text;

val(txtX.text,value,dummy);
barcode.X:=value;

val(txtI.text,value,dummy);
barcode.I:=value;

{val(txtH.text,value,dummy);
barcode.H:=value;}

val(txtN.text,value,dummy);
barcode.N:=value;

barcode.paintBarcode(Image1.Canvas);
end;

procedure TRBarcodeDemo.btnExitClick(Sender: TObject);
begin
hide();
end;

procedure TRBarcodeDemo.btnPrintClick(Sender: TObject);
var
value:integer;
dummy:integer;
begin
     with printer do
     begin
		BeginDoc;

                val(txtXPrinter.text,value,dummy);
                barcode.X:=value;

                barcode.barHeightPixels:=0; {this is needed in order to force recalculation of bars height}
                barcode.topmargin:=printer.PageHeight div 10;
                barcode.leftmargin:=printer.PageWidth div 10;
		barcode.paintBarcode(Canvas);

		EndDoc;
     end;
end;

procedure TRBarcodeDemo.Button1Click(Sender: TObject);
var
bmp:TBitmap;
begin

     bmp:=TBitmap.create();
     bmp.height:=200;
     bmp.width:=200;
     barcode.paintBarcode(bmp.Canvas);
     bmp.SaveToFile('barcode.bmp');

     MessageDlg('Image saved to barcode.bmp.', mtInformation,      [mbOk], 0);


end;

end.
