unit MaxicodeDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,Maxicode;

type
  TMXDemo = class(TForm)
    Image1: TImage;
    Label1: TLabel;
    txtCode: TEdit;
    lblMode: TLabel;
    cMode: TComboBox;
    Label3: TLabel;
    cResolution: TComboBox;
    Label4: TLabel;
    txtSymbols: TEdit;
    lblSymbol: TLabel;
    txtSymbol: TEdit;
    btnRefresh: TButton;
    btnPrint: TButton;
    btnExit: TButton;
    Label2: TLabel;
    txtServiceClass: TEdit;
    Label5: TLabel;
    txtPostalCode: TEdit;
    Label6: TLabel;
    txtCountry: TEdit;
    Button1: TButton;
    procedure btnExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnRefreshClick(Sender: TObject);
    procedure btnPrintClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    maxicode:TMaxicode;
  public
    { Public declarations }
  end;

var
  MXDemo: TMXDemo;

implementation
uses printers;

{$R *.DFM}

procedure TMXDemo.btnExitClick(Sender: TObject);
begin
hide();
end;

procedure TMXDemo.FormCreate(Sender: TObject);
begin
maxicode:=TMaxicode.create(nil);
cResolution.itemIndex:=0;
cMode.itemIndex:=0;
btnRefreshClick(nil);
end;

procedure TMXDemo.btnRefreshClick(Sender: TObject);
var
value:integer;
dummy:integer;
begin
{create new barcode}

maxicode.serviceclass:=txtServiceclass.text;
maxicode.country:=txtCountry.text;
maxicode.zipCode:=txtPostalCode.text;
maxicode.data:=txtCode.text;

if (cMode.itemIndex>=0) then maxicode.mode:=cMode.itemIndex + 2
else maxicode.mode:=2;

if (cResolution.itemIndex>=0) then maxicode.Resolution:=(cResolution.itemIndex + 2 ) *100
else maxicode.Resolution:=200;

val(txtSymbols.text,value,dummy);
maxicode.numberOfCodes:=value;

val(txtSymbol.text,value,dummy);
maxicode.positionOfCode:=value;

maxicode.processTilde:=true;

maxicode.paintBarcode(Image1.Canvas);
end;

procedure TMXDemo.btnPrintClick(Sender: TObject);
begin
     with printer do
     begin
		BeginDoc;


                maxicode.topmargin:=printer.PageHeight div 10;
		maxicode.paintBarcode(Canvas);

		EndDoc;
     end;
end;

procedure TMXDemo.Button1Click(Sender: TObject);
var
bmp:TBitmap;
begin
  bmp:=TBitmap.create();
     bmp.height:=200;
     bmp.width:=200;
     maxicode.paintBarcode(bmp.Canvas);
     bmp.SaveToFile('maxicode.bmp');

     MessageDlg('Image saved to maxicode.bmp.', mtInformation,      [mbOk], 0);

end;

end.
