/*------------------------------------------------------------------------------
  Demo: printing documents using TRVReportHelper.
  This demo loads RVF file in rvh.RichView and prints it.
  rvh2 is used to print header: (- page no -).

  Advantages of this method:
  - possibility to make custom complex headers and footers, different for
    different pages;
  - possibility to implement nonstandard layouts, printing several documents
    in different areas on the same page,etc
  Disadvantages of this method:
  - no preview (at least, not with TRVPrintPreview)
  - you need to calculate all margins yourself

 ------------------------------------------------------------------------------

  For example, you can open RVF file created by ActionText (including readme.rvf).
  Do not try to load file from the editor demo (Demos\*\Editors\Editor 1) - it does
  not contain a collection of styles, so it can be opened only by
  applications having that collection of styles.

------------------------------------------------------------------------------*/

#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RVReport"
#pragma link "PtblRV"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  TRVFOptions RVFOptions;
  RVFOptions << rvfoSavePicturesBody << rvfoSaveControlsBody << rvfoSaveBinary <<
    rvfoSaveBack << rvfoLoadBack << rvfoSaveTextStyles << rvfoSaveParaStyles <<
    rvfoSaveLayout << rvfoLoadLayout;
  rvh->RichView->RVFOptions = RVFOptions;
  rvh->RichView->Options << rvoTagsArePChars;
  rvh->RichView->RVFParaStylesReadMode = rvf_sInsertMerge;
  rvh->RichView->RVFTextStylesReadMode = rvf_sInsertMerge;
  rvh->RichView->Style = RVStyle1;

  rvh2->RichView->Style = RVStyle2;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  if (OpenDialog1->Execute())
    rvh->RichView->LoadRVF(OpenDialog1->FileName);
}
//---------------------------------------------------------------------------
// print one column
void __fastcall TForm1::Button2Click(TObject *Sender)
{
  if (rvh->RichView->ItemCount==0)
  {
    Application->MessageBox("Document is empty!", "Empty", 0);
    return;
  }
  Printer()->Title = "ReportHelper Test";
  Printer()->BeginDoc();
  int PageNo = 1;
  int DocLeft = Printer()->PageWidth / 20; // margins = 5%
  int DocWidth = Printer()->PageWidth - DocLeft*2;
  int HeaderTop = Printer()->PageHeight / 20; // margins = 5%
  rvh->Init(Printer()->Canvas, DocWidth);
  while (true)
  {
    // creating & formatting header
    rvh2->RichView->Clear();
    rvh2->RichView->AddFmt("- %d -", ARRAYOFCONST((PageNo)), 0, 1);
    rvh2->Init(Printer()->Canvas, DocWidth);
    rvh2->FormatNextPage(Printer()->PageHeight);
    int DocTop = HeaderTop + rvh2->EndAt + HeaderTop/2;
    // formatting next page of document
    int DocHeight = Printer()->PageHeight - DocTop - HeaderTop;
    if (!rvh->FormatNextPage(DocHeight))
      break;
    // starting new page
    if (PageNo>1)
      Printer()->NewPage();
    // drawing line between header and document
    Printer()->Canvas->Pen->Style = psInsideFrame;
    Printer()->Canvas->Pen->Width = 10;
    Printer()->Canvas->Pen->Color = clBlack;
    int LineY = HeaderTop + rvh2->EndAt + HeaderTop/4;
    Printer()->Canvas->MoveTo(DocLeft*2, LineY);
    Printer()->Canvas->LineTo(Printer()->PageWidth-DocLeft*2, LineY);
    // drawing header and document
    rvh2->DrawPageAt(DocLeft, HeaderTop, 1, Printer()->Canvas, false, rvh2->EndAt);
    rvh->DrawPageAt(DocLeft, DocTop, PageNo, Printer()->Canvas, false, DocHeight);
    PageNo++;
  }
  Printer()->EndDoc();
}
//---------------------------------------------------------------------------
// print two columns
void __fastcall TForm1::Button3Click(TObject *Sender)
{
  if (rvh->RichView->ItemCount==0)
  {
    Application->MessageBox("Document is empty!", "Empty", 0);
    return;
  }
  Printer()->Title = "ReportHelper Test";
  Printer()->BeginDoc();
  int PageNo = 1;
  int HeaderLeft = Printer()->PageWidth/20; // margins = 5%
  int HeaderWidth = Printer()->PageWidth - HeaderLeft*2;
  int HeaderTop = Printer()->PageHeight/20; // margins = 5%
  int ColWidth = (HeaderWidth-HeaderLeft)/2;
  int Col1Left = HeaderLeft;
  int Col2Left = Col1Left + ColWidth + HeaderLeft/2;
  rvh->Init(Printer()->Canvas, ColWidth);
  while (true)
  {
    // creating & formatting header
    rvh2->RichView->Clear();
    rvh2->RichView->AddFmt("- %d -", ARRAYOFCONST((PageNo)), 0, 1);
    rvh2->Init(Printer()->Canvas, HeaderWidth);
    rvh2->FormatNextPage(Printer()->PageHeight);
    int DocTop = HeaderTop + rvh2->EndAt + HeaderTop/2;
    // formatting the first column of document
    int DocHeight = Printer()->PageHeight - DocTop - HeaderTop;
    if (!rvh->FormatNextPage(DocHeight))
      break;
    // starting new page
    if (PageNo>1)
      Printer()->NewPage();
    // drawing line between header and document
    Printer()->Canvas->Pen->Style = psInsideFrame;
    Printer()->Canvas->Pen->Width = 10;
    Printer()->Canvas->Pen->Color = clBlack;
    int LineY = HeaderTop + rvh2->EndAt + HeaderTop/4;
    Printer()->Canvas->MoveTo(HeaderLeft*2, LineY);
    Printer()->Canvas->LineTo(Printer()->PageWidth-HeaderLeft*2, LineY);
    // drawing header and document
    rvh2->DrawPageAt(HeaderLeft, HeaderTop, 1, Printer()->Canvas, false, rvh2->EndAt);
    rvh->DrawPageAt(Col1Left, DocTop, PageNo*2-1, Printer()->Canvas, false, DocHeight);
    if (rvh->FormatNextPage(DocHeight))
      rvh->DrawPageAt(Col2Left, DocTop, PageNo*2, Printer()->Canvas, false, DocHeight);
    PageNo++;
  }
  Printer()->EndDoc();
}
//--------------------------------------------------------------------------- 