VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "RFS Client sample"
   ClientHeight    =   6630
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8775
   LinkTopic       =   "Form1"
   ScaleHeight     =   6630
   ScaleWidth      =   8775
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton pbGetInfo 
      Caption         =   "Get File Info"
      Height          =   375
      Left            =   2880
      TabIndex        =   29
      Top             =   4440
      Width           =   1215
   End
   Begin VB.TextBox Text5 
      Height          =   285
      Left            =   2880
      TabIndex        =   28
      Text            =   "CDRIVE:\WINNT\win.ini"
      Top             =   4080
      Width           =   5655
   End
   Begin VB.CommandButton pbDeleteDir 
      Caption         =   "Delete Dir"
      Height          =   375
      Left            =   4200
      TabIndex        =   27
      Top             =   6120
      Width           =   1095
   End
   Begin VB.CommandButton pbCreateDir 
      Caption         =   "Create Dir"
      Height          =   375
      Left            =   2880
      TabIndex        =   26
      Top             =   6120
      Width           =   1215
   End
   Begin VB.TextBox Text4 
      Height          =   285
      Left            =   2880
      TabIndex        =   25
      Text            =   "CDRIVE:\MyDir"
      Top             =   5760
      Width           =   5655
   End
   Begin VB.CommandButton pbCreate 
      Caption         =   "Create File"
      Height          =   375
      Left            =   2880
      TabIndex        =   24
      Top             =   5280
      Width           =   1215
   End
   Begin VB.TextBox Text3 
      Height          =   285
      Left            =   2880
      TabIndex        =   23
      Text            =   "CDRIVE:\RFS_Test.txt"
      Top             =   4920
      Width           =   5655
   End
   Begin VB.CommandButton pbDeleteFile 
      Caption         =   "Delete File"
      Height          =   375
      Left            =   4200
      TabIndex        =   22
      Top             =   5280
      Width           =   1095
   End
   Begin VB.ListBox FilesList 
      Height          =   2595
      Left            =   120
      TabIndex        =   21
      Top             =   3720
      Width           =   2535
   End
   Begin VB.TextBox dfFileMask 
      Height          =   285
      Left            =   120
      TabIndex        =   19
      Text            =   "CDRIVE:\*.*"
      Top             =   2880
      Width           =   2535
   End
   Begin VB.CommandButton pbFindFiles 
      Caption         =   "Find Files"
      Height          =   375
      Left            =   120
      TabIndex        =   18
      Top             =   3240
      Width           =   975
   End
   Begin VB.CommandButton pbView 
      Caption         =   "View File"
      Height          =   375
      Left            =   4320
      TabIndex        =   17
      Top             =   720
      Width           =   1335
   End
   Begin VB.CommandButton pbAppend 
      Caption         =   "Append to File"
      Height          =   375
      Left            =   7200
      TabIndex        =   16
      Top             =   3240
      Width           =   1215
   End
   Begin VB.TextBox Text2 
      Height          =   615
      Left            =   2880
      MultiLine       =   -1  'True
      TabIndex        =   15
      Top             =   3240
      Width           =   4215
   End
   Begin VB.CommandButton pbCloseFile 
      Caption         =   "Close File"
      Height          =   375
      Left            =   5760
      TabIndex        =   14
      Top             =   720
      Width           =   1215
   End
   Begin VB.TextBox Text1 
      Height          =   1935
      Left            =   2880
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   13
      Top             =   1200
      Width           =   5655
   End
   Begin VB.CommandButton pbOpenFile 
      Caption         =   "Open File"
      Height          =   375
      Left            =   2880
      TabIndex        =   12
      Top             =   720
      Width           =   1335
   End
   Begin VB.TextBox FileName 
      Height          =   285
      Left            =   2880
      TabIndex        =   10
      Text            =   "CDRIVE:\WINNT\win.ini"
      Top             =   360
      Width           =   5655
   End
   Begin VB.CommandButton pbDisconnect 
      Caption         =   "Disconnect"
      Height          =   375
      Left            =   1080
      TabIndex        =   9
      Top             =   2040
      Width           =   1455
   End
   Begin VB.TextBox Password 
      Height          =   285
      IMEMode         =   3  'DISABLE
      Left            =   1080
      PasswordChar    =   "*"
      TabIndex        =   8
      Text            =   "adm"
      Top             =   1200
      Width           =   1455
   End
   Begin VB.TextBox User 
      Height          =   285
      Left            =   1080
      TabIndex        =   6
      Text            =   "adm"
      Top             =   840
      Width           =   1455
   End
   Begin VB.TextBox Port 
      Height          =   285
      Left            =   1080
      TabIndex        =   4
      Text            =   "7007"
      Top             =   480
      Width           =   735
   End
   Begin VB.CommandButton pbConnect 
      Caption         =   "Connect"
      Height          =   375
      Left            =   1080
      TabIndex        =   1
      Top             =   1560
      Width           =   1455
   End
   Begin VB.TextBox Host 
      Height          =   285
      Left            =   1080
      TabIndex        =   0
      Text            =   "LocalHost"
      Top             =   120
      Width           =   1455
   End
   Begin VB.Shape Shape4 
      Height          =   6615
      Left            =   0
      Top             =   0
      Width           =   8655
   End
   Begin VB.Shape Shape3 
      Height          =   3975
      Left            =   2760
      Top             =   0
      Width           =   5895
   End
   Begin VB.Shape Shape2 
      Height          =   4095
      Left            =   0
      Top             =   2520
      Width           =   2775
   End
   Begin VB.Shape Shape1 
      Height          =   2655
      Left            =   2760
      Top             =   3960
      Width           =   5895
   End
   Begin VB.Label Label6 
      Caption         =   "File mask:"
      Height          =   255
      Left            =   120
      TabIndex        =   20
      Top             =   2640
      Width           =   1575
   End
   Begin VB.Label Label5 
      Caption         =   "Remote file name"
      Height          =   255
      Left            =   2880
      TabIndex        =   11
      Top             =   120
      Width           =   2055
   End
   Begin VB.Label Label4 
      Caption         =   "Password:"
      Height          =   255
      Left            =   120
      TabIndex        =   7
      Top             =   1200
      Width           =   855
   End
   Begin VB.Label Label3 
      Caption         =   "User:"
      Height          =   255
      Left            =   120
      TabIndex        =   5
      Top             =   840
      Width           =   615
   End
   Begin VB.Label Label2 
      Caption         =   "Port:"
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   480
      Width           =   495
   End
   Begin VB.Label Label1 
      Caption         =   "Host:"
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   120
      Width           =   375
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim nConnection As Long
Dim hFile As Long

Function CheckError(nCode As Integer) As Boolean
    Dim sError As String
    sError = Space(1024) 'allocate memory
    If nCode <> 0 Then
       Call RFS_GetErrorText(nCode, sError)
       Call MsgBox(ToString(sError))
       CheckError = False
    Else
       CheckError = True
    End If
End Function

Private Sub Form_Load()
     Form1.Caption = "RFS Client Sample - Disconnected"
End Sub

Private Sub Form_Unload(Cancel As Integer)
   Call pbDisconnect_Click
End Sub

Private Sub pbAppend_Click()
    Dim NewPointer As Long
    Dim BytesWritten As Long
    Dim Buffer As String
    'set file pointer to the end of file,
    If CheckError(RFS_FileSetPointer(nConnection, hFile, 0, RFS_FILE_END, VarPtr(NewPointer))) Then
       'write to file
        Buffer = Text2
        Dim nLen As Long
        nLen = Len(Buffer)
        If CheckError(RFS_FileWrite(nConnection, hFile, Buffer, nLen, VarPtr(BytesWritten))) Then
            Text2 = ""
        End If
    End If
End Sub

Private Sub pbCloseFile_Click()
    'Close file
    Call RFS_FileClose(nConnection, hFile)
End Sub

Private Sub pbConnect_Click()
  If CheckError(RFS_Connect(Host, CInt(Port), User, Password, VarPtr(nConnection))) Then
       Form1.Caption = "RFS Client Sample - Connected"
  End If
End Sub
Private Sub pbCreate_Click()
   Dim FileName As String
   FileName = Text3
   If CheckError(RFS_FileCreate(nConnection, FileName)) Then
      MsgBox ("File created")
   End If
End Sub
Private Sub pbDeleteFile_Click()
   Dim FileName As String
   FileName = Text3
   If CheckError(RFS_FileDelete(nConnection, FileName)) Then
      MsgBox ("File deleted")
   End If
End Sub
Private Sub pbCreateDir_Click()
   Dim PathName As String
   PathName = Text4
   If CheckError(RFS_CreateDir(nConnection, PathName)) Then
      MsgBox ("Directory created")
   End If
End Sub
Private Sub pbDeleteDir_Click()
   Dim PathName As String
   PathName = Text4
   If CheckError(RFS_DeleteDir(nConnection, PathName)) Then
      MsgBox ("Directory deleted")
   End If
End Sub
Private Sub pbDisconnect_Click()
   If CheckError(RFS_Disconnect(nConnection)) Then
      Form1.Caption = "RFS Client Sample - Disconnected"
   End If
End Sub
Private Sub pbFindFiles_Click()
   FilesList.Clear
   Dim FMask As String
   Dim FileName As String
   Dim hSearch As Long
   FMask = dfFileMask
   FileName = Space(1024)
   Dim fInfo As RFS_FILE_INFO
   If CheckError(RFS_FileFindFirst(nConnection, FMask, VarPtr(hSearch), FileName, VarPtr(fInfo))) Then
      Do While ToString(FileName) <> ""
         If (fInfo.Directory) Then
             FilesList.AddItem ("<D> " + ToString(FileName)) ' Directory
         Else
             FilesList.AddItem ("<F> " + ToString(FileName)) ' File
         End If
         CheckError (RFS_FileFindNext(nConnection, hSearch, FileName, VarPtr(fInfo)))
      Loop
   End If
End Sub
Private Sub pbGetInfo_Click()
    Dim fInfo As RFS_FILE_INFO
    Dim SysTime As SYSTEMTIME
    Dim FileName As String
    FileName = Text5
    If CheckError(RFS_FileGetInfo(nConnection, FileName, VarPtr(fInfo))) Then
       Call FileTimeToSystemTime(fInfo.ftCreationTime, SysTime)
       MsgBox "The file size is " + CStr(fInfo.nFileSize) + " bytes; Created on " + Str$(SysTime.wMonth) + "/" + LTrim(Str$(SysTime.wDay)) + "/" + LTrim(Str$(SysTime.wYear))
    End If
End Sub
Private Sub pbOpenFile_Click()
    Dim lphFile As Long
    Dim nRes As Integer
    lphFile = VarPtr(hFile)
    If CheckError(RFS_FileExists(nConnection, FileName, VarPtr(nRes))) Then
         If (bRes = 0) Then 'file exists
             Call CheckError(RFS_FileOpen(nConnection, FileName, RFS_FILE_READWRITE, lphFile))
         Else
             MsgBox ("File not exists")
         End If
    End If
End Sub
Private Sub pbView_Click()
    Dim BytesRead As Long
    Dim Buffer As String
    Dim FileSize As String
    Dim NewPointer As Long
    'set file pointer to the end of file, to determine file size
    If CheckError(RFS_FileSetPointer(nConnection, hFile, 0, RFS_FILE_END, VarPtr(NewPointer))) Then
       FileSize = NewPointer
       'set back file pointer to the beginning of file
       If CheckError(RFS_FileSetPointer(nConnection, hFile, 0, RFS_FILE_BEGIN, VarPtr(NewPointer))) Then
            Buffer = Space(FileSize) ' allocate memory
            ' read 'FileSize' bytes from file
            If CheckError(RFS_FileRead(nConnection, hFile, Buffer, FileSize, VarPtr(BytesRead))) Then
               Text1 = Left(Buffer, BytesRead) 'Display file data
            End If
       End If
    End If
End Sub

