/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.Serializable;

public class GXYGrid {
    public static final Color GRIDLINE_COLOR = new Color(96, 160, 255);
    public static final Color AXIS_COLOR = Color.magenta;
    public static final double MARGINWIDTH = 1.0;
    private GRectangle xyBounds;
    public GRectangle uvBounds;
    private GSegmentList xyGridLines;
    private GSegmentList uvGridLines;
    private GSegment xyXAxis;
    private GSegment xyYAxis;
    private GSegment uvXAxis;
    private GSegment uvYAxis;
    private GSegment xyVertical;
    private GSegment uvVertical;
    private GPoint3D xySelection;
    private GPoint3D uvSelection;
    private GPoint3D zMark;
    private GPoint3D uvMark;
    public GPoint3DList xyVertexDrops = new GPoint3DList();
    public GPoint3DList uvVertexDrops = new GPoint3DList();
    public GPoint3DList xyGridNodes;
    public GPoint3DList zMarks;
    public GPoint3DList uvMarks;
    private boolean visible;
    private double gap;
    private int[] dim;

    public GXYGrid() {
        this.xyGridLines = new GSegmentList();
        this.uvGridLines = new GSegmentList();
        this.xyGridNodes = new GPoint3DList();
        this.zMarks = new GPoint3DList();
        this.uvMarks = new GPoint3DList();
        this.dim = new int[2];
    }

    public void print() {
        this.xyBounds.print();
    }

    public void project(GSolid gSolid) {
        this.dropSolid(gSolid);
        GProjSystem gProjSystem = gSolid.projSystem;
        this.uvBounds = gProjSystem.project(this.xyBounds);
        this.uvVertexDrops.flush();
        GPoint3DNode gPoint3DNode = this.xyVertexDrops.getHead();
        while (gPoint3DNode != null) {
            this.uvVertexDrops.addToTail(gProjSystem.project(gPoint3DNode.getPoint3D()));
            gPoint3DNode = gPoint3DNode.getNext();
        }
        this.uvGridLines.flush();
        GSegmentNode gSegmentNode = this.xyGridLines.getHead();
        while (gSegmentNode != null) {
            this.uvGridLines.addToTail(gProjSystem.project(gSegmentNode.getSegment()));
            gSegmentNode = gSegmentNode.getNext();
        }
        this.uvXAxis = gProjSystem.project(this.xyXAxis);
        this.uvYAxis = gProjSystem.project(this.xyYAxis);
        if (this.xySelection != null) {
            this.uvSelection = gProjSystem.project(this.xySelection);
        }
        this.projectVertical(gProjSystem);
    }

    protected void projectVertical(GProjSystem gProjSystem) {
        this.uvBounds = gProjSystem.project(this.xyBounds);
        if (this.xyVertical == null) {
            return;
        }
        this.uvVertical = gProjSystem.project(this.xyVertical);
        this.uvBounds.add(this.uvVertical.end1.X, this.uvVertical.end1.Y);
        this.uvBounds.add(this.uvVertical.end2.X, this.uvVertical.end2.Y);
        this.uvMarks.flush();
        GPoint3DNode gPoint3DNode = this.zMarks.getHead();
        while (gPoint3DNode != null) {
            this.uvMarks.addToTail(gProjSystem.project(gPoint3DNode.getPoint3D()));
            gPoint3DNode = gPoint3DNode.getNext();
        }
    }

    protected void dropSolid(GSolid gSolid) {
        GPoint3D gPoint3D;
        GPoint3D gPoint3D2;
        if (gSolid == null) {
            return;
        }
        this.xyVertexDrops.flush();
        this.xyGridLines.flush();
        this.xyGridNodes.flush();
        this.xyBounds = new GRectangle();
        GVertexNode gVertexNode = gSolid.vertexList.getHead();
        while (gVertexNode != null && gVertexNode.getVertex().isProper()) {
            GPoint3D gPoint3D3 = gVertexNode.getVertex().xyzCrds;
            this.xyVertexDrops.addToTail(gPoint3D3);
            this.xyBounds.add(gPoint3D3.X, gPoint3D3.Y);
            gVertexNode = gVertexNode.getNext();
        }
        this.xyBounds.enlarge(1.0);
        this.xyBounds.add(0.0, 0.0);
        double d = this.xyBounds.square();
        if (d == 0.0) {
            this.xyBounds.grow(5.0);
            d = 10.0;
        }
        this.gap = this.gauge(d);
        this.dim = this.xyBounds.standartize(this.gap);
        int n = 0;
        while (n <= this.dim[1]) {
            gPoint3D2 = new GPoint3D(this.xyBounds.left, this.xyBounds.bottom + (double)n * this.gap, 0.0);
            gPoint3D = new GPoint3D(this.xyBounds.right, this.xyBounds.bottom + (double)n * this.gap, 0.0);
            this.xyGridLines.addToTail(new GSegment(gPoint3D2, gPoint3D));
            ++n;
        }
        int n2 = 0;
        while (n2 <= this.dim[0]) {
            gPoint3D2 = new GPoint3D(this.xyBounds.left + (double)n2 * this.gap, this.xyBounds.bottom, 0.0);
            gPoint3D = new GPoint3D(this.xyBounds.left + (double)n2 * this.gap, this.xyBounds.top, 0.0);
            this.xyGridLines.addToTail(new GSegment(gPoint3D2, gPoint3D));
            ++n2;
        }
        int n3 = 0;
        while (n3 <= this.dim[1]) {
            int n4 = 0;
            while (n4 <= this.dim[0]) {
                GPoint3D gPoint3D4 = new GPoint3D(this.xyBounds.left + (double)n3 * this.gap, this.xyBounds.bottom + (double)n4 * this.gap, 0.0);
                this.xyGridNodes.addToTail(gPoint3D4);
                ++n4;
            }
            ++n3;
        }
        gPoint3D2 = new GPoint3D(this.xyBounds.left, 0.0, 0.0);
        gPoint3D = new GPoint3D(this.xyBounds.right, 0.0, 0.0);
        this.xyXAxis = new GSegment(gPoint3D2, gPoint3D);
        gPoint3D2 = new GPoint3D(0.0, this.xyBounds.bottom, 0.0);
        gPoint3D = new GPoint3D(0.0, this.xyBounds.top, 0.0);
        this.xyYAxis = new GSegment(gPoint3D2, gPoint3D);
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected double gauge(double d) {
        int[] nArray = GMath.expForm(d / 20.0);
        int[] nArray2 = GMath.expForm(d / 8.0);
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        if (n >= 1 && n < 2) {
            return 2.0 * GMath.intPow(10, n2);
        }
        if (n >= 2 && n < 5 && n3 >= 5 && n < 10) {
            return 5.0 * GMath.intPow(10, n2);
        }
        return GMath.intPow(10, n4);
    }

    public void paint(GSolidCanvas gSolidCanvas, GSolid gSolid) {
        Object object;
        if (!this.visible) {
            return;
        }
        GSegmentNode gSegmentNode = this.uvGridLines.getHead();
        while (gSegmentNode != null) {
            object = gSegmentNode.getSegment();
            gSolidCanvas.paint((GSegment)object, GRIDLINE_COLOR, 0);
            gSegmentNode = gSegmentNode.getNext();
        }
        gSolidCanvas.paint(this.uvXAxis, AXIS_COLOR, 0, null, "x");
        gSolidCanvas.paint(this.uvYAxis, AXIS_COLOR, 0, null, "y");
        if (this.xySelection != null) {
            gSolidCanvas.paint(this.uvSelection, GRIDLINE_COLOR);
            if (this.xyVertical != null) {
                gSolidCanvas.paint(this.uvVertical, GRIDLINE_COLOR, 0);
                object = this.uvMarks.getHead();
                while (object != null) {
                    GPoint3D gPoint3D = ((GPoint3DNode)object).getPoint3D();
                    gSolidCanvas.horizMark(gPoint3D, GRIDLINE_COLOR);
                    object = ((GPoint3DNode)object).getNext();
                }
                if (this.zMark != null) {
                    gSolidCanvas.paint(this.uvMark, GSolid.VERTEX_COLOR);
                }
            }
        }
    }

    protected void buildVertical(GSolid gSolid) {
        GPoint3D gPoint3D;
        if (this.xySelection == null) {
            return;
        }
        double d = this.xyBounds.right - this.xyBounds.left;
        GPoint3D gPoint3D2 = gSolid.getZExtent();
        double d2 = Math.min(gPoint3D2.X, -d / 2.0);
        double d3 = Math.max(gPoint3D2.Y, d / 2.0);
        GPoint3D gPoint3D3 = new GPoint3D(this.xySelection.X, this.xySelection.Y, d2);
        GPoint3D gPoint3D4 = new GPoint3D(this.xySelection.X, this.xySelection.Y, d3);
        this.xyVertical = new GSegment(gPoint3D3, gPoint3D4);
        this.zMarks.flush();
        this.zMarks.addToTail(new GPoint3D(this.xySelection.X, this.xySelection.Y, 0.0));
        double d4 = -this.gap;
        while (d4 >= d2) {
            gPoint3D = new GPoint3D(this.xySelection.X, this.xySelection.Y, d4);
            this.zMarks.addToTail(gPoint3D);
            d4 -= this.gap;
        }
        d4 = this.gap;
        while (d4 <= d3) {
            gPoint3D = new GPoint3D(this.xySelection.X, this.xySelection.Y, d4);
            this.zMarks.addToTail(gPoint3D);
            d4 += this.gap;
        }
        this.projectVertical(gSolid.projSystem);
    }

    public void clearSelection(GSolid gSolid) {
        this.xySelection = null;
        this.xyVertical = null;
        this.zMark = null;
        this.uvBounds = gSolid.projSystem.project(this.xyBounds);
    }

    public boolean selectXY(GPoint3D gPoint3D, GSolid gSolid, double d) {
        Serializable serializable;
        boolean bl = false;
        GProjSystem gProjSystem = gSolid.projSystem;
        Serializable serializable2 = GMath.adhereXYPlane(gPoint3D, gProjSystem);
        if (serializable2.X < this.xyBounds.left || serializable2.X > this.xyBounds.right || serializable2.Y < this.xyBounds.bottom || serializable2.Y > this.xyBounds.top) {
            return false;
        }
        GPoint3DNode gPoint3DNode = this.xyGridNodes.getHead();
        while (gPoint3DNode != null) {
            serializable = gPoint3DNode.getPoint3D();
            if (GMath.adhere(gPoint3D, (GPoint3D)serializable, gProjSystem, d)) {
                serializable2 = serializable;
                bl = true;
                break;
            }
            gPoint3DNode = gPoint3DNode.getNext();
        }
        if (!bl) {
            serializable = this.xyGridLines.getHead();
            while (serializable != null) {
                GSegment gSegment = ((GSegmentNode)serializable).getSegment();
                GPoint3D gPoint3D2 = GMath.adhere(gPoint3D, gSegment, gProjSystem, d);
                if (gPoint3D2 != null) {
                    serializable2 = gPoint3D2;
                    break;
                }
                serializable = ((GSegmentNode)serializable).getNext();
            }
        }
        this.xySelection = serializable2;
        this.uvSelection = gProjSystem.project((GPoint3D)serializable2);
        this.xyVertical = null;
        this.zMark = null;
        this.uvBounds = gProjSystem.project(this.xyBounds);
        return true;
    }

    public GPoint3D getXYSelection() {
        return this.xySelection;
    }

    public GPoint3D selectZ(GPoint3D gPoint3D, GSolid gSolid, double d) {
        if (this.xyVertical == null) {
            return null;
        }
        GProjSystem gProjSystem = gSolid.projSystem;
        GPoint3DNode gPoint3DNode = this.zMarks.getHead();
        while (gPoint3DNode != null) {
            GPoint3D gPoint3D2 = gPoint3DNode.getPoint3D();
            if (GMath.adhere(gPoint3D, gPoint3D2, gProjSystem, d)) {
                this.zMark = gPoint3D2;
                this.uvMark = gProjSystem.project(this.zMark);
                return this.zMark;
            }
            gPoint3DNode = gPoint3DNode.getNext();
        }
        this.zMark = GMath.adhere(gPoint3D, this.xyVertical, gProjSystem, d);
        if (this.zMark == null) {
            return null;
        }
        this.uvMark = gProjSystem.project(this.zMark);
        return this.zMark;
    }
}

