/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;

public class GHelpDialog
extends GDialog
implements ActionListener {
    public static final Dimension DATAAREA = new Dimension(350, 350);
    private GButton contentsButton;
    private GButton indexButton;
    private GButton backButton;
    private GButton gotoButton;
    private GButton closeButton;
    private Component data;
    private GHelpCanvas textCanvas;
    private GHelpIndex index;
    private String curTopic;
    private GHelpTopicList allTopics;
    private GHelpTopicList backTopics;

    public GHelpDialog(GFrame gFrame, GHelpTopicList gHelpTopicList) {
        super(gFrame, "GEOMETRIA Help", false);
        this.allTopics = gHelpTopicList;
        this.curTopic = new String();
        this.contentsButton = new GButton("Contents");
        this.contentsButton.addActionListener(this);
        this.indexButton = new GButton("Index");
        this.indexButton.addActionListener(this);
        this.backButton = new GButton("Back");
        this.backButton.addActionListener(this);
        this.gotoButton = new GButton("Go To");
        this.gotoButton.addActionListener(this);
        this.closeButton = new GButton("Close");
        this.closeButton.addActionListener(this);
        this.addWindowListener(this);
        this.textCanvas = new GHelpCanvas(GDialog.frame, this, DATAAREA, "");
        this.data = this.buildScroller();
        this.backTopics = new GHelpTopicList();
        this.buildIndex();
        this.layComponents();
        this.pack();
        this.positionRight();
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, false);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 2;
        gridBagLayout.setConstraints(this.contentsButton, gridBagConstraints);
        this.buttonsPanel.add(this.contentsButton);
        gridBagConstraints.insets.left = 2;
        gridBagLayout.setConstraints(this.indexButton, gridBagConstraints);
        this.buttonsPanel.add(this.indexButton);
        gridBagLayout.setConstraints(this.backButton, gridBagConstraints);
        this.buttonsPanel.add(this.backButton);
        gridBagLayout.setConstraints(this.gotoButton, gridBagConstraints);
        this.buttonsPanel.add(this.gotoButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.right = 2;
        gridBagLayout.setConstraints(this.closeButton, gridBagConstraints);
        this.buttonsPanel.add(this.closeButton);
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.insets.bottom = 2;
        gridBagLayout.setConstraints(this.data, gridBagConstraints);
        this.dataPanel.add(this.data);
    }

    protected void buildIndex() {
        this.index = new GHelpIndex(this, this.allTopics.getDim(), DATAAREA);
        this.index.setSize(DATAAREA);
        GLabelNode gLabelNode = this.allTopics.getHead();
        while (gLabelNode != null) {
            if (!gLabelNode.isMarked()) {
                String string = gLabelNode.getLabel();
                String string2 = string.substring(0, string.indexOf(10));
                this.index.add(" " + string2);
            }
            gLabelNode = gLabelNode.getNext();
        }
        this.index.select(0);
    }

    protected String readTopic(String string) {
        GLabelNode gLabelNode = this.allTopics.getHead();
        while (gLabelNode != null) {
            int n;
            String string2 = gLabelNode.getLabel();
            String string3 = string2.substring(0, n = string2.indexOf(10));
            if (string.equals(string3)) {
                return string2.substring(n + 1);
            }
            gLabelNode = gLabelNode.getNext();
        }
        return "No help available on this topic";
    }

    public void set(String string, boolean bl) {
        this.backButton.setEnabled(false);
        this.backTopics.flush();
        if (string != null) {
            this.gotoButton.setEnabled(false);
            this.curTopic = string;
            this.textCanvas.setText(this.readTopic(this.curTopic));
            this.setData(this.buildScroller());
        } else {
            this.gotoButton.setEnabled(true);
            this.setData(this.index);
            this.index.requestFocus();
            this.curTopic = null;
        }
        if (bl) {
            this.setModal(true);
        }
        this.show();
        if (bl) {
            this.setModal(false);
        }
    }

    public void setTopic(String string) {
        this.backup();
        this.curTopic = string;
        this.textCanvas.setText(this.readTopic(this.curTopic));
        this.setData(this.buildScroller());
        this.gotoButton.setEnabled(false);
    }

    protected void setData(Component component) {
        this.textCanvas.setCursor(Cursor.getDefaultCursor());
        if (component == this.data && component == this.index) {
            return;
        }
        this.data = component;
        this.dataPanel.removeAll();
        this.dataPanel.add(this.data);
        this.pack();
    }

    protected void backup() {
        if (this.curTopic != null) {
            this.backTopics.addToTail(this.curTopic);
            this.backButton.setEnabled(true);
        }
    }

    protected ScrollPane buildScroller() {
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.add(this.textCanvas);
        scrollPane.setSize(GHelpDialog.DATAAREA.width + 20, GHelpDialog.DATAAREA.height + 20);
        scrollPane.getVAdjustable().setUnitIncrement(10);
        scrollPane.getHAdjustable().setUnitIncrement(10);
        scrollPane.setBackground(GHelpCanvas.BACKGROUND);
        return scrollPane;
    }

    public void windowClosing(WindowEvent windowEvent) {
        ActionEvent actionEvent = new ActionEvent(this.closeButton, 0, null);
        this.actionPerformed(actionEvent);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.contentsButton) {
            this.setTopic("contents");
            return;
        }
        if (actionEvent.getSource() == this.indexButton) {
            this.backup();
            this.setData(this.index);
            this.curTopic = null;
            this.gotoButton.setEnabled(true);
            return;
        }
        if (actionEvent.getSource() == this.backButton) {
            this.curTopic = this.backTopics.getTail().getLabel();
            this.backTopics.chop();
            if (this.backTopics.getDim() == 0) {
                this.backButton.setEnabled(false);
            }
            this.textCanvas.setText(this.readTopic(this.curTopic));
            this.setData(this.buildScroller());
            this.gotoButton.setEnabled(false);
            return;
        }
        if (actionEvent.getSource() == this.gotoButton) {
            this.setTopic(this.index.getSelectedItem().trim());
            return;
        }
        if (actionEvent.getSource() == this.closeButton) {
            ((Component)this).setVisible(false);
        }
    }
}

