/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;

public class GMidpointDialog
extends GOkCancelHelpDialog {
    public static final String ICONFILE = "midpoint.gif";
    public static final Dimension ICONDIM = new Dimension(120, 40);
    private TextField midpoint;
    private TextField p1;
    private TextField p2;
    private GButton getOneButton;
    private GSolid solid;
    private String defaultMidpoint;

    public GMidpointDialog(GFrame gFrame, GSolid gSolid, GProblem gProblem, int n, Object[] objectArray) {
        super(gFrame, "Bisect Segment");
        this.helpTopic = "draw midpoint";
        this.solid = gSolid;
        this.midpoint = new TextField(3);
        this.midpoint.setFont(gFrame.labelFont);
        this.p1 = new TextField(3);
        this.p1.setFont(gFrame.labelFont);
        this.p2 = new TextField(3);
        this.p2.setFont(gFrame.labelFont);
        this.getOneButton = new GButton("Get One");
        this.getOneButton.addActionListener(this);
        this.layComponents();
        this.pack();
        this.positionLeft();
        this.set(gProblem, n, objectArray);
    }

    protected void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        Label label = new Label("Draw the midpoint of the segment labeled:");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dataPanel.add(label);
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.p1, gridBagConstraints);
        this.dataPanel.add(this.p1);
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 10;
        Image image = this.getToolkit().getImage(String.valueOf(GDialog.frame.imageDir) + "\\" + ICONFILE);
        GIconCanvas gIconCanvas = new GIconCanvas(image, ICONDIM);
        gridBagLayout.setConstraints(gIconCanvas, gridBagConstraints);
        this.dataPanel.add(gIconCanvas);
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.p2, gridBagConstraints);
        this.dataPanel.add(this.p2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.fill = 2;
        Label label2 = new Label("Assign label to the midpoint:");
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.dataPanel.add(label2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.midpoint, gridBagConstraints);
        this.dataPanel.add(this.midpoint);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.getOneButton, gridBagConstraints);
        this.getOneButton.setFont(GDialog.buttonFont);
        this.dataPanel.add(this.getOneButton);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 20;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.buttonsPanel.add(this.okButton);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    public Object[] getFields() {
        Object[] objectArray = new Object[]{this.p1.getText().toUpperCase(), this.p2.getText().toUpperCase(), this.midpoint.getText().toUpperCase()};
        return objectArray;
    }

    protected void setFields(Object[] objectArray) {
        ((TextComponent)this.p1).setText((String)objectArray[0]);
        ((TextComponent)this.p2).setText((String)objectArray[1]);
        ((TextComponent)this.midpoint).setText((String)objectArray[2]);
    }

    protected boolean onOk() {
        String[] stringArray = new String[]{this.p1.getText().toUpperCase(), this.p2.getText().toUpperCase(), this.midpoint.getText().toUpperCase()};
        if (stringArray[0].equals("") || stringArray[1].equals("")) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Label", "No label assigned to end point");
            return false;
        }
        if (stringArray[0].equals(stringArray[1])) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Line", String.valueOf(stringArray[0]) + stringArray[1] + " is no line");
            return false;
        }
        if (stringArray[2].equals("")) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Label", "No label assigned to result");
            return false;
        }
        String string = this.solid.drawMidpoint(stringArray);
        if (string != null) {
            new GAlertDialog(GDialog.frame, "warn.gif", "Draw Failed", string);
            return false;
        }
        return true;
    }

    public void set(GProblem gProblem, int n, Object[] objectArray) {
        if (n == 2) {
            this.setFields(objectArray);
        } else {
            this.setTitle("Bisect Segment in Solid " + this.solid.getLabel());
            this.defaultMidpoint = gProblem.supplyLabel();
            GEdgeNode gEdgeNode = this.solid.getSelectedEdges().getHead();
            if (gEdgeNode != null) {
                GEdge gEdge = gEdgeNode.getEdge();
                ((TextComponent)this.p1).setText(gEdge.getHead().getLabel());
                ((TextComponent)this.p2).setText(gEdge.getTail().getLabel());
            }
        }
        if (n == 0) {
            this.show();
            return;
        }
        if (n != 2) {
            ((TextComponent)this.midpoint).setText(this.defaultMidpoint);
        }
        this.result = this.onOk() ? 0 : 1;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.getOneButton) {
            if (this.defaultMidpoint == null) {
                new GAlertDialog(GDialog.frame, "warn.gif", "GEOMETRIA", "No more labels available");
                return;
            }
            ((TextComponent)this.midpoint).setText(this.defaultMidpoint);
        }
    }
}

