/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;

public class GOpenShapeDialog
extends GShapeDialog {
    private GButton removeButton;

    public GOpenShapeDialog(GFrame gFrame, String string) {
        super(gFrame, string, "Open Shape");
        this.helpTopic = "open shape";
        this.okButton.setLabel("Open");
        this.pack();
        this.positionLeft();
        this.show();
    }

    protected void layShapeInput(GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
    }

    protected void layButtons(GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.buttonsPanel.add(this.okButton);
        this.removeButton = new GButton("Remove");
        this.removeButton.addActionListener(this);
        gridBagLayout.setConstraints(this.removeButton, gridBagConstraints);
        this.buttonsPanel.add(this.removeButton);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    protected boolean onOk() {
        return this.shapes.getSelectedItem() != null;
    }

    public String getShapeName() {
        return this.shapes.getSelectedItem();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10 || n == 32) {
            ActionEvent actionEvent = new ActionEvent(this.okButton, 0, null);
            this.actionPerformed(actionEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            ActionEvent actionEvent = new ActionEvent(this.okButton, 0, null);
            this.actionPerformed(actionEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.removeButton) {
            String string = this.shapes.getSelectedItem();
            if (string == null) {
                return;
            }
            GYNPromptDialog gYNPromptDialog = new GYNPromptDialog(GDialog.frame, "Remove " + '\'' + string + '\'' + " ?");
            if (gYNPromptDialog.result == 2) {
                File file = new File(GShapeDialog.shapeDir, string);
                file.delete();
                this.shapes.remove(string);
            }
        }
    }
}

