/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class GVariableList
implements Serializable {
    private GVariableNode head;
    private GVariableNode tail;
    private int dim = 0;

    public void print() {
        GVariableNode gVariableNode = this.head;
        while (gVariableNode != null) {
            gVariableNode.getVariable().print();
            gVariableNode = gVariableNode.getNext();
        }
    }

    public GVariableNode getHead() {
        return this.head;
    }

    public GVariableNode getTail() {
        return this.tail;
    }

    public int getDim() {
        return this.dim;
    }

    public void addToHead(GVariable gVariable) {
        GVariableNode gVariableNode = new GVariableNode(gVariable);
        if (this.head == null) {
            this.head = this.tail = gVariableNode;
        } else {
            this.head.setPrev(gVariableNode);
            gVariableNode.setNext(this.head);
            this.head = gVariableNode;
        }
        ++this.dim;
    }

    public void addToTail(GVariable gVariable) {
        GVariableNode gVariableNode = new GVariableNode(gVariable);
        if (this.head == null) {
            this.head = this.tail = gVariableNode;
        } else {
            this.tail.setNext(gVariableNode);
            gVariableNode.setPrev(this.tail);
            this.tail = gVariableNode;
        }
        ++this.dim;
    }

    public void flush() {
        this.tail = null;
        this.head = null;
        this.dim = 0;
    }

    public GVariable seek(String string) {
        GVariableNode gVariableNode = this.head;
        while (gVariableNode != null) {
            GVariable gVariable = gVariableNode.getVariable();
            if (string.equals(gVariable.getName())) {
                return gVariable;
            }
            gVariableNode = gVariableNode.getNext();
        }
        return null;
    }

    public boolean seek(GVariable gVariable) {
        GVariableNode gVariableNode = this.head;
        while (gVariableNode != null) {
            GVariable gVariable2 = gVariableNode.getVariable();
            if (gVariable == gVariable2) {
                return true;
            }
            gVariableNode = gVariableNode.getNext();
        }
        return false;
    }
}

