/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.Arrays;
import sun.dc.path.FastPathProducer;
import sun.dc.path.PathConsumer;
import sun.dc.path.PathException;
import sun.dc.pr.PathDasher;
import sun.dc.pr.PathStroker;

public class BasicStroke
implements Stroke {
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    float width;
    int join;
    int cap;
    float miterlimit;
    float[] dash;
    float dash_phase;
    private static final int[] RasterizerCaps = new int[]{30, 10, 20};
    private static final int[] RasterizerCorners = new int[]{50, 10, 40};

    public BasicStroke(float f, int n, int n2, float f2, float[] fArray, float f3) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("negative width");
        }
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("illegal end cap value");
        }
        if (n2 == 0) {
            if (f2 < 1.0f) {
                throw new IllegalArgumentException("miter limit < 1");
            }
        } else if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("illegal line join value");
        }
        if (fArray != null) {
            if (f3 < 0.0f) {
                throw new IllegalArgumentException("negative dash phase");
            }
            boolean bl = true;
            int n3 = 0;
            while (n3 < fArray.length) {
                float f4 = fArray[n3];
                if ((double)f4 > 0.0) {
                    bl = false;
                } else if ((double)f4 < 0.0) {
                    throw new IllegalArgumentException("negative dash length");
                }
                ++n3;
            }
            if (bl) {
                throw new IllegalArgumentException("dash lengths all zero");
            }
        }
        this.width = f;
        this.cap = n;
        this.join = n2;
        this.miterlimit = f2;
        if (fArray != null) {
            this.dash = (float[])fArray.clone();
        }
        this.dash_phase = f3;
    }

    public BasicStroke(float f, int n, int n2, float f2) {
        this(f, n, n2, f2, null, 0.0f);
    }

    public BasicStroke(float f, int n, int n2) {
        this(f, n, n2, 10.0f, null, 0.0f);
    }

    public BasicStroke(float f) {
        this(f, 2, 0, 10.0f, null, 0.0f);
    }

    public BasicStroke() {
        this(1.0f, 2, 0, 10.0f, null, 0.0f);
    }

    public Shape createStrokedShape(Shape shape) {
        Object object;
        Object object2;
        FillAdapter fillAdapter = new FillAdapter();
        PathStroker pathStroker = new PathStroker(fillAdapter);
        pathStroker.setPenDiameter(this.width);
        pathStroker.setPenT4(null);
        pathStroker.setCaps(RasterizerCaps[this.cap]);
        pathStroker.setCorners(RasterizerCorners[this.join], this.miterlimit);
        if (this.dash != null) {
            object2 = new PathDasher(pathStroker);
            ((PathDasher)object2).setDash(this.dash, this.dash_phase);
            ((PathDasher)object2).setDashT4(null);
            object = object2;
        } else {
            object = pathStroker;
        }
        object2 = shape.getPathIterator(null);
        try {
            object.beginPath();
            boolean bl = false;
            float f = 0.0f;
            float f2 = 0.0f;
            float[] fArray = new float[6];
            while (!object2.isDone()) {
                int n = object2.currentSegment(fArray);
                if (bl) {
                    bl = false;
                    if (n != 0) {
                        object.beginSubpath(f, f2);
                    }
                }
                switch (n) {
                    case 0: {
                        f = fArray[0];
                        f2 = fArray[1];
                        object.beginSubpath(fArray[0], fArray[1]);
                        break;
                    }
                    case 1: {
                        object.appendLine(fArray[0], fArray[1]);
                        break;
                    }
                    case 2: {
                        object.appendQuadratic(fArray[0], fArray[1], fArray[2], fArray[3]);
                        break;
                    }
                    case 3: {
                        object.appendCubic(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                        break;
                    }
                    case 4: {
                        object.closedSubpath();
                        bl = true;
                    }
                }
                object2.next();
            }
            object.endPath();
        }
        catch (PathException pathException) {
            throw new InternalError("Unable to Stroke shape (" + pathException.getMessage() + ")");
        }
        return fillAdapter.getShape();
    }

    public float getLineWidth() {
        return this.width;
    }

    public int getEndCap() {
        return this.cap;
    }

    public int getLineJoin() {
        return this.join;
    }

    public float getMiterLimit() {
        return this.miterlimit;
    }

    public float[] getDashArray() {
        if (this.dash == null) {
            return null;
        }
        return (float[])this.dash.clone();
    }

    public float getDashPhase() {
        return this.dash_phase;
    }

    public int hashCode() {
        int n = Float.floatToIntBits(this.width);
        n = n * 31 + this.join;
        n = n * 31 + this.cap;
        n = n * 31 + Float.floatToIntBits(this.miterlimit);
        if (this.dash != null) {
            n = n * 31 + Float.floatToIntBits(this.dash_phase);
            int n2 = 0;
            while (n2 < this.dash.length) {
                n = n * 31 + Float.floatToIntBits(this.dash[n2]);
                ++n2;
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BasicStroke)) {
            return false;
        }
        BasicStroke basicStroke = (BasicStroke)object;
        if (this.width != basicStroke.width) {
            return false;
        }
        if (this.join != basicStroke.join) {
            return false;
        }
        if (this.cap != basicStroke.cap) {
            return false;
        }
        if (this.miterlimit != basicStroke.miterlimit) {
            return false;
        }
        if (this.dash != null) {
            if (this.dash_phase != basicStroke.dash_phase) {
                return false;
            }
            if (!Arrays.equals(this.dash, basicStroke.dash)) {
                return false;
            }
        } else if (basicStroke.dash != null) {
            return false;
        }
        return true;
    }

    private class FillAdapter
    implements PathConsumer {
        boolean closed;
        GeneralPath path = new GeneralPath(1);

        public Shape getShape() {
            return this.path;
        }

        public void beginPath() {
        }

        public void beginSubpath(float f, float f2) {
            if (this.closed) {
                this.path.closePath();
                this.closed = false;
            }
            this.path.moveTo(f, f2);
        }

        public void appendLine(float f, float f2) {
            this.path.lineTo(f, f2);
        }

        public void appendQuadratic(float f, float f2, float f3, float f4) {
            this.path.quadTo(f, f2, f3, f4);
        }

        public void appendCubic(float f, float f2, float f3, float f4, float f5, float f6) {
            this.path.curveTo(f, f2, f3, f4, f5, f6);
        }

        public void closedSubpath() {
            this.closed = true;
        }

        public void endPath() {
            if (this.closed) {
                this.path.closePath();
                this.closed = false;
            }
        }

        public void useProxy(FastPathProducer fastPathProducer) throws PathException {
            fastPathProducer.sendTo(this);
        }

        public long getCPathConsumer() {
            return 0L;
        }
    }
}

