/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.TreeCellRenderer;

public class DefaultTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected boolean selected;
    protected boolean hasFocus;
    private boolean drawsFocusBorderAroundIcon;
    protected transient Icon closedIcon;
    protected transient Icon leafIcon;
    protected transient Icon openIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;

    public DefaultTreeCellRenderer() {
        this.setHorizontalAlignment(2);
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
        Object object = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.drawsFocusBorderAroundIcon = object != null && (Boolean)object != false;
    }

    public Icon getDefaultOpenIcon() {
        return UIManager.getIcon("Tree.openIcon");
    }

    public Icon getDefaultClosedIcon() {
        return UIManager.getIcon("Tree.closedIcon");
    }

    public Icon getDefaultLeafIcon() {
        return UIManager.getIcon("Tree.leafIcon");
    }

    public void setOpenIcon(Icon icon) {
        this.openIcon = icon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public void setClosedIcon(Icon icon) {
        this.closedIcon = icon;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public void setLeafIcon(Icon icon) {
        this.leafIcon = icon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setTextSelectionColor(Color color) {
        this.textSelectionColor = color;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color color) {
        this.textNonSelectionColor = color;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color color) {
        this.backgroundSelectionColor = color;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color color) {
        this.backgroundNonSelectionColor = color;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
        this.hasFocus = bl4;
        this.setText(string);
        if (bl) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        if (!jTree.isEnabled()) {
            this.setEnabled(false);
            if (bl3) {
                this.setDisabledIcon(this.getLeafIcon());
            } else if (bl2) {
                this.setDisabledIcon(this.getOpenIcon());
            } else {
                this.setDisabledIcon(this.getClosedIcon());
            }
        } else {
            this.setEnabled(true);
            if (bl3) {
                this.setIcon(this.getLeafIcon());
            } else if (bl2) {
                this.setIcon(this.getOpenIcon());
            } else {
                this.setIcon(this.getClosedIcon());
            }
        }
        this.setComponentOrientation(jTree.getComponentOrientation());
        this.selected = bl;
        return this;
    }

    public void paint(Graphics graphics) {
        Object object;
        Color color;
        if (this.selected) {
            color = this.getBackgroundSelectionColor();
        } else {
            color = this.getBackgroundNonSelectionColor();
            if (color == null) {
                color = this.getBackground();
            }
        }
        int n = -1;
        if (color != null) {
            object = this.getIcon();
            n = this.getLabelStart();
            graphics.setColor(color);
            if (this.getComponentOrientation().isLeftToRight()) {
                graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight());
            } else {
                graphics.fillRect(0, 0, this.getWidth() - 1 - n, this.getHeight());
            }
        }
        if (this.hasFocus) {
            if (this.drawsFocusBorderAroundIcon) {
                n = 0;
            } else if (n == -1) {
                n = this.getLabelStart();
            }
            object = this.getBorderSelectionColor();
            if (object != null) {
                graphics.setColor((Color)object);
                if (this.getComponentOrientation().isLeftToRight()) {
                    graphics.drawRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
                } else {
                    graphics.drawRect(0, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
                }
            }
        }
        super.paint(graphics);
    }

    private int getLabelStart() {
        Icon icon = this.getIcon();
        if (icon != null && this.getText() != null) {
            return icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return 0;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            dimension = new Dimension(dimension.width + 3, dimension.height);
        }
        return dimension;
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text") {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, byte by, byte by2) {
    }

    public void firePropertyChange(String string, char c, char c2) {
    }

    public void firePropertyChange(String string, short s, short s2) {
    }

    public void firePropertyChange(String string, int n, int n2) {
    }

    public void firePropertyChange(String string, long l, long l2) {
    }

    public void firePropertyChange(String string, float f, float f2) {
    }

    public void firePropertyChange(String string, double d, double d2) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

