/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.server.LogStream;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.DGCClient;
import sun.rmi.transport.DGCImpl;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.LiveRef;

class ConnectionInputStream
extends MarshalInputStream {
    private boolean dgcAckNeeded = false;
    private Map incomingRefTable = new HashMap(5);
    private UID ackID;

    ConnectionInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    void readID() throws IOException {
        this.ackID = UID.read(this);
    }

    void saveRef(LiveRef liveRef) {
        Endpoint endpoint = liveRef.getEndpoint();
        List list = (List)this.incomingRefTable.get(endpoint);
        if (list == null) {
            list = new ArrayList();
            this.incomingRefTable.put(endpoint, list);
        }
        list.add(liveRef);
    }

    void registerRefs() throws IOException {
        if (!this.incomingRefTable.isEmpty()) {
            Set set = this.incomingRefTable.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Endpoint endpoint = (Endpoint)entry.getKey();
                List list = (List)entry.getValue();
                DGCClient.registerRefs(endpoint, list);
            }
        }
    }

    void setAckNeeded() {
        this.dgcAckNeeded = true;
    }

    void done(Connection connection) {
        if (this.dgcAckNeeded) {
            Connection connection2 = null;
            Channel channel = null;
            boolean bl = true;
            if (DGCImpl.logLevel >= 20) {
                LogStream.log("dgc").println("ConnectionInputStream.done: send ack");
            }
            try {
                channel = connection.getChannel();
                connection2 = channel.newConnection();
                DataOutputStream dataOutputStream = new DataOutputStream(connection2.getOutputStream());
                dataOutputStream.writeByte(84);
                if (this.ackID == null) {
                    this.ackID = new UID();
                }
                this.ackID.write(dataOutputStream);
                connection2.releaseOutputStream();
                connection2.getInputStream().available();
                connection2.releaseInputStream();
            }
            catch (RemoteException remoteException) {
                bl = false;
            }
            catch (IOException iOException) {
                bl = false;
            }
            try {
                if (connection2 != null) {
                    channel.free(connection2, bl);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

