Attribute VB_Name = "Module1"
'/*****************************************************************************
'*                                                                            *
'* Copyright (c) 1996-2000 Funduc Software Inc.   All rights reserved.        *
'*                                                                            *
'* These programs are the sole property of Funduc Software Inc. and contain   *
'* proprietary information.  These routines should not by used by anyone      *
'* except Funduc Software Inc.'s customers in accoordance with terms of a     *
'* license.  To get one, visit us at http://www.funduc.com                    *
'* or E-MAIL: sales@funduc.com                                                *
'*                                                                            *
'*****************************************************************************/
Global Const PROMPT_ALL As Long = 0        '/* DLL prompts for everything */
Global Const PROMPT_NONE As Long = 1       '/* No prompts, file names passed in are used */
Global Const PROMPT_OVERWRITE As Long = 2  '/* DLL only prompts for overwrites */

Global Const NONE_TYPE As Long = 0         '/* Returned from decoding routine */
Global Const UUE_TYPE As Long = 1          '/* DLL prompts for everything */
Global Const MIME_TYPE As Long = 2         '/* No prompts, file names passed in are used */
Global Const BINHEX_TYPE As Long = 3       '/* BinHex (Macintosh) encoding */
Global Const XXE_TYPE As Long = 4          '/* XXENCODED file */
Global Const TEXT_TYPE As Long = 5         '/* 7-bit or quoted-printable - encoding quoted-printable */

'/* Values for the GetMessageHeaderField() function */
Global Const DECENC_MSG_DATE_TIME_RECEIVED = 0  '/* To request the Date/Time received string */
Global Const DECENC_MSG_FROM = 1                '/* To request the From string */
Global Const DECENC_MSG_TO = 2                  '/* To request the To string */
Global Const DECENC_MSG_SUBJECT = 3             '/* To request the Subject */
Global Const DECENC_MSG_DATE_TIME_SENT = 4      '/* To request the Date/Time sent string */
Global Const DECENC_MSG_CC = 5                  '/* To request the CC string */
Global Const DECENC_MSG_REPLY_TO = 6            '/* To request the Reply To string */
Global Const DECENC_MSG_COMPANY = 7             '/* To request the Organization string */

'/* How many files are encoded */
'int WINAPI GetNumFilesToDecode(LPCSTR szInFile);
Declare Function GetNumFilesToDecode Lib "decenc32.dll" (ByVal strInFile As String) As Long

'/* 0 relative index into the array of names (see call above) */
'int WINAPI GetEncodedFile(LPSTR szOutFile, int nIndex);
Declare Function GetEncodedFile Lib "decenc32.dll" (ByVal strOutFile As String, ByVal nIndex As Long) As Long

'/* If PROMPT_NONE is used for nPrompt, the names of the files to decode are assumed to be in
'   the strOutFile parameter.  That can be accomplished by calling GetNumFilesToDecode()
'   and GetEncodedFile in a loop to get the list of files first. The list of files passed
'   (after modification if needed) must then be delimited by the ';' character */
'/* Return code is one of the Encoding types above */
'int WINAPI DecodeFile(LPCSTR strInFile, LPCSTR szOutFile, int nPrompts);
Declare Function DecodeFile Lib "decenc32.dll" (ByVal strInFile As String, ByVal strOutFile As String, ByVal nPrompts As Long) As Long

'/* nAppend should be 0 to overwrite the output file, 1 to append (to encode more than one file
'   for example */
'/* Boundary should be passed in.  It needs to be listed in the message header as:
'    boundary="<your boundary>" */
'int WINAPI EncodeFile(LPCSTR strFileIn, LPCSTR szFileOut, LPCTSTR szBoundary, int nType, BOOL bAppend);
Declare Function EncodeFile Lib "decenc32.dll" (ByVal SourceFile As String, ByVal EncodedFile As String, ByVal strBoundary As String, ByVal CodeOption As Long, ByVal xAppend As Long) As Long

'/* Call after all files are encoded to append the final boundary */
'/* You can also append -- and 2 linefeeds to the end of the encoded file or */
'/* send that out with your message */
'void WINAPI FinishAttachments(LPCSTR strFileOut);
Declare Sub FinishAttachments Lib "decenc32.dll" (ByVal strFileOut As String)

'/* call with the name of registered application to write that to the encoded file */
'void WINAPI SetEncodingApplication(LPCSTR szInFile);
Declare Sub SetEncodingApplication Lib "decenc32.dll" (ByVal strInFile As String)

'/* Utility functions */
'/* This function will return TRUE if the name of the file had to be changed to avoid an overwrite */
'BOOL WINAPI GetUniqueFileName(LPSTR szFileName);
Declare Function GetUniqueFileName Lib "decenc32.dll" (ByVal szFileName As String) As Long

'/* This function will concatenate related files into the first one.  All files must
'   be found in the same directory.
'   For example: file1.dat, file2.dat, file3.dat will be concatenated into file1.dat
'   If bDeleteOthers is TRUE, file2.dat and file3.dat are deleted
'   This function returns TRUE when successful, FALSE otherwise
'*/
'BOOL WINAPI ConcatenateRelated(BOOL bDeleteOthers, LPSTR szFileName);
Declare Function ConcatenateRelated Lib "decenc32.dll" (ByVal bDeleteOthers As Long, ByVal szFileName As String) As Long

'/* This function will split a file into as many smaller files as necessary
'   For example: file.dat of size 100000 will be split into
'   file1.dat (size 35000), file2.dat(35000), file3.dat(size 30000)
'   if 35000 is used for the lFileSize parameter
'   This function returns TRUE when successful, FALSE otherwise
'*/
'BOOL WINAPI SplitFile(LPSTR szFileName, long lFileSize);
Declare Function SplitFile Lib "decenc32.dll" (ByVal szFileName As String, ByVal lFileSize As Long) As Long

'/* Use this function to encode a small buffer. The Output Buffer needs to be
'   different than the input buffer and needs to be roughly 1.5 times larger
'   Only UUE_TYPE, B64_TYPE and XXE_TYPE types are supported.
'*/
'int WINAPI EncodeBuffer(LPCSTR pBufferIn, LPSTR pBufferOut, int nInBufferSize, int nType);
Declare Function EncodeBuffer Lib "decenc32.dll" (ByVal pBufferIn As String, ByVal pBufferOut As String, ByVal nInBufferSize As Long, ByVal nType As Long) As Long

'/* Use this function to decode a small buffer. The Output Buffer needs to be
'   different than the input buffer and needs to be about the same size.
'   Only UUE_TYPE, B64_TYPE and XXE_TYPE types are supported.
'*/
'int WINAPI DecodeBuffer(LPCSTR pBufferIn, LPSTR pBufferOut, int nInBufferSize, int nType);
Declare Function DecodeBuffer Lib "decenc32.dll" (ByVal pBufferIn As String, ByVal pBufferOut As String, ByVal nInBufferSize As Long, ByVal nType As Long) As Long

'/* Use this function to retrieve the message information.  The information for
'   the file specified by szFileName is returned in the szBuffer field.  nSize
'   must be the allocated size of szBuffer (including room for the NULL byte)
'   and nField must be one of the DECENC_MSG_ defines above
'*/
'BOOL WINAPI GetMessageHeaderField(LPCTSTR szFileName, LPTSTR szBuffer, int nSize, int nField);
Declare Function GetMessageHeaderField Lib "decenc32.dll" (ByVal szFileName As String, ByVal szBuffer As String, ByVal nSize As Long, ByVal nField As Long) As Long

'/* Use this function to save just the text of a message to a file */
'/* Return code is one of the Encoding types above if successful */
'int  WINAPI GetMessageText(LPCTSTR szFileName, LPCTSTR szTargetFileName);
Declare Function GetMessageText Lib "decenc32.dll" (ByVal szFileName As String, ByVal szTargetFileName As String) As Long
