/*
 * Decompiled with CFR 0.152.
 */
package comgr;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class Palette {
    protected ColorModel colorModel;
    protected byte[] a = new byte[256];
    protected byte[] r = new byte[256];
    protected byte[] g = new byte[256];
    protected byte[] b = new byte[256];
    int transparent = 7;

    Palette() {
        this.fill();
        this.setColorModel();
    }

    public void setColorModel() {
        this.colorModel = new IndexColorModel(8, this.r.length, this.r, this.g, this.b, this.a);
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public void fill() {
        for (int i = 0; i < this.a.length; ++i) {
            this.a[i] = -1;
            this.r[i] = (byte)i;
            this.g[i] = (byte)i;
            this.b[i] = (byte)i;
        }
        this.a[this.transparent] = 0;
    }

    public void setTransparent(int n) {
        this.transparent = n;
        this.colorModel = new IndexColorModel(8, this.r.length, this.r, this.g, this.b, n);
    }

    public int getRGB(int n) {
        return this.a[n] << 24 | this.r[n] << 16 | this.g[n] << 8 | this.b[n];
    }

    public Color getColor(int n) {
        int n2 = this.colorModel.getRed(n);
        int n3 = this.colorModel.getGreen(n);
        int n4 = this.colorModel.getBlue(n);
        return new Color(n2, n3, n4);
    }

    public Color[] getColors() {
        int n = this.r.length;
        Color[] colorArray = new Color[n];
        for (int i = 0; i < n; ++i) {
            colorArray[i] = this.getColor(i);
        }
        return colorArray;
    }

    public void changeColor(int n, Color color) {
        int n2 = color.getRGB();
        this.r[n] = (byte)(n2 >> 16 & 0xFF);
        this.g[n] = (byte)(n2 >> 8 & 0xFF);
        this.b[n] = (byte)(n2 & 0xFF);
    }

    public void display(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n4 / 16;
        int n6 = n3 / 16;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                graphics.setColor(this.getColor(i * 16 + j));
                graphics.fillRect(n + j * n6, n2 + i * n5, n6, n5);
            }
        }
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, n3, n4);
    }

    public void rotate(int n) {
        int n2;
        int n3 = n2 = n;
        int n4 = this.r.length;
        while (n3 != 0) {
            int n5 = n2;
            n2 = (n2 + n) % n4;
            byte by = this.r[n5];
            this.r[n5] = this.r[n2];
            this.r[n2] = by;
            by = this.g[n5];
            this.g[n5] = this.g[n2];
            this.g[n2] = by;
            by = this.b[n5];
            this.b[n5] = this.b[n2];
            this.b[n2] = by;
            if (n2 != n3) continue;
            n2 = --n3;
        }
    }

    public void rotateRed(int n) {
        int n2;
        int n3 = n2 = n;
        int n4 = this.r.length;
        while (n3 != 0) {
            int n5 = n2;
            n2 = (n2 + n) % n4;
            byte by = this.r[n5];
            this.r[n5] = this.r[n2];
            this.r[n2] = by;
            if (n2 != n3) continue;
            n2 = --n3;
        }
    }

    public void rotateGreen(int n) {
        int n2;
        int n3 = n2 = n;
        int n4 = this.r.length;
        while (n3 != 0) {
            int n5 = n2;
            n2 = (n2 + n) % n4;
            byte by = this.g[n5];
            this.g[n5] = this.g[n2];
            this.g[n2] = by;
            if (n2 != n3) continue;
            n2 = --n3;
        }
    }

    public void rotateBlue(int n) {
        int n2;
        int n3 = n2 = n;
        int n4 = this.r.length;
        while (n3 != 0) {
            int n5 = n2;
            n2 = (n2 + n) % n4;
            byte by = this.b[n5];
            this.b[n5] = this.b[n2];
            this.b[n2] = by;
            if (n2 != n3) continue;
            n2 = --n3;
        }
    }
}

