/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.distribution;

import org.nakedobjects.object.NakedCollection;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedObjectStore;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.distribution.Request;
import org.nakedobjects.object.distribution.Server;

class ContainsElementRequest
extends Request {
    private static final long serialVersionUID = 1L;
    private Object elementOid;
    private Object collectionOid;

    public ContainsElementRequest(NakedCollection nakedCollection, NakedObject nakedObject) {
        this.collectionOid = nakedCollection.getOid();
        this.elementOid = nakedObject.getOid();
    }

    public boolean contains() throws ObjectStoreException {
        this.sendRequest();
        return (Boolean)this.response;
    }

    void generateResponse(Server server) {
        try {
            NakedObjectStore nakedObjectStore = server.getObjectStore();
            this.response = new Boolean(nakedObjectStore.containsElement((NakedCollection)nakedObjectStore.getObject(this.collectionOid), nakedObjectStore.getObject(this.elementOid)));
        }
        catch (ObjectStoreException objectStoreException) {
            this.response = objectStoreException;
        }
    }

    public String toString() {
        return "Contains element [collection=" + this.collectionOid + ",test=" + this.elementOid + "]";
    }
}

