/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.value;

import org.nakedobjects.object.Naked;
import org.nakedobjects.object.NakedValue;
import org.nakedobjects.object.Title;
import org.nakedobjects.object.ValueParseException;
import org.nakedobjects.object.value.AbstractNakedValue;

public class Option
extends AbstractNakedValue {
    String[] options;
    int selection;

    public Option(String[] stringArray) {
        this(stringArray, 0);
    }

    public Option(String[] stringArray, int n) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Options array must exist and have at least one element");
        }
        this.options = stringArray;
        this.selection = n;
    }

    public void clear() {
        this.selection = -1;
    }

    public void copyObject(Naked naked) {
        if (!(naked instanceof Option)) {
            throw new IllegalArgumentException("Can only copy the value of  a SelectionObject object");
        }
        this.selection = ((Option)naked).selection;
    }

    public String getObjectHelpText() {
        return "A Selection object.";
    }

    public String getOption(int n) {
        return this.options[n];
    }

    public String getOptionAt(int n) {
        return this.options[n];
    }

    public String[] getOptions() {
        return this.options;
    }

    public String getSelection() {
        return this.options[this.selection];
    }

    public int getSelectionIndex() {
        return this.selection;
    }

    public boolean isEmpty() {
        return this.selection == -1;
    }

    public boolean isSameAs(Naked naked) {
        if (naked instanceof Option) {
            return ((Option)naked).getSelection().equals(this.getSelection());
        }
        return false;
    }

    public int noOptions() {
        return this.options.length;
    }

    public void parse(String string) throws ValueParseException {
        this.setSelection(string);
    }

    public void reset() {
        this.selection = 0;
    }

    public void setSelection(String string) {
        int n = 0;
        while (n < this.options.length) {
            if (this.options[n].equalsIgnoreCase(string)) {
                this.selection = n;
                break;
            }
            ++n;
        }
    }

    public void setSelectionIndex(int n) {
        if (0 > n && n >= this.options.length) {
            throw new IllegalArgumentException("Selection value must index one of the available options");
        }
        this.selection = n;
    }

    public String stringValue() {
        return this.getSelection();
    }

    public Title title() {
        return new Title(this.options == null ? "none" : (this.selection >= 0 ? this.options[this.selection] : ""));
    }

    public void update(NakedValue nakedValue) {
        this.selection = ((Option)nakedValue).selection;
    }

    public boolean hasOption(String string) {
        int n = 0;
        while (n < this.options.length) {
            if (this.options[n].equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void restoreString(String string) {
        this.setSelection(string);
    }

    public String saveString() {
        return this.getSelection();
    }
}

