/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.persistence.file;

import java.util.Hashtable;
import java.util.Vector;
import org.nakedobjects.object.ObjectNotFoundException;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.persistence.file.Data;
import org.nakedobjects.persistence.file.DataManager;

public class InMemoryDataManager
extends DataManager {
    private Hashtable objects = new Hashtable();
    private Hashtable indexes = new Hashtable();
    private Hashtable serialNumbers = new Hashtable();
    private int nextId = 100;

    protected long nextId() {
        ++this.nextId;
        return this.nextId;
    }

    protected void writeInstanceFile(String string, Vector vector) {
        this.indexes.put(string, vector);
    }

    protected void deleteFile(long l) {
        this.objects.remove("" + l);
    }

    protected void writeDataFile(long l, Data data) {
        String string = "" + l;
        if (data.getOid() == null) {
            throw new IllegalArgumentException("Oid must be non-null");
        }
        this.objects.put(string, data);
    }

    protected Data readDataFile(long l) throws ObjectNotFoundException {
        String string = "" + l;
        if (!this.objects.containsKey(string)) {
            throw new ObjectNotFoundException("No data for " + string);
        }
        return (Data)this.objects.get(string);
    }

    protected long readSerialNumberFile(String string) {
        if (!this.serialNumbers.containsKey(string)) {
            return 0L;
        }
        return Long.valueOf((String)this.serialNumbers.get(string));
    }

    protected void writeSerialNumberFile(String string, long l) {
        this.serialNumbers.put(string, "" + l);
    }

    protected Vector readInstanceFile(String string) throws ObjectStoreException {
        Vector vector = (Vector)this.indexes.get(string);
        if (vector == null) {
            vector = new Vector();
        }
        return vector;
    }
}

